/**
 * \file: rn_src_coeffs.h
 *
 * ADIT SRC core implementation - Filter koefficients.
 *
 * author: Andreas Pape / ADIT / SW1 / apape@de.adit-jv.com
 *
 * copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/
#ifndef __RN_SRC_COEFFS_H__
#define __RN_SRC_COEFFS_H__

static const float src_coeffs[129][FILT_LEN_SRC] __attribute__ ((aligned (32))) =
{
	{ /* Polyphase 0 */
		(float)  0.000000000e+00,	(float) -5.275576381e-06,
		(float)  1.559305896e-05,	(float) -3.314091266e-05,
		(float)  5.955419489e-05,	(float) -9.553249050e-05,
		(float)  1.401216937e-04,	(float) -1.899156645e-04,
		(float)  2.382571600e-04,	(float) -2.745386997e-04,
		(float)  2.837167727e-04,	(float) -2.461537593e-04,
		(float)  1.378888961e-04,	(float)  6.858818064e-05,
		(float) -4.030292381e-04,	(float)  8.956047228e-04,
		(float) -1.574644886e-03,	(float)  2.464081446e-03,
		(float) -3.580778098e-03,	(float)  4.931976487e-03,
		(float) -6.513103355e-03,	(float)  8.306180406e-03,
		(float) -1.027904905e-02,	(float)  1.238556852e-02,
		(float) -1.456687145e-02,	(float)  1.675367227e-02,
		(float) -1.886952873e-02,	(float)  2.083486500e-02,
		(float) -2.257148593e-02,	(float)  2.400725449e-02,
		(float) -2.508057509e-02,	(float)  2.574432846e-02,
		(float)  4.740310601e-01,	(float)  2.574432846e-02,
		(float) -2.508057509e-02,	(float)  2.400725449e-02,
		(float) -2.257148593e-02,	(float)  2.083486500e-02,
		(float) -1.886952873e-02,	(float)  1.675367227e-02,
		(float) -1.456687145e-02,	(float)  1.238556852e-02,
		(float) -1.027904905e-02,	(float)  8.306180406e-03,
		(float) -6.513103355e-03,	(float)  4.931976487e-03,
		(float) -3.580778098e-03,	(float)  2.464081446e-03,
		(float) -1.574644886e-03,	(float)  8.956047228e-04,
		(float) -4.030292381e-04,	(float)  6.858818064e-05,
		(float)  1.378888961e-04,	(float) -2.461537593e-04,
		(float)  2.837167727e-04,	(float) -2.745386997e-04,
		(float)  2.382571600e-04,	(float) -1.899156645e-04,
		(float)  1.401216937e-04,	(float) -9.553249050e-05,
		(float)  5.955419489e-05,	(float) -3.314091266e-05,
		(float)  1.559305896e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 1 */
		(float)  0.000000000e+00,	(float) -5.299272524e-06,
		(float)  1.564490732e-05,	(float) -3.331442121e-05,
		(float)  6.003189045e-05,	(float) -9.661933723e-05,
		(float)  1.422767567e-04,	(float) -1.937763239e-04,
		(float)  2.446491207e-04,	(float) -2.844645322e-04,
		(float)  2.983159385e-04,	(float) -2.666281263e-04,
		(float)  1.653896368e-04,	(float)  3.311379034e-05,
		(float) -3.590294973e-04,	(float)  8.431488202e-04,
		(float) -1.514674184e-03,	(float)  2.398677268e-03,
		(float) -3.513436548e-03,	(float)  4.867883618e-03,
		(float) -6.459410955e-03,	(float)  8.272296064e-03,
		(float) -1.027697820e-02,	(float)  1.243038963e-02,
		(float) -1.467750817e-02,	(float)  1.695429691e-02,
		(float) -1.919232021e-02,	(float)  2.132584473e-02,
		(float) -2.330414627e-02,	(float)  2.511966874e-02,
		(float) -2.690670807e-02,	(float)  2.960899822e-02,
		(float)  4.739881616e-01,	(float)  2.192621133e-02,
		(float) -2.325557066e-02,	(float)  2.288806087e-02,
		(float) -2.182984120e-02,	(float)  2.033445104e-02,
		(float) -1.853760500e-02,	(float)  1.654459775e-02,
		(float) -1.444866814e-02,	(float)  1.233415915e-02,
		(float) -1.027553384e-02,	(float)  8.335453790e-03,
		(float) -6.563096021e-03,	(float)  4.993191596e-03,
		(float) -3.645959007e-03,	(float)  2.527930095e-03,
		(float) -1.633553150e-03,	(float)  9.473849899e-04,
		(float) -4.466438759e-04,	(float)  1.038845730e-04,
		(float)  1.104281805e-04,	(float) -2.256360436e-04,
		(float)  2.690317042e-04,	(float) -2.645129390e-04,
		(float)  2.317694350e-04,	(float) -1.859734204e-04,
		(float)  1.379032221e-04,	(float) -9.440036096e-05,
		(float)  5.904691691e-05,	(float) -3.295002849e-05,
		(float)  1.553240977e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 2 */
		(float)  0.000000000e+00,	(float) -5.319472005e-06,
		(float)  1.568780995e-05,	(float) -3.347027544e-05,
		(float)  6.047947544e-05,	(float) -9.765994584e-05,
		(float)  1.443667758e-04,	(float) -1.975527474e-04,
		(float)  2.509412307e-04,	(float) -2.942844233e-04,
		(float)  3.128207250e-04,	(float) -2.870476646e-04,
		(float)  1.929154413e-04,	(float) -2.519821855e-06,
		(float) -3.146673325e-04,	(float)  7.900435885e-04,
		(float) -1.453670208e-03,	(float)  2.331748178e-03,
		(float) -3.443964251e-03,	(float)  4.800939064e-03,
		(float) -6.402036918e-03,	(float)  8.233805498e-03,
		(float) -1.026930587e-02,	(float)  1.246857844e-02,
		(float) -1.478049507e-02,	(float)  1.714633584e-02,
		(float) -1.950577331e-02,	(float)  2.180708905e-02,
		(float) -2.402738829e-02,	(float)  2.622467370e-02,
		(float) -2.873303744e-02,	(float)  3.351932291e-02,
		(float)  4.738594804e-01,	(float)  1.815552385e-02,
		(float) -2.143261938e-02,	(float)  2.176271788e-02,
		(float) -2.107964888e-02,	(float)  1.982490796e-02,
		(float) -1.819675935e-02,	(float)  1.632721333e-02,
		(float) -1.432298530e-02,	(float)  1.227620898e-02,
		(float) -1.026645097e-02,	(float)  8.360114001e-03,
		(float) -6.609372926e-03,	(float)  5.051504518e-03,
		(float) -3.708950655e-03,	(float)  2.590193546e-03,
		(float) -1.691370491e-03,	(float)  9.984637789e-04,
		(float) -4.898510274e-04,	(float)  1.389843633e-04,
		(float)  8.302236637e-05,	(float) -2.050864321e-04,
		(float)  2.542692175e-04,	(float) -2.543932881e-04,
		(float)  2.251900631e-04,	(float) -1.819522726e-04,
		(float)  1.356230022e-04,	(float) -9.322392289e-05,
		(float)  5.851059754e-05,	(float) -3.274205521e-05,
		(float)  1.546310865e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 3 */
		(float)  0.000000000e+00,	(float) -5.336096992e-06,
		(float)  1.572162609e-05,	(float) -3.360820471e-05,
		(float)  6.089643504e-05,	(float) -9.865338060e-05,
		(float)  1.463901418e-04,	(float) -2.012423155e-04,
		(float)  2.571294371e-04,	(float) -3.039923885e-04,
		(float)  3.272226672e-04,	(float) -3.074008736e-04,
		(float)  2.204512724e-04,	(float) -3.829371793e-05,
		(float) -2.699657072e-04,	(float)  7.363157848e-04,
		(float) -1.391662786e-03,	(float)  2.263325729e-03,
		(float) -3.372392362e-03,	(float)  4.731170538e-03,
		(float) -6.341001401e-03,	(float)  8.190715969e-03,
		(float) -1.025601965e-02,	(float)  1.250009438e-02,
		(float) -1.487575285e-02,	(float)  1.732965746e-02,
		(float) -1.980968624e-02,	(float)  2.227830087e-02,
		(float) -2.474078112e-02,	(float)  2.732163979e-02,
		(float) -3.055862378e-02,	(float)  3.747438446e-02,
		(float)  4.736450583e-01,	(float)  1.443312211e-02,
		(float) -1.961263782e-02,	(float)  2.063185525e-02,
		(float) -2.032134838e-02,	(float)  1.930654459e-02,
		(float) -1.784720622e-02,	(float)  1.610166299e-02,
		(float) -1.418991379e-02,	(float)  1.221176891e-02,
		(float) -1.025182181e-02,	(float)  8.380161339e-03,
		(float) -6.651920112e-03,	(float)  5.106892483e-03,
		(float) -3.769725704e-03,	(float)  2.650843094e-03,
		(float) -1.748069122e-03,	(float)  1.048815723e-03,
		(float) -5.326286165e-04,	(float)  1.738691283e-04,
		(float)  5.568623822e-05,	(float) -1.845163447e-04,
		(float)  2.394377997e-04,	(float) -2.441858065e-04,
		(float)  2.185231904e-04,	(float) -1.778549307e-04,
		(float)  1.332827184e-04,	(float) -9.200416882e-05,
		(float)  5.794579028e-05,	(float) -3.251728687e-05,
		(float)  1.538530842e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 4 */
		(float)  0.000000000e+00,	(float) -5.349071327e-06,
		(float)  1.574621933e-05,	(float) -3.372794667e-05,
		(float)  6.128226812e-05,	(float) -9.959872616e-05,
		(float)  1.483452732e-04,	(float) -2.048424419e-04,
		(float)  2.632097227e-04,	(float) -3.135824751e-04,
		(float)  3.415133175e-04,	(float) -3.276762384e-04,
		(float)  2.479820242e-04,	(float) -7.418880769e-05,
		(float) -2.249478578e-04,	(float)  6.819926034e-04,
		(float) -1.328682400e-03,	(float)  2.193442398e-03,
		(float) -3.298753282e-03,	(float)  4.658607381e-03,
		(float) -6.276326622e-03,	(float)  8.143037263e-03,
		(float) -1.023711014e-02,	(float)  1.252490040e-02,
		(float) -1.496320611e-02,	(float)  1.750413444e-02,
		(float) -2.010386168e-02,	(float)  2.273918733e-02,
		(float) -2.544389723e-02,	(float)  2.840993816e-02,
		(float) -3.238252079e-02,	(float)  4.147324467e-02,
		(float)  4.733449657e-01,	(float)  1.075984102e-02,
		(float) -1.779653426e-02,	(float)  1.949610214e-02,
		(float) -1.955538148e-02,	(float)  1.877967330e-02,
		(float) -1.748916398e-02,	(float)  1.586809469e-02,
		(float) -1.404954817e-02,	(float)  1.214089317e-02,
		(float) -1.023167068e-02,	(float)  8.395598608e-03,
		(float) -6.690725693e-03,	(float)  5.159334383e-03,
		(float) -3.828258112e-03,	(float)  2.709851010e-03,
		(float) -1.803621957e-03,	(float)  1.098415943e-03,
		(float) -5.749548853e-04,	(float)  2.085206357e-04,
		(float)  2.843448040e-05,	(float) -1.639371619e-04,
		(float)  2.245459356e-04,	(float) -2.338965716e-04,
		(float)  2.117729888e-04,	(float) -1.736841304e-04,
		(float)  1.308840782e-04,	(float) -9.074210878e-05,
		(float)  5.735306066e-05,	(float) -3.227602483e-05,
		(float)  1.529916560e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 5 */
		(float)  0.000000000e+00,	(float) -5.358320610e-06,
		(float)  1.576145765e-05,	(float) -3.382924749e-05,
		(float)  6.163648768e-05,	(float) -1.004950881e-04,
		(float)  1.502306166e-04,	(float) -2.083505752e-04,
		(float)  2.691781090e-04,	(float) -3.230487658e-04,
		(float)  3.556842499e-04,	(float) -3.478622358e-04,
		(float)  2.754925303e-04,	(float) -1.101858587e-04,
		(float) -1.796372821e-04,	(float)  6.271016632e-04,
		(float) -1.264760172e-03,	(float)  2.122131564e-03,
		(float) -3.223080647e-03,	(float)  4.583280551e-03,
		(float) -6.208036852e-03,	(float)  8.090781700e-03,
		(float) -1.021257098e-02,	(float)  1.254296300e-02,
		(float) -1.504278350e-02,	(float)  1.766964386e-02,
		(float) -2.038810685e-02,	(float)  2.318946002e-02,
		(float) -2.613631266e-02,	(float)  2.948894096e-02,
		(float) -3.420377570e-02,	(float)  4.551494557e-02,
		(float)  4.729593005e-01,	(float)  7.136494059e-03,
		(float) -1.598520827e-02,	(float)  1.835608683e-02,
		(float) -1.878219208e-02,	(float)  1.824460985e-02,
		(float) -1.712285483e-02,	(float)  1.562666025e-02,
		(float) -1.390198666e-02,	(float)  1.206363935e-02,
		(float) -1.020602483e-02,	(float)  8.406431111e-03,
		(float) -6.725779853e-03,	(float)  5.208810779e-03,
		(float) -3.884523143e-03,	(float)  2.767190548e-03,
		(float) -1.858002632e-03,	(float)  1.147240062e-03,
		(float) -6.168084043e-04,	(float)  2.429208532e-04,
		(float)  1.281669604e-06,	(float) -1.433602187e-04,
		(float)  2.096021036e-04,	(float) -2.235316755e-04,
		(float)  2.049436540e-04,	(float) -1.694426327e-04,
		(float)  1.284288106e-04,	(float) -8.943876969e-05,
		(float)  5.673298582e-05,	(float) -3.201857752e-05,
		(float)  1.520484033e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 6 */
		(float)  0.000000000e+00,	(float) -5.363772275e-06,
		(float)  1.576721363e-05,	(float) -3.391186212e-05,
		(float)  6.195862129e-05,	(float) -1.013415938e-04,
		(float)  1.520446483e-04,	(float) -2.117642009e-04,
		(float)  2.750306580e-04,	(float) -3.323853822e-04,
		(float)  3.697270649e-04,	(float) -3.679473412e-04,
		(float)  3.029675724e-04,	(float) -1.462655064e-04,
		(float) -1.340577265e-04,	(float)  5.716709932e-04,
		(float) -1.199927843e-03,	(float)  2.049427501e-03,
		(float) -3.145409310e-03,	(float)  4.505222612e-03,
		(float) -6.136158407e-03,	(float)  8.033964128e-03,
		(float) -1.018239887e-02,	(float)  1.255425220e-02,
		(float) -1.511441770e-02,	(float)  1.782606725e-02,
		(float) -2.066223372e-02,	(float)  2.362883513e-02,
		(float) -2.681760727e-02,	(float)  3.055802171e-02,
		(float) -3.602142962e-02,	(float)  4.959850965e-02,
		(float)  4.724881889e-01,	(float)  3.563873000e-03,
		(float) -1.417955040e-02,	(float)  1.721243638e-02,
		(float) -1.800222598e-02,	(float)  1.770167322e-02,
		(float) -1.674850468e-02,	(float)  1.537751525e-02,
		(float) -1.374733110e-02,	(float)  1.198006830e-02,
		(float) -1.017491441e-02,	(float)  8.412666636e-03,
		(float) -6.757074848e-03,	(float)  5.255303907e-03,
		(float) -3.938497375e-03,	(float)  2.822835964e-03,
		(float) -1.911185512e-03,	(float)  1.195264211e-03,
		(float) -6.581680837e-04,	(float)  2.770519576e-04,
		(float) -2.575773276e-05,	(float) -1.227967988e-04,
		(float)  1.946147705e-04,	(float) -2.130972211e-04,
		(float)  1.980394024e-04,	(float) -1.651332213e-04,
		(float)  1.259186655e-04,	(float) -8.809519453e-05,
		(float)  5.608615405e-05,	(float) -3.174526014e-05,
		(float)  1.510249615e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 7 */
		(float)  0.000000000e+00,	(float) -5.365355669e-06,
		(float)  1.576336455e-05,	(float) -3.397555452e-05,
		(float)  6.224821141e-05,	(float) -1.021373928e-04,
		(float)  1.537858748e-04,	(float) -2.150808425e-04,
		(float)  2.807634754e-04,	(float) -3.415864885e-04,
		(float)  3.836333946e-04,	(float) -3.879200346e-04,
		(float)  3.303918879e-04,	(float) -1.824082640e-04,
		(float) -8.823317474e-05,	(float)  5.157290192e-04,
		(float) -1.134217764e-03,	(float)  1.975365358e-03,
		(float) -3.065775330e-03,	(float)  4.424467720e-03,
		(float) -6.060719641e-03,	(float)  7.972601929e-03,
		(float) -1.014659353e-02,	(float)  1.255874166e-02,
		(float) -1.517804551e-02,	(float)  1.797329068e-02,
		(float) -2.092605903e-02,	(float)  2.405703361e-02,
		(float) -2.748736492e-02,	(float)  3.161655555e-02,
		(float) -3.783451796e-02,	(float)  5.372294023e-02,
		(float)  4.719317848e-01,	(float)  4.274772325e-05,
		(float) -1.238044179e-02,	(float)  1.606577636e-02,
		(float) -1.721593061e-02,	(float)  1.715118536e-02,
		(float) -1.636634298e-02,	(float)  1.512081893e-02,
		(float) -1.358568682e-02,	(float)  1.189024412e-02,
		(float) -1.013837244e-02,	(float)  8.414315450e-03,
		(float) -6.784605003e-03,	(float)  5.298797685e-03,
		(float) -3.990158709e-03,	(float)  2.876762524e-03,
		(float) -1.963145705e-03,	(float)  1.242465049e-03,
		(float) -6.990131833e-04,	(float)  3.108963437e-04,
		(float) -5.266938806e-05,	(float) -1.022581283e-04,
		(float)  1.795923872e-04,	(float) -2.025993191e-04,
		(float)  1.910644695e-04,	(float) -1.607587019e-04,
		(float)  1.233554121e-04,	(float) -8.671244170e-05,
		(float)  5.541316440e-05,	(float) -3.145639446e-05,
		(float)  1.499229996e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 8 */
		(float)  0.000000000e+00,	(float) -5.363002132e-06,
		(float)  1.574979254e-05,	(float) -3.402009786e-05,
		(float)  6.250481584e-05,	(float) -1.028816577e-04,
		(float)  1.554528347e-04,	(float) -2.182980634e-04,
		(float)  2.863727121e-04,	(float) -3.506462945e-04,
		(float)  3.973949069e-04,	(float) -4.077688070e-04,
		(float)  3.577501788e-04,	(float) -2.185945334e-04,
		(float) -4.218783514e-05,	(float)  4.593045492e-04,
		(float) -1.067662876e-03,	(float)  1.899981143e-03,
		(float) -2.984215953e-03,	(float)  4.341051610e-03,
		(float) -5.981750936e-03,	(float)  7.906715011e-03,
		(float) -1.010515779e-02,	(float)  1.255640863e-02,
		(float) -1.523360788e-02,	(float)  1.811120484e-02,
		(float) -2.117940449e-02,	(float)  2.447378135e-02,
		(float) -2.814517379e-02,	(float)  3.266391964e-02,
		(float) -3.964207078e-02,	(float)  5.788722176e-02,
		(float)  4.712902703e-01,	(float) -3.426134025e-03,
		(float) -1.058875392e-02,	(float)  1.491673052e-02,
		(float) -1.642375484e-02,	(float)  1.659347109e-02,
		(float) -1.597660262e-02,	(float)  1.485673411e-02,
		(float) -1.341716266e-02,	(float)  1.179423413e-02,
		(float) -1.009643479e-02,	(float)  8.411390278e-03,
		(float) -6.808366706e-03,	(float)  5.339277711e-03,
		(float) -4.039486379e-03,	(float)  2.928946510e-03,
		(float) -2.013859072e-03,	(float)  1.288819764e-03,
		(float) -7.393233225e-04,	(float)  3.444366332e-04,
		(float) -7.943908782e-05,	(float) -8.175536958e-05,
		(float)  1.645433837e-04,	(float) -1.920440841e-04,
		(float)  1.840231067e-04,	(float) -1.563218994e-04,
		(float)  1.207408383e-04,	(float) -8.529158430e-05,
		(float)  5.471462620e-05,	(float) -3.115230852e-05,
		(float)  1.487442176e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 9 */
		(float)  0.000000000e+00,	(float) -5.356645072e-06,
		(float)  1.572638470e-05,	(float) -3.404527478e-05,
		(float)  6.272800811e-05,	(float) -1.035735847e-04,
		(float)  1.570440987e-04,	(float) -2.214134687e-04,
		(float)  2.918545676e-04,	(float) -3.595590597e-04,
		(float)  4.110033110e-04,	(float) -4.274821672e-04,
		(float)  3.850271195e-04,	(float) -2.548046147e-04,
		(float)  4.053871899e-06,	(float)  4.024267590e-04,
		(float) -1.000296699e-03,	(float)  1.823311706e-03,
		(float) -2.900769595e-03,	(float)  4.255011580e-03,
		(float) -5.899284692e-03,	(float)  7.836325809e-03,
		(float) -1.005809751e-02,	(float)  1.254723402e-02,
		(float) -1.528104994e-02,	(float)  1.823970511e-02,
		(float) -2.142209684e-02,	(float)  2.487880933e-02,
		(float) -2.879062654e-02,	(float)  3.369949344e-02,
		(float) -4.144311322e-02,	(float)  6.209032012e-02,
		(float)  4.705638549e-01,	(float) -6.842046842e-03,
		(float) -8.805348172e-03,	(float)  1.376592048e-02,
		(float) -1.562614867e-02,	(float)  1.602885786e-02,
		(float) -1.557951976e-02,	(float)  1.458542710e-02,
		(float) -1.324187081e-02,	(float)  1.169210878e-02,
		(float) -1.004914017e-02,	(float)  8.403906296e-03,
		(float) -6.828358409e-03,	(float)  5.376731270e-03,
		(float) -4.086460955e-03,	(float)  2.979365235e-03,
		(float) -2.063302239e-03,	(float)  1.334306091e-03,
		(float) -7.790784905e-04,	(float)  3.776556836e-04,
		(float) -1.060527611e-04,	(float) -6.129961601e-05,
		(float)  1.494761652e-04,	(float) -1.814376316e-04,
		(float)  1.769195790e-04,	(float) -1.518256571e-04,
		(float)  1.180767490e-04,	(float) -8.383370933e-05,
		(float)  5.399115861e-05,	(float) -3.083333637e-05,
		(float)  1.474903459e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 10 */
		(float)  0.000000000e+00,	(float) -5.346220043e-06,
		(float)  1.569303322e-05,	(float) -3.405087760e-05,
		(float)  6.291737782e-05,	(float) -1.042123944e-04,
		(float)  1.585582717e-04,	(float) -2.244247063e-04,
		(float)  2.972052915e-04,	(float) -3.683190961e-04,
		(float)  4.244503618e-04,	(float) -4.470486478e-04,
		(float)  4.122073653e-04,	(float) -2.910187176e-04,
		(float)  5.046732651e-05,	(float)  3.451251773e-04,
		(float) -9.321533077e-04,	(float)  1.745394720e-03,
		(float) -2.815475828e-03,	(float)  4.166386477e-03,
		(float) -5.813355316e-03,	(float)  7.761459277e-03,
		(float) -1.000542167e-02,	(float)  1.253120238e-02,
		(float) -1.532032107e-02,	(float)  1.835869164e-02,
		(float) -2.165396794e-02,	(float)  2.527185379e-02,
		(float) -2.942332059e-02,	(float)  3.472265904e-02,
		(float) -4.323666589e-02,	(float)  6.633118301e-02,
		(float)  4.697527760e-01,	(float) -1.020428787e-02,
		(float) -7.031075590e-03,	(float)  1.261396543e-02,
		(float) -1.482356304e-02,	(float)  1.545767559e-02,
		(float) -1.517533375e-02,	(float)  1.430706755e-02,
		(float) -1.305992681e-02,	(float)  1.158394163e-02,
		(float) -9.996530065e-03,	(float)  8.391881112e-03,
		(float) -6.844580619e-03,	(float)  5.411147337e-03,
		(float) -4.131064353e-03,	(float)  3.027997051e-03,
		(float) -2.111452604e-03,	(float)  1.378902320e-03,
		(float) -8.182590556e-04,	(float)  4.105365964e-04,
		(float) -1.324964815e-04,	(float) -4.090188555e-05,
		(float)  1.343991066e-04,	(float) -1.707860742e-04,
		(float)  1.697581627e-04,	(float) -1.472728345e-04,
		(float)  1.153649653e-04,	(float) -8.233991706e-05,
		(float)  5.324339021e-05,	(float) -3.049981783e-05,
		(float)  1.461631432e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 11 */
		(float)  0.000000000e+00,	(float) -5.331664821e-06,
		(float)  1.564963554e-05,	(float) -3.403670855e-05,
		(float)  6.307253103e-05,	(float) -1.047973322e-04,
		(float)  1.599939929e-04,	(float) -2.273294691e-04,
		(float)  3.024211866e-04,	(float) -3.769207722e-04,
		(float)  4.377278647e-04,	(float) -4.664568121e-04,
		(float)  4.392755609e-04,	(float) -3.272169712e-04,
		(float)  9.702772217e-05,	(float)  2.874296711e-04,
		(float) -8.632673236e-04,	(float)  1.666268668e-03,
		(float) -2.728375357e-03,	(float)  4.075216679e-03,
		(float) -5.723999206e-03,	(float)  7.682142885e-03,
		(float) -9.947142302e-03,	(float)  1.250830196e-02,
		(float) -1.535137494e-02,	(float)  1.846806939e-02,
		(float) -2.187485497e-02,	(float)  2.565265641e-02,
		(float) -3.004285832e-02,	(float)  3.573280151e-02,
		(float) -4.502174526e-02,	(float)  7.060874026e-02,
		(float)  4.688572987e-01,	(float) -1.351217698e-02,
		(float) -5.266776515e-03,	(float)  1.146148184e-02,
		(float) -1.401644959e-02,	(float)  1.488025651e-02,
		(float) -1.476428692e-02,	(float)  1.402182841e-02,
		(float) -1.287144943e-02,	(float)  1.146980931e-02,
		(float) -9.938648738e-03,	(float)  8.375334751e-03,
		(float) -6.857035892e-03,	(float)  5.442516571e-03,
		(float) -4.173279839e-03,	(float)  3.074821354e-03,
		(float) -2.158288349e-03,	(float)  1.422587306e-03,
		(float) -8.568457747e-04,	(float)  4.430627253e-04,
		(float) -1.587564744e-04,	(float) -2.057311528e-05,
		(float)  1.193205488e-04,	(float) -1.600955188e-04,
		(float)  1.625431428e-04,	(float) -1.426663055e-04,
		(float)  1.126073234e-04,	(float) -8.081132020e-05,
		(float)  5.247195853e-05,	(float) -3.015209821e-05,
		(float)  1.447643957e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 12 */
		(float)  0.000000000e+00,	(float) -5.312919479e-06,
		(float)  1.559609444e-05,	(float) -3.400257993e-05,
		(float)  6.319309066e-05,	(float) -1.053276690e-04,
		(float)  1.613499374e-04,	(float) -2.301254961e-04,
		(float)  3.074986109e-04,	(float) -3.853585161e-04,
		(float)  4.508276807e-04,	(float) -4.856952601e-04,
		(float)  4.662163490e-04,	(float) -3.633794352e-04,
		(float)  1.437100787e-04,	(float)  2.293704301e-04,
		(float) -7.936738912e-04,	(float)  1.585972820e-03,
		(float) -2.639510008e-03,	(float)  3.981544081e-03,
		(float) -5.631254742e-03,	(float)  7.598406609e-03,
		(float) -9.883274541e-03,	(float)  1.247852470e-02,
		(float) -1.537416953e-02,	(float)  1.856774825e-02,
		(float) -2.208460042e-02,	(float)  2.602096442e-02,
		(float) -3.064884733e-02,	(float)  3.672930919e-02,
		(float) -4.679736410e-02,	(float)  7.492190418e-02,
		(float)  4.678777153e-01,	(float) -1.676505698e-02,
		(float) -3.513280284e-03,	(float)  1.030908317e-02,
		(float) -1.320526039e-02,	(float)  1.429693490e-02,
		(float) -1.434662449e-02,	(float)  1.372988580e-02,
		(float) -1.267656064e-02,	(float)  1.134979143e-02,
		(float) -9.875543174e-03,	(float)  8.354289634e-03,
		(float) -6.865728827e-03,	(float)  5.470831322e-03,
		(float) -4.213092034e-03,	(float)  3.119818598e-03,
		(float) -2.203788452e-03,	(float)  1.465340476e-03,
		(float) -8.948198022e-04,	(float)  4.752176851e-04,
		(float) -1.848191239e-04,	(float) -3.241556077e-07,
		(float)  1.042487939e-04,	(float) -1.493720623e-04,
		(float)  1.552788108e-04,	(float) -1.380089574e-04,
		(float)  1.098056732e-04,	(float) -7.924904326e-05,
		(float)  5.167750958e-05,	(float) -2.979052808e-05,
		(float)  1.432959147e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 13 */
		(float)  0.000000000e+00,	(float) -5.289926460e-06,
		(float)  1.553231818e-05,	(float) -3.394831441e-05,
		(float)  6.327869680e-05,	(float) -1.058027017e-04,
		(float)  1.626248168e-04,	(float) -2.328105741e-04,
		(float)  3.124339799e-04,	(float) -3.936268191e-04,
		(float)  4.637417310e-04,	(float) -5.047526357e-04,
		(float)  4.930143786e-04,	(float) -3.994861102e-04,
		(float)  1.904892554e-04,	(float)  1.709779516e-04,
		(float) -7.234086635e-04,	(float)  1.504547215e-03,
		(float) -2.548922702e-03,	(float)  3.885412072e-03,
		(float) -5.535162268e-03,	(float)  7.510282923e-03,
		(float) -9.813836603e-03,	(float)  1.244186625e-02,
		(float) -1.538866715e-02,	(float)  1.865764304e-02,
		(float) -2.228305229e-02,	(float)  2.637653081e-02,
		(float) -3.124090064e-02,	(float)  3.771157404e-02,
		(float) -4.856253183e-02,	(float)  7.926956996e-02,
		(float)  4.668143458e-01,	(float) -1.996229374e-02,
		(float) -1.771404928e-03,	(float)  9.157379545e-03,
		(float) -1.239044772e-02,	(float)  1.370804698e-02,
		(float) -1.392259439e-02,	(float)  1.343141887e-02,
		(float) -1.247538548e-02,	(float)  1.122397060e-02,
		(float) -9.807263060e-03,	(float)  8.328770562e-03,
		(float) -6.870666055e-03,	(float)  5.496085629e-03,
		(float) -4.250486918e-03,	(float)  3.162970296e-03,
		(float) -2.247932690e-03,	(float)  1.507141842e-03,
		(float) -9.321626994e-04,	(float)  5.069853587e-04,
		(float) -2.106709798e-04,	(float)  1.983423532e-05,
		(float)  8.919210081e-05,	(float) -1.386217892e-04,
		(float)  1.479694617e-04,	(float) -1.333036881e-04,
		(float)  1.069618773e-04,	(float) -7.765422175e-05,
		(float)  5.086069746e-05,	(float) -2.941546294e-05,
		(float)  1.417595359e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 14 */
		(float)  0.000000000e+00,	(float) -5.262630651e-06,
		(float)  1.545822061e-05,	(float) -3.387374514e-05,
		(float)  6.332900707e-05,	(float) -1.062217542e-04,
		(float)  1.638173806e-04,	(float) -2.353825393e-04,
		(float)  3.172237691e-04,	(float) -4.017202389e-04,
		(float)  4.764620015e-04,	(float) -5.236176323e-04,
		(float)  5.196543133e-04,	(float) -4.355169490e-04,
		(float)  2.373399642e-04,	(float)  1.122830242e-04,
		(float) -6.525077833e-04,	(float)  1.422032642e-03,
		(float) -2.456657437e-03,	(float)  3.786865518e-03,
		(float) -5.435764075e-03,	(float)  7.417806790e-03,
		(float) -9.738849790e-03,	(float)  1.239832600e-02,
		(float) -1.539483453e-02,	(float)  1.873767363e-02,
		(float) -2.247006412e-02,	(float)  2.671911444e-02,
		(float) -3.181863692e-02,	(float)  3.867899197e-02,
		(float) -5.031625499e-02,	(float)  8.365061596e-02,
		(float)  4.656675375e-01,	(float) -2.310327643e-02,
		(float) -4.195686492e-05,	(float)  8.006977483e-03,
		(float) -1.157246385e-02,	(float)  1.311393071e-02,
		(float) -1.349244718e-02,	(float)  1.312660976e-02,
		(float) -1.226805204e-02,	(float)  1.109243227e-02,
		(float) -9.733860743e-03,	(float)  8.298804695e-03,
		(float) -6.871856231e-03,	(float)  5.518275212e-03,
		(float) -4.285451834e-03,	(float)  3.204259029e-03,
		(float) -2.290701651e-03,	(float)  1.547972009e-03,
		(float) -9.688564424e-04,	(float)  5.383499057e-04,
		(float) -2.362987639e-04,	(float)  3.989139718e-05,
		(float)  7.415868088e-05,	(float) -1.278507676e-04,
		(float)  1.406193923e-04,	(float) -1.285534055e-04,
		(float)  1.040778099e-04,	(float) -7.602800145e-05,
		(float)  5.002218384e-05,	(float) -2.902726301e-05,
		(float)  1.401571178e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 15 */
		(float)  0.000000000e+00,	(float) -5.230979458e-06,
		(float)  1.537372130e-05,	(float) -3.377871602e-05,
		(float)  6.334369702e-05,	(float) -1.065841774e-04,
		(float)  1.649264166e-04,	(float) -2.378392787e-04,
		(float)  3.218645163e-04,	(float) -4.096334033e-04,
		(float)  4.889805482e-04,	(float) -5.422790002e-04,
		(float)  5.461208404e-04,	(float) -4.714518670e-04,
		(float)  2.842367833e-04,	(float)  5.331671277e-05,
		(float) -5.810078655e-04,	(float)  1.338470621e-03,
		(float) -2.362759271e-03,	(float)  3.685950742e-03,
		(float) -5.333104386e-03,	(float)  7.321015647e-03,
		(float) -9.658338488e-03,	(float)  1.234790708e-02,
		(float) -1.539264281e-02,	(float)  1.880776494e-02,
		(float) -2.264549512e-02,	(float)  2.704848022e-02,
		(float) -3.238168074e-02,	(float)  3.963096311e-02,
		(float) -5.205753766e-02,	(float)  8.806390420e-02,
		(float)  4.644376645e-01,	(float) -2.618741758e-02,
		(float)  1.674269392e-03,	(float)  6.858479610e-03,
		(float) -1.075176077e-02,	(float)  1.251492558e-02,
		(float) -1.305643583e-02,	(float)  1.281564345e-02,
		(float) -1.205469133e-02,	(float)  1.095526479e-02,
		(float) -9.655391197e-03,	(float)  8.264421527e-03,
		(float) -6.869310024e-03,	(float)  5.537397476e-03,
		(float) -4.317975491e-03,	(float)  3.243668453e-03,
		(float) -2.332076741e-03,	(float)  1.587812183e-03,
		(float) -1.004883431e-03,	(float)  5.692957696e-04,
		(float) -2.616893770e-04,	(float)  5.983677288e-05,
		(float)  5.915669355e-05,	(float) -1.170650464e-04,
		(float)  1.332328982e-04,	(float) -1.237610249e-04,
		(float)  1.011553556e-04,	(float) -7.437153772e-05,
		(float)  4.916263752e-05,	(float) -2.862629295e-05,
		(float)  1.384905397e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 16 */
		(float)  0.000000000e+00,	(float) -5.194922871e-06,
		(float)  1.527874565e-05,	(float) -3.366308188e-05,
		(float)  6.332246038e-05,	(float) -1.068893503e-04,
		(float)  1.659507525e-04,	(float) -2.401787319e-04,
		(float)  3.263528240e-04,	(float) -4.173610132e-04,
		(float)  5.012895014e-04,	(float) -5.607255523e-04,
		(float)  5.723986791e-04,	(float) -5.072707535e-04,
		(float)  3.311541704e-04,	(float) -5.889658537e-06,
		(float) -5.089459779e-04,	(float)  1.253903380e-03,
		(float) -2.267274297e-03,	(float)  3.582715506e-03,
		(float) -5.227229336e-03,	(float)  7.219949394e-03,
		(float) -9.572330163e-03,	(float)  1.229061634e-02,
		(float) -1.538206755e-02,	(float)  1.886784706e-02,
		(float) -2.280921029e-02,	(float)  2.736439922e-02,
		(float) -3.292966277e-02,	(float)  4.056689222e-02,
		(float) -5.378538181e-02,	(float)  9.250828064e-02,
		(float)  4.631251282e-01,	(float) -2.921415329e-02,
		(float)  3.376491522e-03,	(float)  5.712484365e-03,
		(float) -9.928789977e-03,	(float)  1.191137241e-02,
		(float) -1.261481563e-02,	(float)  1.249870766e-02,
		(float) -1.183543726e-02,	(float)  1.081255928e-02,
		(float) -9.571911987e-03,	(float)  8.225652867e-03,
		(float) -6.863040102e-03,	(float)  5.553451506e-03,
		(float) -4.348047963e-03,	(float)  3.281183305e-03,
		(float) -2.372040192e-03,	(float)  1.626644177e-03,
		(float) -1.040226497e-03,	(float)  5.998076855e-04,
		(float) -2.868299053e-04,	(float)  7.965991402e-05,
		(float)  4.419424208e-05,	(float) -1.062706515e-04,
		(float)  1.258142717e-04,	(float) -1.189294680e-04,
		(float)  9.819640826e-05,	(float) -7.268599469e-05,
		(float)  4.828273403e-05,	(float) -2.821292158e-05,
		(float)  1.367617007e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 17 */
		(float)  0.000000000e+00,	(float) -5.154413538e-06,
		(float)  1.517322499e-05,	(float) -3.352670861e-05,
		(float)  6.326500945e-05,	(float) -1.071366802e-04,
		(float)  1.668892561e-04,	(float) -2.423988920e-04,
		(float)  3.306853610e-04,	(float) -4.248978461e-04,
		(float)  5.133810709e-04,	(float) -5.789461713e-04,
		(float)  5.984725891e-04,	(float) -5.429534826e-04,
		(float)  3.780664764e-04,	(float) -6.530452199e-05,
		(float) -4.363596231e-04,	(float)  1.168373837e-03,
		(float) -2.170249619e-03,	(float)  3.477208982e-03,
		(float) -5.118186956e-03,	(float)  7.114650381e-03,
		(float) -9.480855353e-03,	(float)  1.222646441e-02,
		(float) -1.536308882e-02,	(float)  1.891785526e-02,
		(float) -2.296108045e-02,	(float)  2.766664887e-02,
		(float) -3.346221998e-02,	(float)  4.148618895e-02,
		(float) -5.549878780e-02,	(float)  9.698257561e-02,
		(float)  4.617303567e-01,	(float) -3.218294336e-02,
		(float)  5.063939675e-03,	(float)  4.569585726e-03,
		(float) -9.104002226e-03,	(float)  1.130361323e-02,
		(float) -1.216784405e-02,	(float)  1.217599274e-02,
		(float) -1.161042648e-02,	(float)  1.066440958e-02,
		(float) -9.483483226e-03,	(float)  8.182532814e-03,
		(float) -6.853061122e-03,	(float)  5.566438059e-03,
		(float) -4.375660693e-03,	(float)  3.316789404e-03,
		(float) -2.410575068e-03,	(float)  1.664450422e-03,
		(float) -1.074868910e-03,	(float)  6.298706871e-04,
		(float) -3.117076266e-04,	(float)  9.935048614e-05,
		(float)  2.927936934e-05,	(float) -9.547358309e-05,
		(float)  1.183677993e-04,	(float) -1.140616608e-04,
		(float)  9.520286977e-05,	(float) -7.097254460e-05,
		(float)  4.738315509e-05,	(float) -2.778752161e-05,
		(float)  1.349725181e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 18 */
		(float)  0.000000000e+00,	(float) -5.109406834e-06,
		(float)  1.505709672e-05,	(float) -3.336947346e-05,
		(float)  6.317107540e-05,	(float) -1.073256034e-04,
		(float)  1.677408369e-04,	(float) -2.444978077e-04,
		(float)  3.348588657e-04,	(float) -4.322387595e-04,
		(float)  5.252475502e-04,	(float) -5.969298155e-04,
		(float)  6.243273794e-04,	(float) -5.784799241e-04,
		(float)  4.249479593e-04,	(float) -1.248960830e-04,
		(float) -3.632867188e-04,	(float)  1.081925577e-03,
		(float) -2.071733335e-03,	(float)  3.369481739e-03,
		(float) -5.006027145e-03,	(float)  7.005163389e-03,
		(float) -9.383947662e-03,	(float)  1.215546568e-02,
		(float) -1.533569117e-02,	(float)  1.895773005e-02,
		(float) -2.310098237e-02,	(float)  2.795501305e-02,
		(float) -3.397899590e-02,	(float)  4.238826818e-02,
		(float) -5.719675475e-02,	(float)  1.014856042e-01,
		(float)  4.602538048e-01,	(float) -3.509327137e-02,
		(float)  6.735856748e-03,	(float)  3.430372926e-03,
		(float) -8.277847316e-03,	(float)  1.069199104e-02,
		(float) -1.171578054e-02,	(float)  1.184769157e-02,
		(float) -1.137979839e-02,	(float)  1.051091222e-02,
		(float) -9.390167536e-03,	(float)  8.135097730e-03,
		(float) -6.839389715e-03,	(float)  5.576359561e-03,
		(float) -4.400806494e-03,	(float)  3.350473659e-03,
		(float) -2.447665272e-03,	(float)  1.701213975e-03,
		(float) -1.108794388e-03,	(float)  6.594701140e-04,
		(float) -3.363100169e-04,	(float)  1.188982739e-04,
		(float)  1.442005360e-05,	(float) -8.467981203e-05,
		(float)  1.108977594e-04,	(float) -1.091605320e-04,
		(float)  9.217664913e-05,	(float) -6.923236699e-05,
		(float)  4.646458823e-05,	(float) -2.735046942e-05,
		(float)  1.331249260e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 19 */
		(float)  0.000000000e+00,	(float) -5.059860928e-06,
		(float)  1.493030436e-05,	(float) -3.319126509e-05,
		(float)  6.304040857e-05,	(float) -1.074555856e-04,
		(float)  1.685044465e-04,	(float) -2.464735841e-04,
		(float)  3.388701474e-04,	(float) -4.393786941e-04,
		(float)  5.368813215e-04,	(float) -6.146655258e-04,
		(float)  6.499479167e-04,	(float) -6.138299549e-04,
		(float)  4.717727979e-04,	(float) -1.846323369e-04,
		(float) -2.897655790e-04,	(float)  9.946028313e-04,
		(float) -1.971774510e-03,	(float)  3.259585710e-03,
		(float) -4.890801659e-03,	(float)  6.891535616e-03,
		(float) -9.281643752e-03,	(float)  1.207763831e-02,
		(float) -1.529986367e-02,	(float)  1.898741724e-02,
		(float) -2.322879886e-02,	(float)  2.822928226e-02,
		(float) -3.447964082e-02,	(float)  4.327255035e-02,
		(float) -5.887828101e-02,	(float)  1.060161668e-01,
		(float)  4.586959538e-01,	(float) -3.794464483e-02,
		(float)  8.391498651e-03,	(float)  2.295430180e-03,
		(float) -7.450773844e-03,	(float)  1.007684962e-02,
		(float) -1.125888643e-02,	(float)  1.151399943e-02,
		(float) -1.114369496e-02,	(float)  1.035216634e-02,
		(float) -9.292030011e-03,	(float)  8.083386215e-03,
		(float) -6.822044472e-03,	(float)  5.583220100e-03,
		(float) -4.423479544e-03,	(float)  3.382224071e-03,
		(float) -2.483295551e-03,	(float)  1.736918522e-03,
		(float) -1.141987104e-03,	(float)  6.885916182e-04,
		(float) -3.606247559e-04,	(float)  1.382931864e-04,
		(float) -3.757955928e-07,	(float) -7.389527689e-05,
		(float)  1.034084197e-04,	(float) -1.042290114e-04,
		(float)  8.911966113e-05,	(float) -6.746664801e-05,
		(float)  4.552772630e-05,	(float) -2.690214472e-05,
		(float)  1.312208733e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 20 */
		(float)  0.000000000e+00,	(float) -5.005736846e-06,
		(float)  1.479279773e-05,	(float) -3.299198384e-05,
		(float)  6.287277880e-05,	(float) -1.075261227e-04,
		(float)  1.691790798e-04,	(float) -2.483243848e-04,
		(float)  3.427160889e-04,	(float) -4.463126769e-04,
		(float)  5.482748605e-04,	(float) -6.321424319e-04,
		(float)  6.753191342e-04,	(float) -6.489834699e-04,
		(float)  5.185151058e-04,	(float) -2.444810855e-04,
		(float) -2.158348935e-04,	(float)  9.064504548e-04,
		(float) -1.870423154e-03,	(float)  3.147574175e-03,
		(float) -4.772564076e-03,	(float)  6.773816655e-03,
		(float) -9.173983328e-03,	(float)  1.199300419e-02,
		(float) -1.525559993e-02,	(float)  1.900686799e-02,
		(float) -2.334441883e-02,	(float)  2.848925375e-02,
		(float) -3.496381198e-02,	(float)  4.413846176e-02,
		(float) -6.054236455e-02,	(float)  1.105730491e-01,
		(float)  4.570573114e-01,	(float) -4.073659528e-02,
		(float)  1.003013457e-02,	(float)  1.165336417e-03,
		(float) -6.623228980e-03,	(float)  9.458533382e-03,
		(float) -1.079742479e-02,	(float)  1.117511390e-02,
		(float) -1.090226073e-02,	(float)  1.018827362e-02,
		(float) -9.189138169e-03,	(float)  8.027439078e-03,
		(float) -6.801045925e-03,	(float)  5.587025420e-03,
		(float) -4.443675391e-03,	(float)  3.412029736e-03,
		(float) -2.517451504e-03,	(float)  1.771548388e-03,
		(float) -1.174431689e-03,	(float)  7.172211712e-04,
		(float) -3.846397334e-04,	(float)  1.575252617e-04,
		(float) -1.510034144e-05,	(float) -6.312588074e-05,
		(float)  9.590403549e-05,	(float) -9.927002825e-05,
		(float)  8.603382529e-05,	(float) -6.567657970e-05,
		(float)  4.457326700e-05,	(float) -2.644293035e-05,
		(float)  1.292623231e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 21 */
		(float)  0.000000000e+00,	(float) -4.946998540e-06,
		(float)  1.464453298e-05,	(float) -3.277154187e-05,
		(float)  6.266797568e-05,	(float) -1.075367410e-04,
		(float)  1.697637755e-04,	(float) -2.500484326e-04,
		(float)  3.463936487e-04,	(float) -4.530358246e-04,
		(float)  5.594207405e-04,	(float) -6.493497588e-04,
		(float)  7.004260401e-04,	(float) -6.839203932e-04,
		(float)  5.651489452e-04,	(float) -3.044099545e-04,
		(float) -1.415337087e-04,	(float)  8.175139032e-04,
		(float) -1.767730196e-03,	(float)  3.033501733e-03,
		(float) -4.651369785e-03,	(float)  6.652058477e-03,
		(float) -9.061009131e-03,	(float)  1.190158903e-02,
		(float) -1.520289813e-02,	(float)  1.901603882e-02,
		(float) -2.344773739e-02,	(float)  2.873473166e-02,
		(float) -3.543117381e-02,	(float)  4.498543492e-02,
		(float) -6.218800340e-02,	(float)  1.151550232e-01,
		(float)  4.553384111e-01,	(float) -4.346867837e-02,
		(float)  1.165104721e-02,	(float)  4.066500956e-05,
		(float) -5.795658240e-03,	(float)  8.837387162e-03,
		(float) -1.033166025e-02,	(float)  1.083123475e-02,
		(float) -1.065564268e-02,	(float)  1.001933825e-02,
		(float) -9.081561908e-03,	(float)  7.967299311e-03,
		(float) -6.776416533e-03,	(float)  5.587782909e-03,
		(float) -4.461390945e-03,	(float)  3.439880848e-03,
		(float) -2.550119583e-03,	(float)  1.805088542e-03,
		(float) -1.206113245e-03,	(float)  7.453450703e-04,
		(float) -4.083430549e-04,	(float)  1.765846726e-04,
		(float) -2.974582393e-05,	(float) -5.237748803e-05,
		(float)  8.838884653e-05,	(float) -9.428650951e-05,
		(float)  8.292106473e-05,	(float) -6.386335919e-05,
		(float)  4.360191246e-05,	(float) -2.597321196e-05,
		(float)  1.272512506e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 22 */
		(float)  0.000000000e+00,	(float) -4.883612948e-06,
		(float)  1.448547272e-05,	(float) -3.252986329e-05,
		(float)  6.242580887e-05,	(float) -1.074869979e-04,
		(float)  1.702576172e-04,	(float) -2.516440113e-04,
		(float)  3.498998627e-04,	(float) -4.595433467e-04,
		(float)  5.703116377e-04,	(float) -6.662768331e-04,
		(float)  7.252537263e-04,	(float) -7.186206894e-04,
		(float)  6.116483414e-04,	(float) -3.643864104e-04,
		(float) -6.690140689e-05,	(float)  7.278392104e-04,
		(float) -1.663747459e-03,	(float)  2.917424276e-03,
		(float) -4.527275949e-03,	(float)  6.526315408e-03,
		(float) -8.942766917e-03,	(float)  1.180342224e-02,
		(float) -1.514176099e-02,	(float)  1.901489169e-02,
		(float) -2.353865590e-02,	(float)  2.896552710e-02,
		(float) -3.588139812e-02,	(float)  4.581290883e-02,
		(float) -6.381419611e-02,	(float)  1.197608472e-01,
		(float)  4.535398126e-01,	(float) -4.614047393e-02,
		(float)  1.325353305e-02,	(float) -1.078016486e-03,
		(float) -4.968505255e-03,	(float)  8.213756033e-03,
		(float) -9.861858875e-03,	(float)  1.048256381e-02,
		(float) -1.040399014e-02,	(float)  9.845466834e-03,
		(float) -8.969373467e-03,	(float)  7.903012056e-03,
		(float) -6.748180664e-03,	(float)  5.585501595e-03,
		(float) -4.476624481e-03,	(float)  3.465768700e-03,
		(float) -2.581287101e-03,	(float)  1.837524604e-03,
		(float) -1.237017348e-03,	(float)  7.729499445e-04,
		(float) -4.317230473e-04,	(float)  1.954617306e-04,
		(float) -4.430456379e-05,	(float) -4.165592154e-05,
		(float)  8.086707535e-05,	(float) -8.928137830e-05,
		(float)  7.978330502e-05,	(float) -6.202818802e-05,
		(float)  4.261436878e-05,	(float) -2.549337779e-05,
		(float)  1.251896416e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 23 */
		(float)  0.000000000e+00,	(float) -4.815550060e-06,
		(float)  1.431558613e-05,	(float) -3.226688436e-05,
		(float)  6.214610835e-05,	(float) -1.073764822e-04,
		(float)  1.706597343e-04,	(float) -2.531094669e-04,
		(float)  3.532318469e-04,	(float) -4.658305488e-04,
		(float)  5.809403351e-04,	(float) -6.829130894e-04,
		(float)  7.497873767e-04,	(float) -7.530643747e-04,
		(float)  6.579872967e-04,	(float) -4.243777779e-04,
		(float)  8.022313949e-06,	(float)  6.374729653e-04,
		(float) -1.558527636e-03,	(float)  2.799398964e-03,
		(float) -4.400341490e-03,	(float)  6.396644107e-03,
		(float) -8.819305448e-03,	(float)  1.169853705e-02,
		(float) -1.507219586e-02,	(float)  1.900339400e-02,
		(float) -2.361708210e-02,	(float)  2.918145838e-02,
		(float) -3.631416429e-02,	(float)  4.662032933e-02,
		(float) -6.541994215e-02,	(float)  1.243892664e-01,
		(float)  4.516621012e-01,	(float) -4.875158609e-02,
		(float)  1.483690257e-02,	(float) -2.190146592e-03,
		(float) -4.142211552e-03,	(float)  7.587985130e-03,
		(float) -9.388288006e-03,	(float)  1.012930486e-02,
		(float) -1.014745472e-02,	(float)  9.666768328e-03,
		(float) -8.852647375e-03,	(float)  7.834624576e-03,
		(float) -6.716364574e-03,	(float)  5.580192132e-03,
		(float) -4.489375631e-03,	(float)  3.489685685e-03,
		(float) -2.610942234e-03,	(float)  1.868842848e-03,
		(float) -1.267130052e-03,	(float)  8.000227613e-04,
		(float) -4.547682646e-04,	(float)  2.141468912e-04,
		(float) -5.876896634e-05,	(float) -3.096695933e-05,
		(float)  7.334292469e-05,	(float) -8.425755219e-05,
		(float)  7.662247312e-05,	(float) -6.017227143e-05,
		(float)  4.161134556e-05,	(float) -2.500381837e-05,
		(float)  1.230794916e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 24 */
		(float)  0.000000000e+00,	(float) -4.742782970e-06,
		(float)  1.413484901e-05,	(float) -3.198255361e-05,
		(float)  6.182872470e-05,	(float) -1.072048148e-04,
		(float)  1.709693023e-04,	(float) -2.544432087e-04,
		(float)  3.563867989e-04,	(float) -4.718928354e-04,
		(float)  5.912997273e-04,	(float) -6.992480768e-04,
		(float)  7.740122763e-04,	(float) -7.872315285e-04,
		(float)  7.041398047e-04,	(float) -4.843512574e-04,
		(float)  8.319746113e-05,	(float)  5.464622875e-04,
		(float) -1.452124264e-03,	(float)  2.679484196e-03,
		(float) -4.270627054e-03,	(float)  6.263103541e-03,
		(float) -8.690676470e-03,	(float)  1.158697039e-02,
		(float) -1.499421464e-02,	(float)  1.898151869e-02,
		(float) -2.368293012e-02,	(float)  2.938235101e-02,
		(float) -3.672915952e-02,	(float)  4.740714939e-02,
		(float) -6.700424236e-02,	(float)  1.290390133e-01,
		(float)  4.497058875e-01,	(float) -5.130164331e-02,
		(float)  1.640048052e-02,	(float) -3.295170161e-03,
		(float) -3.317216327e-03,	(float)  6.960419459e-03,
		(float) -8.911216126e-03,	(float)  9.771663529e-03,
		(float) -9.886190227e-03,	(float)  9.483353995e-03,
		(float) -8.731460404e-03,	(float)  7.762186222e-03,
		(float) -6.680996387e-03,	(float)  5.571866790e-03,
		(float) -4.499645382e-03,	(float)  3.511625297e-03,
		(float) -2.639074026e-03,	(float)  1.899030212e-03,
		(float) -1.296437900e-03,	(float)  8.265508316e-04,
		(float) -4.774674929e-04,	(float)  2.326307583e-04,
		(float) -7.313152530e-05,	(float) -2.031633174e-05,
		(float)  6.582057537e-05,	(float) -7.921794166e-05,
		(float)  7.344049622e-05,	(float) -5.829681757e-05,
		(float)  4.059355546e-05,	(float) -2.450492630e-05,
		(float)  1.209228038e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 25 */
		(float)  0.000000000e+00,	(float) -4.665287945e-06,
		(float)  1.394324388e-05,	(float) -3.167683202e-05,
		(float)  6.147352933e-05,	(float) -1.069716488e-04,
		(float)  1.711855442e-04,	(float) -2.556437112e-04,
		(float)  3.593620002e-04,	(float) -4.777257131e-04,
		(float)  6.013828253e-04,	(float) -7.152714651e-04,
		(float)  7.979138193e-04,	(float) -8.211023039e-04,
		(float)  7.500798645e-04,	(float) -5.442739427e-04,
		(float)  1.585837681e-04,	(float)  4.548548040e-04,
		(float) -1.344591695e-03,	(float)  2.557739582e-03,
		(float) -4.138194986e-03,	(float)  6.125754962e-03,
		(float) -8.556934692e-03,	(float)  1.146876296e-02,
		(float) -1.490783386e-02,	(float)  1.894924417e-02,
		(float) -2.373612057e-02,	(float)  2.956803793e-02,
		(float) -3.712607896e-02,	(float)  4.817282945e-02,
		(float) -6.856609937e-02,	(float)  1.337088079e-01,
		(float)  4.476718076e-01,	(float) -5.379029840e-02,
		(float)  1.794360607e-02,	(float) -4.392538627e-03,
		(float) -2.493956229e-03,	(float)  6.331403721e-03,
		(float) -8.430912702e-03,	(float)  9.409847161e-03,
		(float) -9.620352547e-03,	(float)  9.295337322e-03,
		(float) -8.605891521e-03,	(float)  7.685748402e-03,
		(float) -6.642106077e-03,	(float)  5.560539444e-03,
		(float) -4.507436072e-03,	(float)  3.531582132e-03,
		(float) -2.665672390e-03,	(float)  1.928074298e-03,
		(float) -1.324927925e-03,	(float)  8.525218162e-04,
		(float) -4.998097558e-04,	(float)  2.509040888e-04,
		(float) -8.738482659e-05,	(float) -9.709718474e-06,
		(float)  5.830418402e-05,	(float) -7.416544846e-05,
		(float)  7.023930065e-05,	(float) -5.640303684e-05,
		(float)  3.956171376e-05,	(float) -2.399709592e-05,
		(float)  1.187215878e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 26 */
		(float)  0.000000000e+00,	(float) -4.583044472e-06,
		(float)  1.374076010e-05,	(float) -3.134969309e-05,
		(float)  6.108041474e-05,	(float) -1.066766704e-04,
		(float)  1.713077308e-04,	(float) -2.567095144e-04,
		(float)  3.621548181e-04,	(float) -4.833247939e-04,
		(float)  6.111827604e-04,	(float) -7.309730508e-04,
		(float)  8.214775180e-04,	(float) -8.546569397e-04,
		(float)  7.957814955e-04,	(float) -6.041128383e-04,
		(float)  2.341407155e-04,	(float)  3.626986240e-04,
		(float) -1.235985070e-03,	(float)  2.434225915e-03,
		(float) -4.003109303e-03,	(float)  5.984661879e-03,
		(float) -8.418137770e-03,	(float)  1.134395918e-02,
		(float) -1.481307464e-02,	(float)  1.890655446e-02,
		(float) -2.377658063e-02,	(float)  2.973835955e-02,
		(float) -3.750462598e-02,	(float)  4.891683769e-02,
		(float) -7.010451808e-02,	(float)  1.383973589e-01,
		(float)  4.455605222e-01,	(float) -5.621722864e-02,
		(float)  1.946563311e-02,	(float) -5.481710252e-03,
		(float) -1.672865138e-03,	(float)  5.701282124e-03,
		(float) -7.947648039e-03,	(float)  9.044064706e-03,
		(float) -9.350099578e-03,	(float)  9.102833955e-03,
		(float) -8.476021842e-03,	(float)  7.605364542e-03,
		(float) -6.599725442e-03,	(float)  5.546225564e-03,
		(float) -4.512751382e-03,	(float)  3.549551886e-03,
		(float) -2.690728113e-03,	(float)  1.955963377e-03,
		(float) -1.352587658e-03,	(float)  8.779237306e-04,
		(float) -5.217843196e-04,	(float)  2.689577972e-04,
		(float) -1.015215519e-04,	(float)  8.472543516e-07,
		(float)  5.079788092e-05,	(float) -6.910296402e-05,
		(float)  6.702081081e-05,	(float) -5.449214113e-05,
		(float)  3.851653790e-05,	(float) -2.348072312e-05,
		(float)  1.164778585e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 27 */
		(float)  0.000000000e+00,	(float) -4.496035319e-06,
		(float)  1.352739389e-05,	(float) -3.100112306e-05,
		(float)  6.064929475e-05,	(float) -1.063195987e-04,
		(float)  1.713351817e-04,	(float) -2.576392258e-04,
		(float)  3.647627078e-04,	(float) -4.886857978e-04,
		(float)  6.206927886e-04,	(float) -7.463427637e-04,
		(float)  8.446890109e-04,	(float) -8.878757713e-04,
		(float)  8.412187510e-04,	(float) -6.638348780e-04,
		(float)  3.098275529e-04,	(float)  2.700423143e-04,
		(float) -1.126360294e-03,	(float)  2.309005142e-03,
		(float) -3.865435661e-03,	(float)  5.839890027e-03,
		(float) -8.274346282e-03,	(float)  1.121260718e-02,
		(float) -1.470996273e-02,	(float)  1.885343912e-02,
		(float) -2.380424407e-02,	(float)  2.989316390e-02,
		(float) -3.786451228e-02,	(float)  4.963865036e-02,
		(float) -7.161850606e-02,	(float)  1.431033632e-01,
		(float)  4.433727171e-01,	(float) -5.858213574e-02,
		(float)  2.096593038e-02,	(float) -6.562150366e-03,
		(float) -8.543739514e-04,	(float)  5.070398204e-03,
		(float) -7.461693134e-03,	(float)  8.674526600e-03,
		(float) -9.075591129e-03,	(float)  8.905961629e-03,
		(float) -8.341934578e-03,	(float)  7.521090059e-03,
		(float) -6.553888087e-03,	(float)  5.528942196e-03,
		(float) -4.515596332e-03,	(float)  3.565531352e-03,
		(float) -2.714232856e-03,	(float)  1.982686396e-03,
		(float) -1.379405133e-03,	(float)  9.027449505e-04,
		(float) -5.433806979e-04,	(float)  2.867829595e-04,
		(float) -1.155344825e-04,	(float)  1.134901704e-05,
		(float)  4.330576776e-05,	(float) -6.403336790e-05,
		(float)  6.378694808e-05,	(float) -5.256534315e-05,
		(float)  3.745874706e-05,	(float) -2.295620503e-05,
		(float)  1.141936341e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 28 */
		(float)  0.000000000e+00,	(float) -4.404246587e-06,
		(float)  1.330314845e-05,	(float) -3.063112094e-05,
		(float)  6.018010469e-05,	(float) -1.059001868e-04,
		(float)  1.712672655e-04,	(float) -2.584315212e-04,
		(float)  3.671832140e-04,	(float) -4.938045558e-04,
		(float)  6.299062956e-04,	(float) -7.613706731e-04,
		(float)  8.675340716e-04,	(float) -9.207392421e-04,
		(float)  8.863657335e-04,	(float) -7.234069419e-04,
		(float)  3.856033200e-04,	(float)  1.769348745e-04,
		(float) -1.015774003e-03,	(float)  2.182140331e-03,
		(float) -3.725241326e-03,	(float)  5.691507345e-03,
		(float) -8.125623702e-03,	(float)  1.107475882e-02,
		(float) -1.459852846e-02,	(float)  1.878989335e-02,
		(float) -2.381905132e-02,	(float)  3.003230673e-02,
		(float) -3.820545814e-02,	(float)  5.033775211e-02,
		(float) -7.310707397e-02,	(float)  1.478255069e-01,
		(float)  4.411091022e-01,	(float) -6.088474592e-02,
		(float)  2.244388173e-02,	(float) -7.633331606e-03,
		(float) -3.891036798e-05,	(float)  4.439094645e-03,
		(float) -6.973319531e-03,	(float)  8.301444649e-03,
		(float) -8.796988832e-03,	(float)  8.704840100e-03,
		(float) -8.203714983e-03,	(float)  7.432982316e-03,
		(float) -6.504629392e-03,	(float)  5.508707952e-03,
		(float) -4.515977272e-03,	(float)  3.579518421e-03,
		(float) -2.736179156e-03,	(float)  2.008232981e-03,
		(float) -1.405368889e-03,	(float)  9.269742165e-04,
		(float) -5.645886566e-04,	(float)  3.043708180e-04,
		(float) -1.294165026e-04,	(float)  2.179005916e-05,
		(float)  3.583191558e-05,	(float) -5.895952622e-05,
		(float)  6.053962970e-05,	(float) -5.062385566e-05,
		(float)  3.638906167e-05,	(float) -2.242393979e-05,
		(float)  1.118709354e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 29 */
		(float)  0.000000000e+00,	(float) -4.307667759e-06,
		(float)  1.306803402e-05,	(float) -3.023969871e-05,
		(float)  5.967280167e-05,	(float) -1.054182216e-04,
		(float)  1.711034013e-04,	(float) -2.590851460e-04,
		(float)  3.694139731e-04,	(float) -4.986770131e-04,
		(float)  6.388168002e-04,	(float) -7.760469936e-04,
		(float)  8.899986168e-04,	(float) -9.532279143e-04,
		(float)  9.311966083e-04,	(float) -7.827958754e-04,
		(float)  4.614268687e-04,	(float)  8.342571109e-05,
		(float) -9.042835385e-04,	(float)  2.053695642e-03,
		(float) -3.582595140e-03,	(float)  5.539583939e-03,
		(float) -7.972036377e-03,	(float)  1.093046961e-02,
		(float) -1.447880680e-02,	(float)  1.871591796e-02,
		(float) -2.382094957e-02,	(float)  3.015565163e-02,
		(float) -3.852719258e-02,	(float)  5.101363624e-02,
		(float) -7.456923608e-02,	(float)  1.525624659e-01,
		(float)  4.387704117e-01,	(float) -6.312480987e-02,
		(float)  2.389888628e-02,	(float) -8.694734143e-03,
		(float)  7.731013201e-04,	(float)  3.807713101e-03,
		(float) -6.482799166e-03,	(float)  7.925031907e-03,
		(float) -8.514456046e-03,	(float)  8.499591076e-03,
		(float) -8.061450305e-03,	(float)  7.341100593e-03,
		(float) -6.451986496e-03,	(float)  5.485542994e-03,
		(float) -4.513901878e-03,	(float)  3.591512081e-03,
		(float) -2.756560428e-03,	(float)  2.032593435e-03,
		(float) -1.430467977e-03,	(float)  9.506006392e-04,
		(float) -5.853982185e-04,	(float)  3.217127847e-04,
		(float) -1.431606026e-04,	(float)  3.216493229e-05,
		(float)  2.838036261e-05,	(float) -5.388429012e-05,
		(float)  5.728076777e-05,	(float) -4.866889083e-05,
		(float)  3.530820302e-05,	(float) -2.188432626e-05,
		(float)  1.095117837e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 30 */
		(float)  0.000000000e+00,	(float) -4.206291752e-06,
		(float)  1.282206792e-05,	(float) -2.982688138e-05,
		(float)  5.912736472e-05,	(float) -1.048735244e-04,
		(float)  1.708430586e-04,	(float) -2.595989162e-04,
		(float)  3.714527145e-04,	(float) -5.032992313e-04,
		(float)  6.474179593e-04,	(float) -7.903620911e-04,
		(float)  9.120687153e-04,	(float) -9.853224808e-04,
		(float)  9.756856187e-04,	(float) -8.419685063e-04,
		(float)  5.372568849e-04,	(float) -1.043538805e-05,
		(float) -7.919469169e-04,	(float)  1.923736296e-03,
		(float) -3.437567490e-03,	(float)  5.384192051e-03,
		(float) -7.813653496e-03,	(float)  1.077979875e-02,
		(float) -1.435083731e-02,	(float)  1.863151942e-02,
		(float) -2.380989274e-02,	(float)  3.026307010e-02,
		(float) -3.882945353e-02,	(float)  5.166580504e-02,
		(float) -7.600401061e-02,	(float)  1.573129059e-01,
		(float)  4.363574038e-01,	(float) -6.530210277e-02,
		(float)  2.533035863e-02,	(float) -9.745845917e-03,
		(float)  1.581240437e-03,	(float)  3.176594015e-03,
		(float) -5.990404228e-03,	(float)  7.545502562e-03,
		(float) -8.228157766e-03,	(float)  8.290338138e-03,
		(float) -7.915229731e-03,	(float)  7.245506043e-03,
		(float) -6.395998263e-03,	(float)  5.459469017e-03,
		(float) -4.509379137e-03,	(float)  3.601512407e-03,
		(float) -2.775370965e-03,	(float)  2.055758750e-03,
		(float) -1.454691964e-03,	(float)  9.736137035e-04,
		(float) -6.057996674e-04,	(float)  3.388004461e-04,
		(float) -1.567598832e-04,	(float)  4.246825274e-05,
		(float)  2.095511218e-05,	(float) -4.881049424e-05,
		(float)  5.401226812e-05,	(float) -4.670165951e-05,
		(float)  3.421689283e-05,	(float) -2.133776383e-05,
		(float)  1.071182000e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 31 */
		(float)  0.000000000e+00,	(float) -4.100114963e-06,
		(float)  1.256527468e-05,	(float) -2.939270710e-05,
		(float)  5.854379498e-05,	(float) -1.042659513e-04,
		(float)  1.704857584e-04,	(float) -2.599717196e-04,
		(float)  3.732972632e-04,	(float) -5.076673919e-04,
		(float)  6.557035715e-04,	(float) -8.043064895e-04,
		(float)  9.337305954e-04,	(float) -1.017003776e-03,
		(float)  1.019807100e-03,	(float) -9.008916641e-04,
		(float)  6.130519106e-04,	(float) -1.045982798e-04,
		(float) -6.788228013e-04,	(float)  1.792328540e-03,
		(float) -3.290230276e-03,	(float)  5.225406031e-03,
		(float) -7.650547064e-03,	(float)  1.062280907e-02,
		(float) -1.421466412e-02,	(float)  1.853670984e-02,
		(float) -2.378584160e-02,	(float)  3.035444168e-02,
		(float) -3.911198805e-02,	(float)  5.229377007e-02,
		(float) -7.741042024e-02,	(float)  1.620754832e-01,
		(float)  4.338708600e-01,	(float) -6.741642432e-02,
		(float)  2.673772901e-02,	(float) -1.078616285e-02,
		(float)  2.385090130e-03,	(float)  2.546076445e-03,
		(float) -5.496407008e-03,	(float)  7.163071814e-03,
		(float) -7.938260526e-03,	(float)  8.077206678e-03,
		(float) -7.765144333e-03,	(float)  7.146261658e-03,
		(float) -6.336705266e-03,	(float)  5.430509234e-03,
		(float) -4.502419345e-03,	(float)  3.609520567e-03,
		(float) -2.792605939e-03,	(float)  2.077720601e-03,
		(float) -1.478030934e-03,	(float)  9.960032728e-04,
		(float) -6.257835528e-04,	(float)  3.556255663e-04,
		(float) -1.702075579e-04,	(float)  5.269470424e-05,
		(float)  1.356013070e-05,	(float) -4.374095524e-05,
		(float)  5.073602934e-05,	(float) -4.472337053e-05,
		(float)  3.311585275e-05,	(float) -2.078465209e-05,
		(float)  1.046922032e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 32 */
		(float)  0.000000000e+00,	(float) -3.989137316e-06,
		(float)  1.229768601e-05,	(float) -2.893722727e-05,
		(float)  5.792211593e-05,	(float) -1.035953935e-04,
		(float)  1.700310733e-04,	(float) -2.602025167e-04,
		(float)  3.749455406e-04,	(float) -5.117777987e-04,
		(float)  6.636675816e-04,	(float) -8.178708757e-04,
		(float)  9.549706542e-04,	(float) -1.048252786e-03,
		(float)  1.063535495e-03,	(float) -9.595321971e-04,
		(float)  6.887703665e-04,	(float) -1.990124920e-04,
		(float) -5.649704698e-04,	(float)  1.659539617e-03,
		(float) -3.140656871e-03,	(float)  5.063302295e-03,
		(float) -7.482791868e-03,	(float)  1.045956704e-02,
		(float) -1.407033598e-02,	(float)  1.843150701e-02,
		(float) -2.374876378e-02,	(float)  3.042965404e-02,
		(float) -3.937455242e-02,	(float)  5.289705246e-02,
		(float) -7.878749252e-02,	(float)  1.668488451e-01,
		(float)  4.313115855e-01,	(float) -6.946759865e-02,
		(float)  2.812044346e-02,	(float) -1.181518908e-02,
		(float)  3.184237571e-03,	(float)  1.916497887e-03,
		(float) -5.001079752e-03,	(float)  6.777955756e-03,
		(float) -7.644932310e-03,	(float)  7.860323814e-03,
		(float) -7.611287012e-03,	(float)  7.043432223e-03,
		(float) -6.274149748e-03,	(float)  5.398688360e-03,
		(float) -4.493034093e-03,	(float)  3.615538809e-03,
		(float) -2.808261397e-03,	(float)  2.098471352e-03,
		(float) -1.500475497e-03,	(float)  1.017759593e-03,
		(float) -6.453406936e-04,	(float)  3.721800913e-04,
		(float) -1.834969566e-04,	(float)  6.283904057e-05,
		(float)  6.199345624e-06,	(float) -3.867847029e-05,
		(float)  4.745394167e-05,	(float) -4.273523004e-05,
		(float)  3.200580401e-05,	(float) -2.022539063e-05,
		(float)  1.022358092e-05,	(float)  0.000000000e+00
	},
	{ /* Polyphase 33 */
		(float)  0.000000000e+00,	(float) -3.873362301e-06,
		(float)  1.201934096e-05,	(float) -2.846050661e-05,
		(float)  5.726237347e-05,	(float) -1.028617774e-04,
		(float)  1.694786287e-04,	(float) -2.602903419e-04,
		(float)  3.763955670e-04,	(float) -5.156268802e-04,
		(float)  6.713040843e-04,	(float) -8.310461064e-04,
		(float)  9.757754651e-04,	(float) -1.079050661e-03,
		(float)  1.106845366e-03,	(float) -1.017856992e-03,
		(float)  7.643705739e-04,	(float) -2.936272504e-04,
		(float) -4.504497863e-04,	(float)  1.525437728e-03,
		(float) -2.988922089e-03,	(float)  4.897959295e-03,
		(float) -7.310465448e-03,	(float)  1.029014270e-02,
		(float) -1.391790620e-02,	(float)  1.831593440e-02,
		(float) -2.369863381e-02,	(float)  3.048860305e-02,
		(float) -3.961691240e-02,	(float)  5.347518321e-02,
		(float) -8.013426033e-02,	(float)  1.716316305e-01,
		(float)  4.286804079e-01,	(float) -7.145547436e-02,
		(float)  2.947796401e-02,	(float) -1.283243713e-02,
		(float)  3.978274156e-03,	(float)  1.288194102e-03,
		(float) -4.504694519e-03,	(float)  6.390371256e-03,
		(float) -7.348342448e-03,	(float)  7.639818327e-03,
		(float) -7.453752445e-03,	(float)  6.937084285e-03,
		(float) -6.208375604e-03,	(float)  5.364032591e-03,
		(float) -4.481236258e-03,	(float)  3.619570460e-03,
		(float) -2.822334266e-03,	(float)  2.118004060e-03,
		(float) -1.522016785e-03,	(float)  1.038873298e-03,
		(float) -6.644621824e-04,	(float)  3.884561525e-04,
		(float) -1.966215287e-04,	(float)  7.289608809e-05,
		(float) -1.123356551e-06,	(float) -3.362581560e-05,
		(float)  4.416788604e-05,	(float) -4.073844079e-05,
		(float)  3.088746694e-05,	(float) -1.966037877e-05,
		(float)  9.975102916e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 34 */
		(float)  0.000000000e+00,	(float) -3.752797020e-06,
		(float)  1.173028586e-05,	(float) -2.796262325e-05,
		(float)  5.656463615e-05,	(float) -1.020650652e-04,
		(float)  1.688281030e-04,	(float) -2.602343042e-04,
		(float)  3.776454626e-04,	(float) -5.192111929e-04,
		(float)  6.786073287e-04,	(float) -8.438232131e-04,
		(float)  9.961317863e-04,	(float) -1.109378728e-03,
		(float)  1.149711411e-03,	(float) -1.075832990e-03,
		(float)  8.398107778e-04,	(float) -3.883915051e-04,
		(float) -3.353211685e-04,	(float)  1.390092003e-03,
		(float) -2.835102150e-03,	(float)  4.729457483e-03,
		(float) -7.133648060e-03,	(float)  1.011460968e-02,
		(float) -1.375743263e-02,	(float)  1.819002117e-02,
		(float) -2.363543316e-02,	(float)  3.053119287e-02,
		(float) -3.983884333e-02,	(float)  5.402770345e-02,
		(float) -8.144976228e-02,	(float)  1.764224702e-01,
		(float)  4.259781780e-01,	(float) -7.337992443e-02,
		(float)  3.080976879e-02,	(float) -1.383742819e-02,
		(float)  4.766795704e-03,	(float)  6.614989455e-04,
		(float) -4.007523032e-03,	(float)  6.000535839e-03,
		(float) -7.048661530e-03,	(float)  7.415820578e-03,
		(float) -7.292637026e-03,	(float)  6.827286100e-03,
		(float) -6.139428345e-03,	(float)  5.326569583e-03,
		(float) -4.467039991e-03,	(float)  3.621619922e-03,
		(float) -2.834822347e-03,	(float)  2.136312469e-03,
		(float) -1.542646460e-03,	(float)  1.059335410e-03,
		(float) -6.831393890e-04,	(float)  4.044460700e-04,
		(float) -2.095748464e-04,	(float)  8.286074826e-05,
		(float) -8.404132219e-06,	(float) -2.858574500e-05,
		(float)  4.087973300e-05,	(float) -3.873420151e-05,
		(float)  2.976156058e-05,	(float) -1.909001534e-05,
		(float)  9.723986835e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 35 */
		(float)  0.000000000e+00,	(float) -3.627452223e-06,
		(float)  1.143057446e-05,	(float) -2.744366882e-05,
		(float)  5.582899523e-05,	(float) -1.012052551e-04,
		(float)  1.680792279e-04,	(float) -2.600335885e-04,
		(float)  3.786934496e-04,	(float) -5.225274232e-04,
		(float)  6.855717216e-04,	(float) -8.561934084e-04,
		(float)  1.016026569e-03,	(float) -1.139218496e-03,
		(float)  1.192108481e-03,	(float) -1.133427208e-03,
		(float)  9.150491691e-04,	(float) -4.832539579e-04,
		(float) -2.196455575e-04,	(float)  1.253572462e-03,
		(float) -2.679274637e-03,	(float)  4.557879268e-03,
		(float) -6.952422641e-03,	(float)  9.933045155e-03,
		(float) -1.358897770e-02,	(float)  1.805380216e-02,
		(float) -2.355915030e-02,	(float)  3.055733608e-02,
		(float) -4.004013033e-02,	(float)  5.455416476e-02,
		(float) -8.273304318e-02,	(float)  1.812199872e-01,
		(float)  4.232057686e-01,	(float) -7.524084621e-02,
		(float)  3.211535222e-02,	(float) -1.482969225e-02,
		(float)  5.549402650e-03,	(float)  3.674419112e-05,
		(float) -3.509836536e-03,	(float)  5.608667564e-03,
		(float) -6.746061302e-03,	(float)  7.188462439e-03,
		(float) -7.128038808e-03,	(float)  6.714107603e-03,
		(float) -6.067355074e-03,	(float)  5.286328441e-03,
		(float) -4.450460705e-03,	(float)  3.621692665e-03,
		(float) -2.845724315e-03,	(float)  2.153391020e-03,
		(float) -1.562356716e-03,	(float)  1.079137345e-03,
		(float) -7.013639639e-04,	(float)  4.201423563e-04,
		(float) -2.223506073e-04,	(float)  9.272800015e-05,
		(float) -1.563918259e-05,	(float) -2.356098852e-05,
		(float)  3.759134177e-05,	(float) -3.672370620e-05,
		(float)  2.862880225e-05,	(float) -1.851469839e-05,
		(float)  9.470432495e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 36 */
		(float)  0.000000000e+00,	(float) -3.497342348e-06,
		(float)  1.112026792e-05,	(float) -2.690374848e-05,
		(float)  5.505556488e-05,	(float) -1.002823811e-04,
		(float)  1.672317895e-04,	(float) -2.596874562e-04,
		(float)  3.795378535e-04,	(float) -5.255723902e-04,
		(float)  6.921918318e-04,	(float) -8.681480914e-04,
		(float)  1.035446964e-03,	(float) -1.168551673e-03,
		(float)  1.234011588e-03,	(float) -1.190606756e-03,
		(float)  9.900439076e-04,	(float) -5.781630895e-04,
		(float) -1.034843852e-04,	(float)  1.115949982e-03,
		(float) -2.521518463e-03,	(float)  4.383308979e-03,
		(float) -6.766874773e-03,	(float)  9.745529780e-03,
		(float) -1.341260833e-02,	(float)  1.790731790e-02,
		(float) -2.346978069e-02,	(float)  3.056695369e-02,
		(float) -4.022056843e-02,	(float)  5.505412942e-02,
		(float) -8.398315448e-02,	(float)  1.860227980e-01,
		(float)  4.203640745e-01,	(float) -7.703816134e-02,
		(float)  3.339422514e-02,	(float) -1.580876831e-02,
		(float)  6.325700235e-03,	(float) -5.857406325e-04,
		(float) -3.011905653e-03,	(float)  5.214984906e-03,
		(float) -6.440714575e-03,	(float)  6.957877211e-03,
		(float) -6.960057447e-03,	(float)  6.597620353e-03,
		(float) -5.992204450e-03,	(float)  5.243339689e-03,
		(float) -4.431515065e-03,	(float)  3.619795217e-03,
		(float) -2.855039715e-03,	(float)  2.169234844e-03,
		(float) -1.581140281e-03,	(float)  1.098270917e-03,
		(float) -7.191278423e-04,	(float)  4.355377196e-04,
		(float) -2.349426373e-04,	(float)  1.024929028e-04,
		(float) -2.282475558e-05,	(float) -1.855425097e-05,
		(float)  3.430455921e-05,	(float) -3.470814349e-05,
		(float)  2.748990714e-05,	(float) -1.793482500e-05,
		(float)  9.214638862e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 37 */
		(float)  0.000000000e+00,	(float) -3.362485548e-06,
		(float)  1.079943488e-05,	(float) -2.634298099e-05,
		(float)  5.424448222e-05,	(float) -9.929651417e-05,
		(float)  1.662856281e-04,	(float) -2.591952462e-04,
		(float)  3.801771043e-04,	(float) -5.283430481e-04,
		(float)  6.984623936e-04,	(float) -8.796788534e-04,
		(float)  1.054380333e-03,	(float) -1.197360176e-03,
		(float)  1.275395925e-03,	(float) -1.247338855e-03,
		(float)  1.064753145e-03,	(float) -6.730671870e-04,
		(float)  1.310045695e-05,	(float)  9.772962579e-04,
		(float) -2.361913831e-03,	(float)  4.205832829e-03,
		(float) -6.577092644e-03,	(float)  9.552147705e-03,
		(float) -1.322839593e-02,	(float)  1.775061460e-02,
		(float) -2.336732683e-02,	(float)  3.055997526e-02,
		(float) -4.037996271e-02,	(float)  5.552717069e-02,
		(float) -8.519915469e-02,	(float)  1.908295122e-01,
		(float)  4.174540122e-01,	(float) -7.877181569e-02,
		(float)  3.464591489e-02,	(float) -1.677420460e-02,
		(float)  7.095298695e-03,	(float) -1.205628412e-03,
		(float) -2.514000237e-03,	(float)  4.819706641e-03,
		(float) -6.132795126e-03,	(float)  6.724199552e-03,
		(float) -6.788794142e-03,	(float)  6.477897499e-03,
		(float) -5.914026662e-03,	(float)  5.197635256e-03,
		(float) -4.410220972e-03,	(float)  3.615935164e-03,
		(float) -2.862768964e-03,	(float)  2.183839768e-03,
		(float) -1.598990415e-03,	(float)  1.116728339e-03,
		(float) -7.364232465e-04,	(float)  4.506250667e-04,
		(float) -2.473448940e-04,	(float)  1.121505975e-04,
		(float) -2.995714765e-05,	(float) -1.356821058e-05,
		(float)  3.102121888e-05,	(float) -3.268869599e-05,
		(float)  2.634558789e-05,	(float) -1.735079101e-05,
		(float)  8.956803933e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 38 */
		(float)  0.000000000e+00,	(float) -3.222903731e-06,
		(float)  1.046815145e-05,	(float) -2.576149880e-05,
		(float)  5.339590749e-05,	(float) -9.824776148e-05,
		(float)  1.652406391e-04,	(float) -2.585563756e-04,
		(float)  3.806097387e-04,	(float) -5.308364885e-04,
		(float)  7.043783109e-04,	(float) -8.907774834e-04,
		(float)  1.072814253e-03,	(float) -1.225626136e-03,
		(float)  1.316236876e-03,	(float) -1.303590854e-03,
		(float)  1.139135047e-03,	(float) -7.679143719e-04,
		(float)  1.300466511e-04,	(float)  8.376837684e-04,
		(float) -2.200542192e-03,	(float)  4.025538867e-03,
		(float) -6.383167006e-03,	(float)  9.352986516e-03,
		(float) -1.303641642e-02,	(float)  1.758374416e-02,
		(float) -2.325179828e-02,	(float)  3.053633895e-02,
		(float) -4.051812850e-02,	(float)  5.597287311e-02,
		(float) -8.638010980e-02,	(float)  1.956387334e-01,
		(float)  4.144765194e-01,	(float) -8.044177927e-02,
		(float)  3.586996551e-02,	(float) -1.772555875e-02,
		(float)  7.857813444e-03,	(float) -1.822594614e-03,
		(float) -2.016389236e-03,	(float)  4.423051721e-03,
		(float) -5.822477602e-03,	(float)  6.487565400e-03,
		(float) -6.614351578e-03,	(float)  6.355013730e-03,
		(float) -5.832873392e-03,	(float)  5.149248449e-03,
		(float) -4.386597550e-03,	(float)  3.610121134e-03,
		(float) -2.868913342e-03,	(float)  2.197202309e-03,
		(float) -1.615900920e-03,	(float)  1.134502225e-03,
		(float) -7.532426897e-04,	(float)  4.653975061e-04,
		(float) -2.595514685e-04,	(float)  1.216963102e-04,
		(float) -3.703270560e-05,	(float) -8.605517623e-06,
		(float)  2.774314008e-05,	(float) -3.066653964e-05,
		(float)  2.519655423e-05,	(float) -1.676299080e-05,
		(float)  8.697124611e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 39 */
		(float)  0.000000000e+00,	(float) -3.078622587e-06,
		(float)  1.012650130e-05,	(float) -2.515944801e-05,
		(float)  5.251002409e-05,	(float) -9.713626720e-05,
		(float)  1.640967733e-04,	(float) -2.577703407e-04,
		(float)  3.808344008e-04,	(float) -5.330499430e-04,
		(float)  7.099346601e-04,	(float) -9.014359735e-04,
		(float)  1.090736524e-03,	(float) -1.253331917e-03,
		(float)  1.356510034e-03,	(float) -1.359330252e-03,
		(float)  1.213147819e-03,	(float) -8.626526276e-04,
		(float)  2.472914853e-04,	(float)  6.971857380e-04,
		(float) -2.037486205e-03,	(float)  3.842516938e-03,
		(float) -6.185191133e-03,	(float)  9.148137200e-03,
		(float) -1.283675013e-02,	(float)  1.740676413e-02,
		(float) -2.312321167e-02,	(float)  3.049599159e-02,
		(float) -4.063489147e-02,	(float)  5.639083273e-02,
		(float) -8.752509376e-02,	(float)  2.004490598e-01,
		(float)  4.114325550e-01,	(float) -8.204804617e-02,
		(float)  3.706593780e-02,	(float) -1.866239796e-02,
		(float)  8.612865257e-03,	(float) -2.436317448e-03,
		(float) -1.519340548e-03,	(float)  4.025239161e-03,
		(float) -5.509937421e-03,	(float)  6.248111893e-03,
		(float) -6.436833859e-03,	(float)  6.229045231e-03,
		(float) -5.748797789e-03,	(float)  5.098213936e-03,
		(float) -4.360665134e-03,	(float)  3.602362796e-03,
		(float) -2.873474991e-03,	(float)  2.209319679e-03,
		(float) -1.631866132e-03,	(float)  1.151585597e-03,
		(float) -7.695789786e-04,	(float)  4.798483511e-04,
		(float) -2.715565890e-04,	(float)  1.311253537e-04,
		(float) -4.404782837e-05,	(float) -3.668793129e-06,
		(float)  2.447212686e-05,	(float) -2.864284310e-05,
		(float)  2.404351251e-05,	(float) -1.617181705e-05,
		(float)  8.435796579e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 40 */
		(float)  0.000000000e+00,	(float) -2.929671612e-06,
		(float)  9.774575616e-06,	(float) -2.453698848e-05,
		(float)  5.158703864e-05,	(float) -9.596221246e-05,
		(float)  1.628540371e-04,	(float) -2.568367176e-04,
		(float)  3.808498435e-04,	(float) -5.349807851e-04,
		(float)  7.151266946e-04,	(float) -9.116465240e-04,
		(float)  1.108135181e-03,	(float) -1.280460121e-03,
		(float)  1.396191214e-03,	(float) -1.414524713e-03,
		(float)  1.286749724e-03,	(float) -9.572298278e-04,
		(float)  3.647718868e-04,	(float)  5.558760994e-04,
		(float) -1.872829696e-03,	(float)  3.656858642e-03,
		(float) -5.983260781e-03,	(float)  8.937694107e-03,
		(float) -1.262948181e-02,	(float)  1.721973772e-02,
		(float) -2.298159073e-02,	(float)  3.043888875e-02,
		(float) -4.073008778e-02,	(float)  5.678065742e-02,
		(float) -8.863318886e-02,	(float)  2.052590846e-01,
		(float)  4.083230979e-01,	(float) -8.359063442e-02,
		(float)  3.823340941e-02,	(float) -1.958429918e-02,
		(float)  9.360080443e-03,	(float) -3.046478029e-03,
		(float) -1.023120881e-03,	(float)  3.626487916e-03,
		(float) -5.195350679e-03,	(float)  6.005977291e-03,
		(float) -6.256346456e-03,	(float)  6.100069639e-03,
		(float) -5.661854427e-03,	(float)  5.044567716e-03,
		(float) -4.332445252e-03,	(float)  3.592670848e-03,
		(float) -2.876456911e-03,	(float)  2.220189781e-03,
		(float) -1.646880929e-03,	(float)  1.167971881e-03,
		(float) -7.854252162e-04,	(float)  4.939711224e-04,
		(float) -2.833546226e-04,	(float)  1.404331299e-04,
		(float) -5.099896875e-05,	(float)  1.239372466e-06,
		(float)  2.120996715e-05,	(float) -2.661876709e-05,
		(float)  2.288716536e-05,	(float) -1.557766050e-05,
		(float)  8.173014188e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 41 */
		(float)  0.000000000e+00,	(float) -2.776084138e-06,
		(float)  9.412473183e-06,	(float) -2.389429382e-05,
		(float)  5.062718110e-05,	(float) -9.472581556e-05,
		(float)  1.615124931e-04,	(float) -2.557551627e-04,
		(float)  3.806549304e-04,	(float) -5.366265323e-04,
		(float)  7.199498473e-04,	(float) -9.214015490e-04,
		(float)  1.124998497e-03,	(float) -1.306993600e-03,
		(float)  1.435256466e-03,	(float) -1.469142087e-03,
		(float)  1.359899112e-03,	(float) -1.051593765e-03,
		(float)  4.824244555e-04,	(float)  4.138294545e-04,
		(float) -1.706657616e-03,	(float)  3.468657285e-03,
		(float) -5.777474141e-03,	(float)  8.721754907e-03,
		(float) -1.241470062e-02,	(float)  1.702273378e-02,
		(float) -2.282696629e-02,	(float)  3.036499480e-02,
		(float) -4.080356423e-02,	(float)  5.714196709e-02,
		(float) -8.970348619e-02,	(float)  2.100673964e-01,
		(float)  4.051491477e-01,	(float) -8.506958595e-02,
		(float)  3.937197501e-02,	(float) -2.049084928e-02,
		(float)  1.009909102e-02,	(float) -3.652760537e-03,
		(float) -5.279956147e-04,	(float)  3.227016767e-03,
		(float) -4.878894049e-03,	(float)  5.761300902e-03,
		(float) -6.072996140e-03,	(float)  5.968165995e-03,
		(float) -5.572099279e-03,	(float)  4.988347102e-03,
		(float) -4.301960609e-03,	(float)  3.581057007e-03,
		(float) -2.877862955e-03,	(float)  2.229811206e-03,
		(float) -1.660940730e-03,	(float)  1.183654912e-03,
		(float) -8.007748041e-04,	(float)  5.077595509e-04,
		(float) -2.949400782e-04,	(float)  1.496151315e-04,
		(float) -5.788263507e-05,	(float)  6.116420574e-06,
		(float)  1.795843180e-05,	(float) -2.459546379e-05,
		(float)  2.172821132e-05,	(float) -1.498090978e-05,
		(float)  7.908970330e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 42 */
		(float)  0.000000000e+00,	(float) -2.617897350e-06,
		(float)  9.040300361e-06,	(float) -2.323155141e-05,
		(float)  4.963070476e-05,	(float) -9.342733206e-05,
		(float)  1.600722601e-04,	(float) -2.545254139e-04,
		(float)  3.802486362e-04,	(float) -5.379848486e-04,
		(float)  7.243997346e-04,	(float) -9.306936815e-04,
		(float)  1.141314992e-03,	(float) -1.332915467e-03,
		(float)  1.473682090e-03,	(float) -1.523150427e-03,
		(float)  1.432554438e-03,	(float) -1.145692177e-03,
		(float)  6.001854973e-04,	(float)  2.711210365e-04,
		(float) -1.539055998e-03,	(float)  3.278007836e-03,
		(float) -5.567931792e-03,	(float)  8.500420550e-03,
		(float) -1.219250005e-02,	(float)  1.681582677e-02,
		(float) -2.265937630e-02,	(float)  3.027428293e-02,
		(float) -4.085517836e-02,	(float)  5.747439394e-02,
		(float) -9.073508605e-02,	(float)  2.148725799e-01,
		(float)  4.019117233e-01,	(float) -8.648496638e-02,
		(float)  4.048124629e-02,	(float) -2.138164522e-02,
		(float)  1.082953490e-02,	(float) -4.254852372e-03,
		(float) -3.422866145e-05,	(float)  2.827044202e-03,
		(float) -4.560744684e-03,	(float)  5.514222998e-03,
		(float) -5.886890923e-03,	(float)  5.833414694e-03,
		(float) -5.479589677e-03,	(float)  4.929590693e-03,
		(float) -4.269235075e-03,	(float)  3.567534001e-03,
		(float) -2.877697824e-03,	(float)  2.238183237e-03,
		(float) -1.674041493e-03,	(float)  1.198628939e-03,
		(float) -8.156214454e-04,	(float)  5.212075801e-04,
		(float) -3.063076086e-04,	(float)  1.586669447e-04,
		(float) -6.469539288e-05,	(float)  1.095982572e-05,
		(float)  1.471927373e-05,	(float) -2.257407624e-05,
		(float)  2.056734438e-05,	(float) -1.438195111e-05,
		(float)  7.643856331e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 43 */
		(float)  0.000000000e+00,	(float) -2.455152310e-06,
		(float)  8.658171107e-06,	(float) -2.254896240e-05,
		(float)  4.859788630e-05,	(float) -9.206705492e-05,
		(float)  1.585335139e-04,	(float) -2.531472907e-04,
		(float)  3.796300484e-04,	(float) -5.390535462e-04,
		(float)  7.284721596e-04,	(float) -9.395157780e-04,
		(float)  1.157073440e-03,	(float) -1.358209106e-03,
		(float)  1.511444650e-03,	(float) -1.576518007e-03,
		(float)  1.504674289e-03,	(float) -1.239472778e-03,
		(float)  7.179910586e-04,	(float)  1.278266704e-04,
		(float) -1.370111913e-03,	(float)  3.085006880e-03,
		(float) -5.354736655e-03,	(float)  8.273795221e-03,
		(float) -1.196297789e-02,	(float)  1.659909677e-02,
		(float) -2.247886582e-02,	(float)  3.016673524e-02,
		(float) -4.088479860e-02,	(float)  5.777758276e-02,
		(float) -9.172709841e-02,	(float)  2.196732162e-01,
		(float)  3.986118635e-01,	(float) -8.783686500e-02,
		(float)  4.156085211e-02,	(float) -2.225629421e-02,
		(float)  1.155105602e-02,	(float) -4.852444309e-03,
		(float)  4.579176697e-04,	(float)  2.426788299e-03,
		(float) -4.241080122e-03,	(float)  5.264884740e-03,
		(float) -5.698139992e-03,	(float)  5.695897443e-03,
		(float) -5.384384279e-03,	(float)  4.868338350e-03,
		(float) -4.234293664e-03,	(float)  3.552115559e-03,
		(float) -2.875967062e-03,	(float)  2.245305841e-03,
		(float) -1.686179718e-03,	(float)  1.212888620e-03,
		(float) -8.299591464e-04,	(float)  5.343093684e-04,
		(float) -3.174520131e-04,	(float)  1.675842507e-04,
		(float) -7.143386650e-05,	(float)  1.576709675e-05,
		(float)  1.149422697e-05,	(float) -2.055573774e-05,
		(float)  1.940525369e-05,	(float) -1.378116814e-05,
		(float)  7.377861835e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 44 */
		(float)  0.000000000e+00,	(float) -2.287893971e-06,
		(float)  8.266206981e-06,	(float) -2.184674175e-05,
		(float)  4.752902581e-05,	(float) -9.064531460e-05,
		(float)  1.568964869e-04,	(float) -2.516206950e-04,
		(float)  3.787983683e-04,	(float) -5.398305878e-04,
		(float)  7.321631151e-04,	(float) -9.478609241e-04,
		(float)  1.172262877e-03,	(float) -1.382858183e-03,
		(float)  1.548520987e-03,	(float) -1.629213340e-03,
		(float)  1.576217403e-03,	(float) -1.332883286e-03,
		(float)  8.357769599e-04,	(float) -1.597726687e-05,
		(float) -1.199913424e-03,	(float)  2.889752568e-03,
		(float) -5.137993942e-03,	(float)  8.041986287e-03,
		(float) -1.172623622e-02,	(float)  1.637262940e-02,
		(float) -2.228548703e-02,	(float)  3.004234276e-02,
		(float) -4.089230438e-02,	(float)  5.805119114e-02,
		(float) -9.267864328e-02,	(float)  2.244678838e-01,
		(float)  3.952506255e-01,	(float) -8.912539454e-02,
		(float)  4.261043853e-02,	(float) -2.311441382e-02,
		(float)  1.226330454e-02,	(float) -5.445230656e-03,
		(float)  9.481828085e-04,	(float)  2.026466610e-03,
		(float) -3.920078188e-03,	(float)  5.013428098e-03,
		(float) -5.506853651e-03,	(float)  5.555697210e-03,
		(float) -5.286543034e-03,	(float)  4.804631170e-03,
		(float) -4.197162519e-03,	(float)  3.534816396e-03,
		(float) -2.872677049e-03,	(float)  2.251179669e-03,
		(float) -1.697352446e-03,	(float)  1.226429028e-03,
		(float) -8.437822188e-04,	(float)  5.470592917e-04,
		(float) -3.283682395e-04,	(float)  1.763628278e-04,
		(float) -7.809474065e-05,	(float)  2.053577807e-05,
		(float)  8.285005886e-06,	(float) -1.854157128e-05,
		(float)  1.824262313e-05,	(float) -1.317894172e-05,
		(float)  7.111174691e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 45 */
		(float)  0.000000000e+00,	(float) -2.116171194e-06,
		(float)  7.864537144e-06,	(float) -2.112511816e-05,
		(float)  4.642444676e-05,	(float) -8.916247908e-05,
		(float)  1.551614689e-04,	(float) -2.499456115e-04,
		(float)  3.777529120e-04,	(float) -5.403140880e-04,
		(float)  7.354687867e-04,	(float) -9.557224387e-04,
		(float)  1.186872610e-03,	(float) -1.406846654e-03,
		(float)  1.584888235e-03,	(float) -1.681205198e-03,
		(float)  1.647142697e-03,	(float) -1.425871452e-03,
		(float)  9.534788307e-04,	(float) -1.602138860e-04,
		(float) -1.028549543e-03,	(float)  2.692344570e-03,
		(float) -4.917811109e-03,	(float)  7.805104257e-03,
		(float) -1.148238134e-02,	(float)  1.613651584e-02,
		(float) -2.207929922e-02,	(float)  2.990110550e-02,
		(float) -4.087758622e-02,	(float)  5.829488970e-02,
		(float) -9.358885115e-02,	(float)  2.292551585e-01,
		(float)  3.918290856e-01,	(float) -9.035069110e-02,
		(float)  4.362966889e-02,	(float) -2.395563219e-02,
		(float)  1.296593699e-02,	(float) -6.032909396e-03,
		(float)  1.436308058e-03,	(float)  1.626296045e-03,
		(float) -3.597916895e-03,	(float)  4.759995769e-03,
		(float) -5.313143255e-03,	(float)  5.412898171e-03,
		(float) -5.186127141e-03,	(float)  4.738511458e-03,
		(float) -4.157868894e-03,	(float)  3.515652209e-03,
		(float) -2.867834995e-03,	(float)  2.255806055e-03,
		(float) -1.707557256e-03,	(float)  1.239245651e-03,
		(float) -8.570852818e-04,	(float)  5.594519453e-04,
		(float) -3.390513858e-04,	(float)  1.849985530e-04,
		(float) -8.467476194e-05,	(float)  2.526345078e-05,
		(float)  5.093304261e-06,	(float) -1.653268891e-05,
		(float)  1.708013097e-05,	(float) -1.257564965e-05,
		(float)  6.843980848e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 46 */
		(float)  0.000000000e+00,	(float) -1.940036756e-06,
		(float)  7.453298356e-06,	(float) -2.038433411e-05,
		(float)  4.528449606e-05,	(float) -8.761895399e-05,
		(float)  1.533288069e-04,	(float) -2.481221083e-04,
		(float)  3.764931113e-04,	(float) -5.405023155e-04,
		(float)  7.383855562e-04,	(float) -9.630938791e-04,
		(float)  1.200892218e-03,	(float) -1.430158776e-03,
		(float)  1.620523832e-03,	(float) -1.732462628e-03,
		(float)  1.717409286e-03,	(float) -1.518385087e-03,
		(float)  1.071032144e-03,	(float) -3.048058264e-04,
		(float) -8.561101865e-04,	(float)  2.492884025e-03,
		(float) -4.694297798e-03,	(float)  7.563262726e-03,
		(float) -1.123152374e-02,	(float)  1.589085279e-02,
		(float) -2.186036878e-02,	(float)  2.974303248e-02,
		(float) -4.084054588e-02,	(float)  5.850836236e-02,
		(float) -9.445686345e-02,	(float)  2.340336143e-01,
		(float)  3.883483379e-01,	(float) -9.151291393e-02,
		(float)  4.461822386e-02,	(float) -2.477958812e-02,
		(float)  1.365861641e-02,	(float) -6.615182341e-03,
		(float)  1.922036727e-03,	(float)  1.226492759e-03,
		(float) -3.274774350e-03,	(float)  4.504731102e-03,
		(float) -5.117121148e-03,	(float)  5.267585669e-03,
		(float) -5.083199017e-03,	(float)  4.670022704e-03,
		(float) -4.116441133e-03,	(float)  3.494639659e-03,
		(float) -2.861448933e-03,	(float)  2.259187008e-03,
		(float) -1.716792271e-03,	(float)  1.251334391e-03,
		(float) -8.698632632e-04,	(float)  5.714821458e-04,
		(float) -3.494967031e-04,	(float)  1.934874044e-04,
		(float) -9.117074036e-05,	(float)  2.994773384e-05,
		(float)  1.920794499e-06,	(float) -1.453019125e-05,
		(float)  1.591844953e-05,	(float) -1.197166656e-05,
		(float)  6.576464248e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 47 */
		(float)  0.000000000e+00,	(float) -1.759547362e-06,
		(float)  7.032634963e-06,	(float) -1.962464579e-05,
		(float)  4.410954395e-05,	(float) -8.601518254e-05,
		(float)  1.513989055e-04,	(float) -2.461503376e-04,
		(float)  3.750185148e-04,	(float) -5.403936945e-04,
		(float)  7.409100041e-04,	(float) -9.699690455e-04,
		(float)  1.214311565e-03,	(float) -1.452779118e-03,
		(float)  1.655405534e-03,	(float) -1.782954973e-03,
		(float)  1.786976510e-03,	(float) -1.610372093e-03,
		(float)  1.188372251e-03,	(float) -4.496752965e-04,
		(float) -6.826861240e-04,	(float)  2.291473490e-03,
		(float) -4.467565791e-03,	(float)  7.316578321e-03,
		(float) -1.097377804e-02,	(float)  1.563574242e-02,
		(float) -2.162876922e-02,	(float)  2.956814174e-02,
		(float) -4.078109641e-02,	(float)  5.869130654e-02,
		(float) -9.528183288e-02,	(float)  2.388018238e-01,
		(float)  3.848094944e-01,	(float) -9.261224535e-02,
		(float)  4.557580150e-02,	(float) -2.558593122e-02,
		(float)  1.434101253e-02,	(float) -7.191755273e-03,
		(float)  2.405114260e-03,	(float)  8.272720334e-04,
		(float) -2.950828656e-03,	(float)  4.247778015e-03,
		(float) -4.918900596e-03,	(float)  5.119846158e-03,
		(float) -4.977822258e-03,	(float)  4.599209554e-03,
		(float) -4.072908655e-03,	(float)  3.471796359e-03,
		(float) -2.853527714e-03,	(float)  2.261325213e-03,
		(float) -1.725056150e-03,	(float)  1.262691568e-03,
		(float) -8.821114015e-04,	(float)  5.831449333e-04,
		(float) -3.596995967e-04,	(float)  2.018254621e-04,
		(float) -9.757955070e-05,	(float)  3.458628518e-05,
		(float) -1.230873204e-06,	(float) -1.253516687e-05,
		(float)  1.475824479e-05,	(float) -1.136736362e-05,
		(float)  6.308806722e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 48 */
		(float)  0.000000000e+00,	(float) -1.574763653e-06,
		(float)  6.602698888e-06,	(float) -1.884632310e-05,
		(float)  4.289998406e-05,	(float) -8.435164561e-05,
		(float)  1.493722271e-04,	(float) -2.440305354e-04,
		(float)  3.733287888e-04,	(float) -5.399868068e-04,
		(float)  7.430389125e-04,	(float) -9.763419855e-04,
		(float)  1.227120805e-03,	(float) -1.474692571e-03,
		(float)  1.689511432e-03,	(float) -1.832651883e-03,
		(float)  1.855803952e-03,	(float) -1.701780489e-03,
		(float)  1.305434416e-03,	(float) -5.947441153e-04,
		(float) -5.083689365e-04,	(float)  2.088216888e-03,
		(float) -4.237728952e-03,	(float)  7.065170652e-03,
		(float) -1.070926295e-02,	(float)  1.537129232e-02,
		(float) -2.138458111e-02,	(float)  2.937646043e-02,
		(float) -4.069916228e-02,	(float)  5.884343343e-02,
		(float) -9.606292390e-02,	(float)  2.435583589e-01,
		(float)  3.812136842e-01,	(float) -9.364889048e-02,
		(float)  4.650211728e-02,	(float) -2.637432205e-02,
		(float)  1.501280189e-02,	(float) -7.762338089e-03,
		(float)  2.885288371e-03,	(float)  4.288481687e-04,
		(float) -2.626257815e-03,	(float)  3.989280916e-03,
		(float) -4.718595726e-03,	(float)  4.969767153e-03,
		(float) -4.870061598e-03,	(float)  4.526117779e-03,
		(float) -4.027301931e-03,	(float)  3.447140866e-03,
		(float) -2.844080995e-03,	(float)  2.262224025e-03,
		(float) -1.732348089e-03,	(float)  1.273313916e-03,
		(float) -8.938252469e-04,	(float)  5.944355729e-04,
		(float) -3.696556283e-04,	(float)  2.100089107e-04,
		(float) -1.038981340e-04,	(float)  3.917680280e-05,
		(float) -4.360071645e-06,	(float) -1.054869179e-05,
		(float)  1.360017606e-05,	(float) -1.076310838e-05,
		(float)  6.041187891e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 49 */
		(float)  0.000000000e+00,	(float) -1.385750205e-06,
		(float)  6.163649605e-06,	(float) -1.804964960e-05,
		(float)  4.165623326e-05,	(float) -8.262886166e-05,
		(float)  1.472492915e-04,	(float) -2.417630226e-04,
		(float)  3.714237180e-04,	(float) -5.392803929e-04,
		(float)  7.447692679e-04,	(float) -9.822069986e-04,
		(float)  1.239310387e-03,	(float) -1.495884355e-03,
		(float)  1.722819959e-03,	(float) -1.881523344e-03,
		(float)  1.923851465e-03,	(float) -1.792558445e-03,
		(float)  1.422153851e-03,	(float) -7.399337537e-04,
		(float) -3.332509657e-04,	(float)  1.883219456e-03,
		(float) -4.004903168e-03,	(float)  6.809162253e-03,
		(float) -1.043810123e-02,	(float)  1.509761552e-02,
		(float) -2.112789208e-02,	(float)  2.916802474e-02,
		(float) -4.059467949e-02,	(float)  5.896446814e-02,
		(float) -9.679931309e-02,	(float)  2.483017911e-01,
		(float)  3.775620537e-01,	(float) -9.462307715e-02,
		(float)  4.739690413e-02,	(float) -2.714443222e-02,
		(float)  1.567366800e-02,	(float) -8.326644942e-03,
		(float)  3.362309164e-03,	(float)  3.143436718e-05,
		(float) -2.301239634e-03,	(float)  3.729384625e-03,
		(float) -4.516321461e-03,	(float)  4.817437181e-03,
		(float) -4.759982873e-03,	(float)  4.450794251e-03,
		(float) -3.979652466e-03,	(float)  3.420692663e-03,
		(float) -2.833119235e-03,	(float)  2.261887466e-03,
		(float) -1.738667822e-03,	(float)  1.283198588e-03,
		(float) -9.050006623e-04,	(float)  6.053495563e-04,
		(float) -3.793605176e-04,	(float)  2.180340402e-04,
		(float) -1.101234988e-04,	(float)  4.371702580e-05,
		(float) -7.465197400e-06,	(float) -8.571828924e-06,
		(float)  1.244489567e-05,	(float) -1.015926458e-05,
		(float)  5.773785067e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 50 */
		(float)  0.000000000e+00,	(float) -1.192575530e-06,
		(float)  5.715654117e-06,	(float) -1.723492243e-05,
		(float)  4.037873169e-05,	(float) -8.084738676e-05,
		(float)  1.450306767e-04,	(float) -2.393482046e-04,
		(float)  3.693032062e-04,	(float) -5.382733539e-04,
		(float)  7.460982640e-04,	(float) -9.875586400e-04,
		(float)  1.250871062e-03,	(float) -1.516340029e-03,
		(float)  1.755309910e-03,	(float) -1.929539683e-03,
		(float)  1.991079197e-03,	(float) -1.882654305e-03,
		(float)  1.538465755e-03,	(float) -8.851653765e-04,
		(float) -1.574252674e-04,	(float)  1.676587690e-03,
		(float) -3.769206299e-03,	(float)  6.548678523e-03,
		(float) -1.016041961e-02,	(float)  1.481483038e-02,
		(float) -2.085879683e-02,	(float)  2.894287998e-02,
		(float) -4.046759561e-02,	(float)  5.905414998e-02,
		(float) -9.749018956e-02,	(float)  2.530306922e-01,
		(float)  3.738557652e-01,	(float) -9.553505564e-02,
		(float)  4.825991244e-02,	(float) -2.789594452e-02,
		(float)  1.632330145e-02,	(float) -8.884394373e-03,
		(float)  3.835929268e-03,	(float) -3.647573768e-04,
		(float) -1.975951628e-03,	(float)  3.468234291e-03,
		(float) -4.312193453e-03,	(float)  4.662945732e-03,
		(float) -4.647652982e-03,	(float)  4.373286913e-03,
		(float) -3.929992780e-03,	(float)  3.392472148e-03,
		(float) -2.820653684e-03,	(float)  2.260320218e-03,
		(float) -1.744015613e-03,	(float)  1.292343153e-03,
		(float) -9.156338247e-04,	(float)  6.158826035e-04,
		(float) -3.888101438e-04,	(float)  2.258972478e-04,
		(float) -1.162527225e-04,	(float)  4.820473546e-05,
		(float) -1.054467157e-05,	(float) -6.605627573e-06,
		(float)  1.129304861e-05,	(float) -9.556191960e-06,
		(float)  5.506773153e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 51 */
		(float)  0.000000000e+00,	(float) -9.953120805e-07,
		(float)  5.258886929e-06,	(float) -1.640245229e-05,
		(float)  3.906794259e-05,	(float) -7.900781448e-05,
		(float)  1.427170181e-04,	(float) -2.367865723e-04,
		(float)  3.669672771e-04,	(float) -5.369647523e-04,
		(float)  7.470233037e-04,	(float) -9.923917254e-04,
		(float)  1.261793893e-03,	(float) -1.536045502e-03,
		(float)  1.786960447e-03,	(float) -1.976671596e-03,
		(float)  2.057447605e-03,	(float) -1.972016620e-03,
		(float)  1.654305341e-03,	(float) -1.030359885e-03,
		(float)  1.901443819e-05,	(float)  1.468429293e-03,
		(float) -3.530758113e-03,	(float)  6.283847671e-03,
		(float) -9.876348737e-03,	(float)  1.452306056e-02,
		(float) -2.057739702e-02,	(float)  2.870108059e-02,
		(float) -4.031786987e-02,	(float)  5.911223263e-02,
		(float) -9.813475536e-02,	(float)  2.577436346e-01,
		(float)  3.700959974e-01,	(float) -9.638509853e-02,
		(float)  4.909091009e-02,	(float) -2.862855300e-02,
		(float)  1.696140010e-02,	(float) -9.435309453e-03,
		(float)  4.305903954e-03,	(float) -7.595163872e-04,
		(float) -1.650570925e-03,	(float)  3.205975317e-03,
		(float) -4.106328022e-03,	(float)  4.506383200e-03,
		(float) -4.533139846e-03,	(float)  4.293644746e-03,
		(float) -3.878356382e-03,	(float)  3.362500616e-03,
		(float) -2.806696375e-03,	(float)  2.257527622e-03,
		(float) -1.748392263e-03,	(float)  1.300745595e-03,
		(float) -9.257212256e-04,	(float)  6.260306637e-04,
		(float) -3.980005475e-04,	(float)  2.335950396e-04,
		(float) -1.222829527e-04,	(float)  5.263775617e-05,
		(float) -1.359694055e-05,	(float) -4.651122908e-06,
		(float)  1.014527220e-05,	(float) -8.954246045e-06,
		(float)  5.240324560e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 52 */
		(float)  0.000000000e+00,	(float) -7.940362356e-07,
		(float)  4.793530008e-06,	(float) -1.555256334e-05,
		(float)  3.772435228e-05,	(float) -7.711077581e-05,
		(float)  1.403090095e-04,	(float) -2.340787017e-04,
		(float)  3.644160749e-04,	(float) -5.353538142e-04,
		(float)  7.475420021e-04,	(float) -9.967013345e-04,
		(float)  1.272070254e-03,	(float) -1.554987044e-03,
		(float)  1.817751122e-03,	(float) -2.022890160e-03,
		(float)  2.122917489e-03,	(float) -2.060594175e-03,
		(float)  1.769607882e-03,	(float) -1.175437957e-03,
		(float)  1.959738149e-04,	(float)  1.258853119e-03,
		(float) -3.289680233e-03,	(float)  6.014800647e-03,
		(float) -9.586023143e-03,	(float)  1.422243501e-02,
		(float) -2.028380136e-02,	(float)  2.844269012e-02,
		(float) -4.014547327e-02,	(float)  5.913848436e-02,
		(float) -9.873222590e-02,	(float)  2.624391922e-01,
		(float)  3.662839442e-01,	(float) -9.717350048e-02,
		(float)  4.988968246e-02,	(float) -2.934196314e-02,
		(float)  1.758766916e-02,	(float) -9.979117905e-03,
		(float)  4.771991262e-03,	(float) -1.152633416e-03,
		(float) -1.325274172e-03,	(float)  2.942753275e-03,
		(float) -3.898842087e-03,	(float)  4.347840841e-03,
		(float) -4.416512366e-03,	(float)  4.211917745e-03,
		(float) -3.824777752e-03,	(float)  3.330800251e-03,
		(float) -2.791260115e-03,	(float)  2.253515667e-03,
		(float) -1.751799098e-03,	(float)  1.308404314e-03,
		(float) -9.352596715e-04,	(float)  6.357899170e-04,
		(float) -4.069279317e-04,	(float)  2.411240316e-04,
		(float) -1.282114082e-04,	(float)  5.701395647e-05,
		(float) -1.662047669e-05,	(float) -2.709335474e-06,
		(float)  9.002195797e-06,	(float) -8.353777994e-06,
		(float)  4.974609106e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 53 */
		(float)  0.000000000e+00,	(float) -5.888282991e-07,
		(float)  4.319772745e-06,	(float) -1.468559314e-05,
		(float)  3.634847002e-05,	(float) -7.515693907e-05,
		(float)  1.378074020e-04,	(float) -2.312252543e-04,
		(float)  3.616498649e-04,	(float) -5.334399297e-04,
		(float)  7.476521884e-04,	(float) -1.000482815e-03,
		(float)  1.281691843e-03,	(float) -1.573151287e-03,
		(float)  1.847661880e-03,	(float) -2.068166851e-03,
		(float)  2.187450006e-03,	(float) -2.148336017e-03,
		(float)  1.884308738e-03,	(float) -1.320320095e-03,
		(float)  3.733579605e-04,	(float)  1.047969115e-03,
		(float) -3.046096068e-03,	(float)  5.741671089e-03,
		(float) -9.289581158e-03,	(float)  1.391308786e-02,
		(float) -1.997812545e-02,	(float)  2.816778123e-02,
		(float) -3.995038861e-02,	(float)  5.913268823e-02,
		(float) -9.928183026e-02,	(float)  2.671159407e-01,
		(float)  3.624208148e-01,	(float) -9.790057798e-02,
		(float)  5.065603242e-02,	(float) -3.003589186e-02,
		(float)  1.820182131e-02,	(float) -1.051555224e-02,
		(float)  5.233952121e-03,	(float) -1.543900753e-03,
		(float) -1.000237439e-03,	(float)  2.678713830e-03,
		(float) -3.689853101e-03,	(float)  4.187410713e-03,
		(float) -4.297840389e-03,	(float)  4.128156882e-03,
		(float) -3.769292321e-03,	(float)  3.297394104e-03,
		(float) -2.774358475e-03,	(float)  2.248290989e-03,
		(float) -1.754237972e-03,	(float)  1.315318126e-03,
		(float) -9.442462848e-04,	(float)  6.451567752e-04,
		(float) -4.155886634e-04,	(float)  2.484809510e-04,
		(float) -1.340353803e-04,	(float)  6.133124992e-05,
		(float) -1.961377907e-05,	(float) -7.812707116e-07,
		(float)  7.864440487e-06,	(float) -7.755134414e-06,
		(float)  4.709793936e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 54 */
		(float)  0.000000000e+00,	(float) -3.797724868e-07,
		(float)  3.837811911e-06,	(float) -1.380189256e-05,
		(float)  3.494082788e-05,	(float) -7.314700979e-05,
		(float)  1.352130047e-04,	(float) -2.282269774e-04,
		(float)  3.586690337e-04,	(float) -5.312226545e-04,
		(float)  7.473519082e-04,	(float) -1.003731786e-03,
		(float)  1.290650684e-03,	(float) -1.590525243e-03,
		(float)  1.876673078e-03,	(float) -2.112473561e-03,
		(float)  2.251006696e-03,	(float) -2.235191487e-03,
		(float)  1.998343395e-03,	(float) -1.464926662e-03,
		(float)  5.510714571e-04,	(float)  8.358882680e-04,
		(float) -2.800130759e-03,	(float)  5.464595249e-03,
		(float) -8.987164858e-03,	(float)  1.359515841e-02,
		(float) -1.966049185e-02,	(float)  2.787643572e-02,
		(float) -3.973261058e-02,	(float)  5.909464227e-02,
		(float) -9.978281167e-02,	(float)  2.717724580e-01,
		(float)  3.585078330e-01,	(float) -9.856666920e-02,
		(float)  5.138978033e-02,	(float) -3.071006769e-02,
		(float)  1.880357688e-02,	(float) -1.104434989e-02,
		(float)  5.691550467e-03,	(float) -1.933112330e-03,
		(float) -6.756361289e-04,	(float)  2.414002661e-03,
		(float) -3.479478990e-03,	(float)  4.025185626e-03,
		(float) -4.177194661e-03,	(float)  4.042414082e-03,
		(float) -3.711936443e-03,	(float)  3.262306082e-03,
		(float) -2.756005780e-03,	(float)  2.241860866e-03,
		(float) -1.755711263e-03,	(float)  1.321486258e-03,
		(float) -9.526785038e-04,	(float)  6.541278828e-04,
		(float) -4.239792746e-04,	(float)  2.556626380e-04,
		(float) -1.397522341e-04,	(float)  6.558759607e-05,
		(float) -2.257537412e-05,	(float)  1.132081522e-06,
		(float)  6.732618765e-06,	(float) -7.158657180e-06,
		(float)  4.446043433e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 55 */
		(float)  0.000000000e+00,	(float) -1.669569129e-07,
		(float)  3.347851602e-06,	(float) -1.290182567e-05,
		(float)  3.350198062e-05,	(float) -7.108173053e-05,
		(float)  1.325266843e-04,	(float) -2.250847039e-04,
		(float)  3.554740902e-04,	(float) -5.287017109e-04,
		(float)  7.466394257e-04,	(float) -1.006444143e-03,
		(float)  1.298939136e-03,	(float) -1.607096308e-03,
		(float)  1.904765493e-03,	(float) -2.155782616e-03,
		(float)  2.313549506e-03,	(float) -2.321110246e-03,
		(float)  2.111647503e-03,	(float) -1.609177931e-03,
		(float)  7.290184210e-04,	(float)  6.227225451e-04,
		(float) -2.551911113e-03,	(float)  5.183711935e-03,
		(float) -8.678919996e-03,	(float)  1.326879104e-02,
		(float) -1.933102995e-02,	(float)  2.756874448e-02,
		(float) -3.949214579e-02,	(float)  5.902415965e-02,
		(float) -1.002344278e-01,	(float)  2.764073251e-01,
		(float)  3.545462365e-01,	(float) -9.917213369e-02,
		(float)  5.209076399e-02,	(float) -3.136423078e-02,
		(float)  1.939266390e-02,	(float) -1.156525329e-02,
		(float)  6.144553361e-03,	(float) -2.320063829e-03,
		(float) -3.516448818e-04,	(float)  2.148765381e-03,
		(float) -3.267838082e-03,	(float)  3.861259090e-03,
		(float) -4.054646786e-03,	(float)  3.954742185e-03,
		(float) -3.652747377e-03,	(float)  3.225560929e-03,
		(float) -2.736217097e-03,	(float)  2.234233205e-03,
		(float) -1.756221868e-03,	(float)  1.326908353e-03,
		(float) -9.605540825e-04,	(float)  6.627001179e-04,
		(float) -4.320964637e-04,	(float)  2.626660462e-04,
		(float) -1.453594091e-04,	(float)  6.978100128e-05,
		(float) -2.550381630e-05,	(float)  3.029747407e-06,
		(float)  5.607334251e-06,	(float) -6.564683277e-06,
		(float)  4.183519138e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 56 */
		(float)  0.000000000e+00,	(float)  4.952642645e-08,
		(float)  2.850103188e-06,	(float) -1.198576965e-05,
		(float)  3.203250551e-05,	(float) -6.896188072e-05,
		(float)  1.297493650e-04,	(float) -2.217993521e-04,
		(float)  3.520656652e-04,	(float) -5.258769886e-04,
		(float)  7.455132256e-04,	(float) -1.008616059e-03,
		(float)  1.306549893e-03,	(float) -1.622852271e-03,
		(float)  1.931920337e-03,	(float) -2.198066793e-03,
		(float)  2.375040807e-03,	(float) -2.406042304e-03,
		(float)  2.224156906e-03,	(float) -1.752994123e-03,
		(float)  9.071025543e-04,	(float)  4.085848357e-04,
		(float) -2.301565537e-03,	(float)  4.899162436e-03,
		(float) -8.364995933e-03,	(float)  1.293413518e-02,
		(float) -1.898987600e-02,	(float)  2.724480754e-02,
		(float) -3.922901284e-02,	(float)  5.892106890e-02,
		(float) -1.006359513e-01,	(float)  2.810191263e-01,
		(float)  3.505372770e-01,	(float) -9.971735215e-02,
		(float)  5.275883867e-02,	(float) -3.199813306e-02,
		(float)  1.996881826e-02,	(float) -1.207801008e-02,
		(float)  6.592731103e-03,	(float) -2.704552788e-03,
		(float) -2.843748365e-05,	(float)  1.883147457e-03,
		(float) -3.055049044e-03,	(float)  3.695725263e-03,
		(float) -3.930269189e-03,	(float)  3.865194919e-03,
		(float) -3.591763262e-03,	(float)  3.187184214e-03,
		(float) -2.715008228e-03,	(float)  2.225416543e-03,
		(float) -1.755773202e-03,	(float)  1.331584463e-03,
		(float) -9.678710910e-04,	(float)  6.708705926e-04,
		(float) -4.399370964e-04,	(float)  2.694882443e-04,
		(float) -1.508544205e-04,	(float)  7.390951959e-05,
		(float) -2.839768874e-05,	(float)  4.910769612e-06,
		(float)  4.489181408e-06,	(float) -5.973544629e-06,
		(float)  3.922379672e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 57 */
		(float)  0.000000000e+00,	(float)  2.695816725e-07,
		(float)  2.344785248e-06,	(float) -1.105411468e-05,
		(float)  3.053300221e-05,	(float) -6.678827646e-05,
		(float)  1.268820283e-04,	(float) -2.183719265e-04,
		(float)  3.484445125e-04,	(float) -5.227485460e-04,
		(float)  7.439720147e-04,	(float) -1.010243991e-03,
		(float)  1.313475996e-03,	(float) -1.637781321e-03,
		(float)  1.958119269e-03,	(float) -2.239299334e-03,
		(float)  2.435443423e-03,	(float) -2.489938050e-03,
		(float)  2.335807685e-03,	(float) -1.896295455e-03,
		(float)  1.085227196e-03,	(float)  1.935888930e-04,
		(float) -2.049223976e-03,	(float)  4.611090458e-03,
		(float) -8.045545575e-03,	(float)  1.259134521e-02,
		(float) -1.863717300e-02,	(float)  2.690473396e-02,
		(float) -3.894324238e-02,	(float)  5.878521406e-02,
		(float) -1.009866700e-01,	(float)  2.856064498e-01,
		(float)  3.464822190e-01,	(float) -1.002027262e-01,
		(float)  5.339387703e-02,	(float) -3.261153822e-02,
		(float)  2.053178377e-02,	(float) -1.258237311e-02,
		(float)  7.035857344e-03,	(float) -3.086378700e-03,
		(float)  2.938132250e-04,	(float)  1.617294134e-03,
		(float) -2.841230819e-03,	(float)  3.528678895e-03,
		(float) -3.804135069e-03,	(float)  3.773826867e-03,
		(float) -3.529023093e-03,	(float)  3.147202308e-03,
		(float) -2.692395693e-03,	(float)  2.215420035e-03,
		(float) -1.754369191e-03,	(float)  1.335515049e-03,
		(float) -9.746279149e-04,	(float)  6.786366538e-04,
		(float) -4.474982065e-04,	(float)  2.761264171e-04,
		(float) -1.562348605e-04,	(float)  7.797125354e-05,
		(float) -3.125560387e-05,	(float)  6.774207725e-06,
		(float)  3.378745259e-06,	(float) -5.385567945e-06,
		(float)  3.662780656e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 58 */
		(float)  0.000000000e+00,	(float)  4.931091270e-07,
		(float)  1.832123508e-06,	(float) -1.010726381e-05,
		(float)  2.900409256e-05,	(float) -6.456177033e-05,
		(float)  1.239257130e-04,	(float) -2.148035167e-04,
		(float)  3.446115085e-04,	(float) -5.193166104e-04,
		(float)  7.420147241e-04,	(float) -1.011324679e-03,
		(float)  1.319710832e-03,	(float) -1.651872057e-03,
		(float)  1.983344404e-03,	(float) -2.279453965e-03,
		(float)  2.494720647e-03,	(float) -2.572748279e-03,
		(float)  2.446536187e-03,	(float) -2.039002179e-03,
		(float)  1.263295373e-03,	(float) -2.215072547e-05,
		(float) -1.795017844e-03,	(float)  4.319642053e-03,
		(float) -7.720725293e-03,	(float)  1.224058041e-02,
		(float) -1.827307069e-02,	(float)  2.654864190e-02,
		(float) -3.863487710e-02,	(float)  5.861645482e-02,
		(float) -1.012858873e-01,	(float)  2.901678886e-01,
		(float)  3.423823400e-01,	(float) -1.006286782e-01,
		(float)  5.399576909e-02,	(float) -3.320422187e-02,
		(float)  2.108131233e-02,	(float) -1.307810066e-02,
		(float)  7.473709200e-03,	(float) -3.465343122e-03,
		(float)  6.149354398e-04,	(float)  1.351350355e-03,
		(float) -2.626502554e-03,	(float)  3.360215276e-03,
		(float) -3.676318360e-03,	(float)  3.680693434e-03,
		(float) -3.464566697e-03,	(float)  3.105642374e-03,
		(float) -2.668396726e-03,	(float)  2.204253450e-03,
		(float) -1.752014272e-03,	(float)  1.338700981e-03,
		(float) -9.808232548e-04,	(float)  6.859958835e-04,
		(float) -4.547769969e-04,	(float)  2.825778660e-04,
		(float) -1.614983984e-04,	(float)  8.196435492e-05,
		(float) -3.407620399e-05,	(float)  8.619138673e-06,
		(float)  2.276601121e-06,	(float) -4.801074562e-06,
		(float)  3.404874641e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 59 */
		(float)  0.000000000e+00,	(float)  7.200052770e-07,
		(float)  1.312350761e-06,	(float) -9.145632795e-06,
		(float)  2.744642037e-05,	(float) -6.228325108e-05,
		(float)  1.208815146e-04,	(float) -2.110952980e-04,
		(float)  3.405676526e-04,	(float) -5.155815791e-04,
		(float)  7.396405105e-04,	(float) -1.011855153e-03,
		(float)  1.325248147e-03,	(float) -1.665113497e-03,
		(float)  2.007578327e-03,	(float) -2.318504912e-03,
		(float)  2.552836267e-03,	(float) -2.654424218e-03,
		(float)  2.556279064e-03,	(float) -2.181034632e-03,
		(float)  1.441209854e-03,	(float) -2.385187177e-04,
		(float) -1.539079962e-03,	(float)  4.024965541e-03,
		(float) -7.390694854e-03,	(float)  1.188200492e-02,
		(float) -1.789772547e-02,	(float)  2.617665853e-02,
		(float) -3.830397184e-02,	(float)  5.841466672e-02,
		(float) -1.015329225e-01,	(float)  2.947020403e-01,
		(float)  3.382389296e-01,	(float) -1.009956509e-01,
		(float)  5.456442219e-02,	(float) -3.377597152e-02,
		(float)  2.161716397e-02,	(float) -1.356495647e-02,
		(float)  7.906067356e-03,	(float) -3.841249769e-03,
		(float)  9.347584826e-04,	(float)  1.085460684e-03,
		(float) -2.410983543e-03,	(float)  3.190430183e-03,
		(float) -3.546893688e-03,	(float)  3.585850813e-03,
		(float) -3.398434711e-03,	(float)  3.062532342e-03,
		(float) -2.643029255e-03,	(float)  2.191927160e-03,
		(float) -1.748713384e-03,	(float)  1.341143533e-03,
		(float) -9.864561259e-04,	(float)  6.929460991e-04,
		(float) -4.617708403e-04,	(float)  2.888400104e-04,
		(float) -1.666427823e-04,	(float)  8.588702552e-05,
		(float) -3.685816187e-05,	(float)  1.044465713e-05,
		(float)  1.183314339e-06,	(float) -4.220380298e-06,
		(float)  3.148811037e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 60 */
		(float)  0.000000000e+00,	(float)  9.501628237e-07,
		(float)  7.857068007e-07,	(float) -8.169650028e-06,
		(float)  2.586065124e-05,	(float) -5.995364345e-05,
		(float)  1.177505853e-04,	(float) -2.072485310e-04,
		(float)  3.363140673e-04,	(float) -5.115440200e-04,
		(float)  7.368487578e-04,	(float) -1.011832733e-03,
		(float)  1.330082040e-03,	(float) -1.677495083e-03,
		(float)  2.030804105e-03,	(float) -2.356426913e-03,
		(float)  2.609754584e-03,	(float) -2.734917561e-03,
		(float)  2.664973310e-03,	(float) -2.322313272e-03,
		(float)  1.618873199e-03,	(float) -4.553990980e-04,
		(float) -1.281544482e-03,	(float)  3.727211445e-03,
		(float) -7.055617344e-03,	(float)  1.151578759e-02,
		(float) -1.751130036e-02,	(float)  2.578892005e-02,
		(float) -3.795059352e-02,	(float)  5.817974130e-02,
		(float) -1.017271115e-01,	(float)  2.992075084e-01,
		(float)  3.340532891e-01,	(float) -1.013041069e-01,
		(float)  5.509976092e-02,	(float) -3.432658668e-02,
		(float)  2.213910697e-02,	(float) -1.404270991e-02,
		(float)  8.332716174e-03,	(float) -4.213904616e-03,
		(float)  1.253112890e-03,	(float)  8.197692304e-04,
		(float) -2.194793155e-03,	(float)  3.019419828e-03,
		(float) -3.415936325e-03,	(float)  3.489355953e-03,
		(float) -3.330668553e-03,	(float)  3.017900900e-03,
		(float) -2.616311896e-03,	(float)  2.178452135e-03,
		(float) -1.744471966e-03,	(float)  1.342844384e-03,
		(float) -9.915258571e-04,	(float)  6.994853536e-04,
		(float) -4.684772799e-04,	(float)  2.949103884e-04,
		(float) -1.716658394e-04,	(float)  8.973751786e-05,
		(float) -3.960018130e-05,	(float)  1.224987592e-05,
		(float)  9.944003668e-08,	(float) -3.643795308e-06,
		(float)  2.894736044e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 61 */
		(float)  0.000000000e+00,	(float)  1.183470714e-06,
		(float)  2.524383297e-07,	(float) -7.179756330e-06,
		(float)  2.424747232e-05,	(float) -5.757390782e-05,
		(float)  1.145341336e-04,	(float) -2.032645613e-04,
		(float)  3.318519982e-04,	(float) -5.072046719e-04,
		(float)  7.336390785e-04,	(float) -1.011255035e-03,
		(float)  1.334206979e-03,	(float) -1.689006688e-03,
		(float)  2.053005295e-03,	(float) -2.393195241e-03,
		(float)  2.665440435e-03,	(float) -2.814180490e-03,
		(float)  2.772556292e-03,	(float) -2.462758728e-03,
		(float)  1.796187815e-03,	(float) -6.726752586e-04,
		(float) -1.022546824e-03,	(float)  3.426532408e-03,
		(float) -6.715659090e-03,	(float)  1.114210200e-02,
		(float) -1.711396489e-02,	(float)  2.538557160e-02,
		(float) -3.757482126e-02,	(float)  5.791158620e-02,
		(float) -1.018678067e-01,	(float)  3.036829022e-01,
		(float)  3.298267310e-01,	(float) -1.015545291e-01,
		(float)  5.560172707e-02,	(float) -3.485587888e-02,
		(float)  2.264691793e-02,	(float) -1.451113602e-02,
		(float)  8.753443799e-03,	(float) -4.583115997e-03,
		(float)  1.569830502e-03,	(float)  5.544195685e-04,
		(float) -1.978050772e-03,	(float)  2.847280799e-03,
		(float) -3.283522151e-03,	(float)  3.391266529e-03,
		(float) -3.261310399e-03,	(float)  2.971777466e-03,
		(float) -2.588263937e-03,	(float)  2.163839933e-03,
		(float) -1.739295954e-03,	(float)  1.343805611e-03,
		(float) -9.960320900e-04,	(float)  7.056119355e-04,
		(float) -4.748940299e-04,	(float)  3.007866573e-04,
		(float) -1.765654770e-04,	(float)  9.351413586e-05,
		(float) -4.230099761e-05,	(float)  1.403392638e-05,
		(float) -9.744771290e-07,	(float) -3.071623943e-06,
		(float)  2.642792589e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 62 */
		(float)  0.000000000e+00,	(float)  1.419814176e-06,
		(float) -2.872011223e-07,	(float) -6.176404809e-06,
		(float)  2.260759209e-05,	(float) -5.514503991e-05,
		(float)  1.112334241e-04,	(float) -1.991448193e-04,
		(float)  3.271828140e-04,	(float) -5.025644452e-04,
		(float)  7.300113149e-04,	(float) -1.010119970e-03,
		(float)  1.337617798e-03,	(float) -1.699638626e-03,
		(float)  2.074165956e-03,	(float) -2.428785711e-03,
		(float)  2.719859215e-03,	(float) -2.892165707e-03,
		(float)  2.878965790e-03,	(float) -2.602291842e-03,
		(float)  1.973056006e-03,	(float) -8.902300306e-04,
		(float) -7.622236056e-04,	(float)  3.123083121e-03,
		(float) -6.370989580e-03,	(float)  1.076112631e-02,
		(float) -1.670589509e-02,	(float)  2.496676725e-02,
		(float) -3.717674633e-02,	(float)  5.761012535e-02,
		(float) -1.019543774e-01,	(float)  3.081268378e-01,
		(float)  3.255605787e-01,	(float) -1.017474195e-01,
		(float)  5.607027955e-02,	(float) -3.536367175e-02,
		(float)  2.314038189e-02,	(float) -1.497001566e-02,
		(float)  9.168042257e-03,	(float) -4.948694699e-03,
		(float)  1.884744548e-03,	(float)  2.895546644e-04,
		(float) -1.760875725e-03,	(float)  2.674110013e-03,
		(float) -3.149727608e-03,	(float)  3.291640901e-03,
		(float) -3.190403159e-03,	(float)  2.924192178e-03,
		(float) -2.558905328e-03,	(float)  2.148102695e-03,
		(float) -1.733191770e-03,	(float)  1.344029690e-03,
		(float) -9.999747778e-04,	(float)  7.113243686e-04,
		(float) -4.810189758e-04,	(float)  3.064665946e-04,
		(float) -1.813396833e-04,	(float)  9.721523548e-05,
		(float) -4.495937819e-05,	(float)  1.579595873e-05,
		(float) -2.037903207e-06,	(float) -2.504164617e-06,
		(float)  2.393120265e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 63 */
		(float)  0.000000000e+00,	(float)  1.659074753e-06,
		(float) -8.329512938e-07,	(float) -5.160060699e-06,
		(float)  2.094174007e-05,	(float) -5.266807047e-05,
		(float)  1.078497769e-04,	(float) -1.948908198e-04,
		(float)  3.223080060e-04,	(float) -4.976244220e-04,
		(float)  7.259655403e-04,	(float) -1.008425748e-03,
		(float)  1.340309704e-03,	(float) -1.709381659e-03,
		(float)  2.094270662e-03,	(float) -2.463174704e-03,
		(float)  2.772976897e-03,	(float) -2.968826458e-03,
		(float)  2.984140031e-03,	(float) -2.740833712e-03,
		(float)  2.149380026e-03,	(float) -1.107945747e-03,
		(float) -5.007125679e-04,	(float)  2.817020245e-03,
		(float) -6.021781378e-03,	(float)  1.037304319e-02,
		(float) -1.628727340e-02,	(float)  2.453266995e-02,
		(float) -3.675647219e-02,	(float)  5.727529908e-02,
		(float) -1.019862105e-01,	(float)  3.125379383e-01,
		(float)  3.212561654e-01,	(float) -1.018832998e-01,
		(float)  5.650539430e-02,	(float) -3.584980099e-02,
		(float)  2.361929237e-02,	(float) -1.541913560e-02,
		(float)  9.576307556e-03,	(float) -5.310454058e-03,
		(float)  2.197689735e-03,	(float)  2.531679888e-05,
		(float) -1.543387224e-03,	(float)  2.500004657e-03,
		(float) -3.014629658e-03,	(float)  3.190538085e-03,
		(float) -3.117990449e-03,	(float)  2.875175869e-03,
		(float) -2.528256663e-03,	(float)  2.131253129e-03,
		(float) -1.726166323e-03,	(float)  1.343519493e-03,
		(float) -1.003354184e-03,	(float)  7.166214122e-04,
		(float) -4.868501749e-04,	(float)  3.119480986e-04,
		(float) -1.859865276e-04,	(float)  1.008392253e-04,
		(float) -4.757412298e-05,	(float)  1.753514245e-05,
		(float) -3.090315178e-06,	(float) -1.941709680e-06,
		(float)  2.145855268e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 64 */
		(float)  0.000000000e+00,	(float)  1.901130349e-06,
		(float) -1.384545289e-06,	(float) -4.131201176e-06,
		(float)  1.925066658e-05,	(float) -5.014406493e-05,
		(float)  1.043845673e-04,	(float) -1.905041617e-04,
		(float)  3.172291887e-04,	(float) -4.923858564e-04,
		(float)  7.215020600e-04,	(float) -1.006170881e-03,
		(float)  1.342278280e-03,	(float) -1.718227000e-03,
		(float)  2.113304509e-03,	(float) -2.496339172e-03,
		(float)  2.824760052e-03,	(float) -3.044116565e-03,
		(float)  3.088017721e-03,	(float) -2.878305736e-03,
		(float)  2.325062138e-03,	(float) -1.325704303e-03,
		(float) -2.381525072e-04,	(float)  2.508502330e-03,
		(float) -5.668210048e-03,	(float)  9.978039780e-03,
		(float) -1.585828857e-02,	(float)  2.408345148e-02,
		(float) -3.631411447e-02,	(float)  5.690706423e-02,
		(float) -1.019627104e-01,	(float)  3.169148345e-01,
		(float)  3.169148345e-01,	(float) -1.019627104e-01,
		(float)  5.690706423e-02,	(float) -3.631411447e-02,
		(float)  2.408345148e-02,	(float) -1.585828857e-02,
		(float)  9.978039780e-03,	(float) -5.668210048e-03,
		(float)  2.508502330e-03,	(float) -2.381525072e-04,
		(float) -1.325704303e-03,	(float)  2.325062138e-03,
		(float) -2.878305736e-03,	(float)  3.088017721e-03,
		(float) -3.044116565e-03,	(float)  2.824760052e-03,
		(float) -2.496339172e-03,	(float)  2.113304509e-03,
		(float) -1.718227000e-03,	(float)  1.342278280e-03,
		(float) -1.006170881e-03,	(float)  7.215020600e-04,
		(float) -4.923858564e-04,	(float)  3.172291887e-04,
		(float) -1.905041617e-04,	(float)  1.043845673e-04,
		(float) -5.014406493e-05,	(float)  1.925066658e-05,
		(float) -4.131201176e-06,	(float) -1.384545289e-06,
		(float)  1.901130349e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 65 */
		(float)  0.000000000e+00,	(float)  2.145855268e-06,
		(float) -1.941709680e-06,	(float) -3.090315178e-06,
		(float)  1.753514245e-05,	(float) -4.757412298e-05,
		(float)  1.008392253e-04,	(float) -1.859865276e-04,
		(float)  3.119480986e-04,	(float) -4.868501749e-04,
		(float)  7.166214122e-04,	(float) -1.003354184e-03,
		(float)  1.343519493e-03,	(float) -1.726166323e-03,
		(float)  2.131253129e-03,	(float) -2.528256663e-03,
		(float)  2.875175869e-03,	(float) -3.117990449e-03,
		(float)  3.190538085e-03,	(float) -3.014629658e-03,
		(float)  2.500004657e-03,	(float) -1.543387224e-03,
		(float)  2.531679888e-05,	(float)  2.197689735e-03,
		(float) -5.310454058e-03,	(float)  9.576307556e-03,
		(float) -1.541913560e-02,	(float)  2.361929237e-02,
		(float) -3.584980099e-02,	(float)  5.650539430e-02,
		(float) -1.018832998e-01,	(float)  3.212561654e-01,
		(float)  3.125379383e-01,	(float) -1.019862105e-01,
		(float)  5.727529908e-02,	(float) -3.675647219e-02,
		(float)  2.453266995e-02,	(float) -1.628727340e-02,
		(float)  1.037304319e-02,	(float) -6.021781378e-03,
		(float)  2.817020245e-03,	(float) -5.007125679e-04,
		(float) -1.107945747e-03,	(float)  2.149380026e-03,
		(float) -2.740833712e-03,	(float)  2.984140031e-03,
		(float) -2.968826458e-03,	(float)  2.772976897e-03,
		(float) -2.463174704e-03,	(float)  2.094270662e-03,
		(float) -1.709381659e-03,	(float)  1.340309704e-03,
		(float) -1.008425748e-03,	(float)  7.259655403e-04,
		(float) -4.976244220e-04,	(float)  3.223080060e-04,
		(float) -1.948908198e-04,	(float)  1.078497769e-04,
		(float) -5.266807047e-05,	(float)  2.094174007e-05,
		(float) -5.160060699e-06,	(float) -8.329512938e-07,
		(float)  1.659074753e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 66 */
		(float)  0.000000000e+00,	(float)  2.393120265e-06,
		(float) -2.504164617e-06,	(float) -2.037903207e-06,
		(float)  1.579595873e-05,	(float) -4.495937819e-05,
		(float)  9.721523548e-05,	(float) -1.813396833e-04,
		(float)  3.064665946e-04,	(float) -4.810189758e-04,
		(float)  7.113243686e-04,	(float) -9.999747778e-04,
		(float)  1.344029690e-03,	(float) -1.733191770e-03,
		(float)  2.148102695e-03,	(float) -2.558905328e-03,
		(float)  2.924192178e-03,	(float) -3.190403159e-03,
		(float)  3.291640901e-03,	(float) -3.149727608e-03,
		(float)  2.674110013e-03,	(float) -1.760875725e-03,
		(float)  2.895546644e-04,	(float)  1.884744548e-03,
		(float) -4.948694699e-03,	(float)  9.168042257e-03,
		(float) -1.497001566e-02,	(float)  2.314038189e-02,
		(float) -3.536367175e-02,	(float)  5.607027955e-02,
		(float) -1.017474195e-01,	(float)  3.255605787e-01,
		(float)  3.081268378e-01,	(float) -1.019543774e-01,
		(float)  5.761012535e-02,	(float) -3.717674633e-02,
		(float)  2.496676725e-02,	(float) -1.670589509e-02,
		(float)  1.076112631e-02,	(float) -6.370989580e-03,
		(float)  3.123083121e-03,	(float) -7.622236056e-04,
		(float) -8.902300306e-04,	(float)  1.973056006e-03,
		(float) -2.602291842e-03,	(float)  2.878965790e-03,
		(float) -2.892165707e-03,	(float)  2.719859215e-03,
		(float) -2.428785711e-03,	(float)  2.074165956e-03,
		(float) -1.699638626e-03,	(float)  1.337617798e-03,
		(float) -1.010119970e-03,	(float)  7.300113149e-04,
		(float) -5.025644452e-04,	(float)  3.271828140e-04,
		(float) -1.991448193e-04,	(float)  1.112334241e-04,
		(float) -5.514503991e-05,	(float)  2.260759209e-05,
		(float) -6.176404809e-06,	(float) -2.872011223e-07,
		(float)  1.419814176e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 67 */
		(float)  0.000000000e+00,	(float)  2.642792589e-06,
		(float) -3.071623943e-06,	(float) -9.744771290e-07,
		(float)  1.403392638e-05,	(float) -4.230099761e-05,
		(float)  9.351413586e-05,	(float) -1.765654770e-04,
		(float)  3.007866573e-04,	(float) -4.748940299e-04,
		(float)  7.056119355e-04,	(float) -9.960320900e-04,
		(float)  1.343805611e-03,	(float) -1.739295954e-03,
		(float)  2.163839933e-03,	(float) -2.588263937e-03,
		(float)  2.971777466e-03,	(float) -3.261310399e-03,
		(float)  3.391266529e-03,	(float) -3.283522151e-03,
		(float)  2.847280799e-03,	(float) -1.978050772e-03,
		(float)  5.544195685e-04,	(float)  1.569830502e-03,
		(float) -4.583115997e-03,	(float)  8.753443799e-03,
		(float) -1.451113602e-02,	(float)  2.264691793e-02,
		(float) -3.485587888e-02,	(float)  5.560172707e-02,
		(float) -1.015545291e-01,	(float)  3.298267310e-01,
		(float)  3.036829022e-01,	(float) -1.018678067e-01,
		(float)  5.791158620e-02,	(float) -3.757482126e-02,
		(float)  2.538557160e-02,	(float) -1.711396489e-02,
		(float)  1.114210200e-02,	(float) -6.715659090e-03,
		(float)  3.426532408e-03,	(float) -1.022546824e-03,
		(float) -6.726752586e-04,	(float)  1.796187815e-03,
		(float) -2.462758728e-03,	(float)  2.772556292e-03,
		(float) -2.814180490e-03,	(float)  2.665440435e-03,
		(float) -2.393195241e-03,	(float)  2.053005295e-03,
		(float) -1.689006688e-03,	(float)  1.334206979e-03,
		(float) -1.011255035e-03,	(float)  7.336390785e-04,
		(float) -5.072046719e-04,	(float)  3.318519982e-04,
		(float) -2.032645613e-04,	(float)  1.145341336e-04,
		(float) -5.757390782e-05,	(float)  2.424747232e-05,
		(float) -7.179756330e-06,	(float)  2.524383297e-07,
		(float)  1.183470714e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 68 */
		(float)  0.000000000e+00,	(float)  2.894736044e-06,
		(float) -3.643795308e-06,	(float)  9.944003668e-08,
		(float)  1.224987592e-05,	(float) -3.960018130e-05,
		(float)  8.973751786e-05,	(float) -1.716658394e-04,
		(float)  2.949103884e-04,	(float) -4.684772799e-04,
		(float)  6.994853536e-04,	(float) -9.915258571e-04,
		(float)  1.342844384e-03,	(float) -1.744471966e-03,
		(float)  2.178452135e-03,	(float) -2.616311896e-03,
		(float)  3.017900900e-03,	(float) -3.330668553e-03,
		(float)  3.489355953e-03,	(float) -3.415936325e-03,
		(float)  3.019419828e-03,	(float) -2.194793155e-03,
		(float)  8.197692304e-04,	(float)  1.253112890e-03,
		(float) -4.213904616e-03,	(float)  8.332716174e-03,
		(float) -1.404270991e-02,	(float)  2.213910697e-02,
		(float) -3.432658668e-02,	(float)  5.509976092e-02,
		(float) -1.013041069e-01,	(float)  3.340532891e-01,
		(float)  2.992075084e-01,	(float) -1.017271115e-01,
		(float)  5.817974130e-02,	(float) -3.795059352e-02,
		(float)  2.578892005e-02,	(float) -1.751130036e-02,
		(float)  1.151578759e-02,	(float) -7.055617344e-03,
		(float)  3.727211445e-03,	(float) -1.281544482e-03,
		(float) -4.553990980e-04,	(float)  1.618873199e-03,
		(float) -2.322313272e-03,	(float)  2.664973310e-03,
		(float) -2.734917561e-03,	(float)  2.609754584e-03,
		(float) -2.356426913e-03,	(float)  2.030804105e-03,
		(float) -1.677495083e-03,	(float)  1.330082040e-03,
		(float) -1.011832733e-03,	(float)  7.368487578e-04,
		(float) -5.115440200e-04,	(float)  3.363140673e-04,
		(float) -2.072485310e-04,	(float)  1.177505853e-04,
		(float) -5.995364345e-05,	(float)  2.586065124e-05,
		(float) -8.169650028e-06,	(float)  7.857068007e-07,
		(float)  9.501628237e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 69 */
		(float)  0.000000000e+00,	(float)  3.148811037e-06,
		(float) -4.220380298e-06,	(float)  1.183314339e-06,
		(float)  1.044465713e-05,	(float) -3.685816187e-05,
		(float)  8.588702552e-05,	(float) -1.666427823e-04,
		(float)  2.888400104e-04,	(float) -4.617708403e-04,
		(float)  6.929460991e-04,	(float) -9.864561259e-04,
		(float)  1.341143533e-03,	(float) -1.748713384e-03,
		(float)  2.191927160e-03,	(float) -2.643029255e-03,
		(float)  3.062532342e-03,	(float) -3.398434711e-03,
		(float)  3.585850813e-03,	(float) -3.546893688e-03,
		(float)  3.190430183e-03,	(float) -2.410983543e-03,
		(float)  1.085460684e-03,	(float)  9.347584826e-04,
		(float) -3.841249769e-03,	(float)  7.906067356e-03,
		(float) -1.356495647e-02,	(float)  2.161716397e-02,
		(float) -3.377597152e-02,	(float)  5.456442219e-02,
		(float) -1.009956509e-01,	(float)  3.382389296e-01,
		(float)  2.947020403e-01,	(float) -1.015329225e-01,
		(float)  5.841466672e-02,	(float) -3.830397184e-02,
		(float)  2.617665853e-02,	(float) -1.789772547e-02,
		(float)  1.188200492e-02,	(float) -7.390694854e-03,
		(float)  4.024965541e-03,	(float) -1.539079962e-03,
		(float) -2.385187177e-04,	(float)  1.441209854e-03,
		(float) -2.181034632e-03,	(float)  2.556279064e-03,
		(float) -2.654424218e-03,	(float)  2.552836267e-03,
		(float) -2.318504912e-03,	(float)  2.007578327e-03,
		(float) -1.665113497e-03,	(float)  1.325248147e-03,
		(float) -1.011855153e-03,	(float)  7.396405105e-04,
		(float) -5.155815791e-04,	(float)  3.405676526e-04,
		(float) -2.110952980e-04,	(float)  1.208815146e-04,
		(float) -6.228325108e-05,	(float)  2.744642037e-05,
		(float) -9.145632795e-06,	(float)  1.312350761e-06,
		(float)  7.200052770e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 70 */
		(float)  0.000000000e+00,	(float)  3.404874641e-06,
		(float) -4.801074562e-06,	(float)  2.276601121e-06,
		(float)  8.619138673e-06,	(float) -3.407620399e-05,
		(float)  8.196435492e-05,	(float) -1.614983984e-04,
		(float)  2.825778660e-04,	(float) -4.547769969e-04,
		(float)  6.859958835e-04,	(float) -9.808232548e-04,
		(float)  1.338700981e-03,	(float) -1.752014272e-03,
		(float)  2.204253450e-03,	(float) -2.668396726e-03,
		(float)  3.105642374e-03,	(float) -3.464566697e-03,
		(float)  3.680693434e-03,	(float) -3.676318360e-03,
		(float)  3.360215276e-03,	(float) -2.626502554e-03,
		(float)  1.351350355e-03,	(float)  6.149354398e-04,
		(float) -3.465343122e-03,	(float)  7.473709200e-03,
		(float) -1.307810066e-02,	(float)  2.108131233e-02,
		(float) -3.320422187e-02,	(float)  5.399576909e-02,
		(float) -1.006286782e-01,	(float)  3.423823400e-01,
		(float)  2.901678886e-01,	(float) -1.012858873e-01,
		(float)  5.861645482e-02,	(float) -3.863487710e-02,
		(float)  2.654864190e-02,	(float) -1.827307069e-02,
		(float)  1.224058041e-02,	(float) -7.720725293e-03,
		(float)  4.319642053e-03,	(float) -1.795017844e-03,
		(float) -2.215072547e-05,	(float)  1.263295373e-03,
		(float) -2.039002179e-03,	(float)  2.446536187e-03,
		(float) -2.572748279e-03,	(float)  2.494720647e-03,
		(float) -2.279453965e-03,	(float)  1.983344404e-03,
		(float) -1.651872057e-03,	(float)  1.319710832e-03,
		(float) -1.011324679e-03,	(float)  7.420147241e-04,
		(float) -5.193166104e-04,	(float)  3.446115085e-04,
		(float) -2.148035167e-04,	(float)  1.239257130e-04,
		(float) -6.456177033e-05,	(float)  2.900409256e-05,
		(float) -1.010726381e-05,	(float)  1.832123508e-06,
		(float)  4.931091270e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 71 */
		(float)  0.000000000e+00,	(float)  3.662780656e-06,
		(float) -5.385567945e-06,	(float)  3.378745259e-06,
		(float)  6.774207725e-06,	(float) -3.125560387e-05,
		(float)  7.797125354e-05,	(float) -1.562348605e-04,
		(float)  2.761264171e-04,	(float) -4.474982065e-04,
		(float)  6.786366538e-04,	(float) -9.746279149e-04,
		(float)  1.335515049e-03,	(float) -1.754369191e-03,
		(float)  2.215420035e-03,	(float) -2.692395693e-03,
		(float)  3.147202308e-03,	(float) -3.529023093e-03,
		(float)  3.773826867e-03,	(float) -3.804135069e-03,
		(float)  3.528678895e-03,	(float) -2.841230819e-03,
		(float)  1.617294134e-03,	(float)  2.938132250e-04,
		(float) -3.086378700e-03,	(float)  7.035857344e-03,
		(float) -1.258237311e-02,	(float)  2.053178377e-02,
		(float) -3.261153822e-02,	(float)  5.339387703e-02,
		(float) -1.002027262e-01,	(float)  3.464822190e-01,
		(float)  2.856064498e-01,	(float) -1.009866700e-01,
		(float)  5.878521406e-02,	(float) -3.894324238e-02,
		(float)  2.690473396e-02,	(float) -1.863717300e-02,
		(float)  1.259134521e-02,	(float) -8.045545575e-03,
		(float)  4.611090458e-03,	(float) -2.049223976e-03,
		(float)  1.935888930e-04,	(float)  1.085227196e-03,
		(float) -1.896295455e-03,	(float)  2.335807685e-03,
		(float) -2.489938050e-03,	(float)  2.435443423e-03,
		(float) -2.239299334e-03,	(float)  1.958119269e-03,
		(float) -1.637781321e-03,	(float)  1.313475996e-03,
		(float) -1.010243991e-03,	(float)  7.439720147e-04,
		(float) -5.227485460e-04,	(float)  3.484445125e-04,
		(float) -2.183719265e-04,	(float)  1.268820283e-04,
		(float) -6.678827646e-05,	(float)  3.053300221e-05,
		(float) -1.105411468e-05,	(float)  2.344785248e-06,
		(float)  2.695816725e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 72 */
		(float)  0.000000000e+00,	(float)  3.922379672e-06,
		(float) -5.973544629e-06,	(float)  4.489181408e-06,
		(float)  4.910769612e-06,	(float) -2.839768874e-05,
		(float)  7.390951959e-05,	(float) -1.508544205e-04,
		(float)  2.694882443e-04,	(float) -4.399370964e-04,
		(float)  6.708705926e-04,	(float) -9.678710910e-04,
		(float)  1.331584463e-03,	(float) -1.755773202e-03,
		(float)  2.225416543e-03,	(float) -2.715008228e-03,
		(float)  3.187184214e-03,	(float) -3.591763262e-03,
		(float)  3.865194919e-03,	(float) -3.930269189e-03,
		(float)  3.695725263e-03,	(float) -3.055049044e-03,
		(float)  1.883147457e-03,	(float) -2.843748365e-05,
		(float) -2.704552788e-03,	(float)  6.592731103e-03,
		(float) -1.207801008e-02,	(float)  1.996881826e-02,
		(float) -3.199813306e-02,	(float)  5.275883867e-02,
		(float) -9.971735215e-02,	(float)  3.505372770e-01,
		(float)  2.810191263e-01,	(float) -1.006359513e-01,
		(float)  5.892106890e-02,	(float) -3.922901284e-02,
		(float)  2.724480754e-02,	(float) -1.898987600e-02,
		(float)  1.293413518e-02,	(float) -8.364995933e-03,
		(float)  4.899162436e-03,	(float) -2.301565537e-03,
		(float)  4.085848357e-04,	(float)  9.071025543e-04,
		(float) -1.752994123e-03,	(float)  2.224156906e-03,
		(float) -2.406042304e-03,	(float)  2.375040807e-03,
		(float) -2.198066793e-03,	(float)  1.931920337e-03,
		(float) -1.622852271e-03,	(float)  1.306549893e-03,
		(float) -1.008616059e-03,	(float)  7.455132256e-04,
		(float) -5.258769886e-04,	(float)  3.520656652e-04,
		(float) -2.217993521e-04,	(float)  1.297493650e-04,
		(float) -6.896188072e-05,	(float)  3.203250551e-05,
		(float) -1.198576965e-05,	(float)  2.850103188e-06,
		(float)  4.952642645e-08,	(float)  0.000000000e+00
	},
	{ /* Polyphase 73 */
		(float)  0.000000000e+00,	(float)  4.183519138e-06,
		(float) -6.564683277e-06,	(float)  5.607334251e-06,
		(float)  3.029747407e-06,	(float) -2.550381630e-05,
		(float)  6.978100128e-05,	(float) -1.453594091e-04,
		(float)  2.626660462e-04,	(float) -4.320964637e-04,
		(float)  6.627001179e-04,	(float) -9.605540825e-04,
		(float)  1.326908353e-03,	(float) -1.756221868e-03,
		(float)  2.234233205e-03,	(float) -2.736217097e-03,
		(float)  3.225560929e-03,	(float) -3.652747377e-03,
		(float)  3.954742185e-03,	(float) -4.054646786e-03,
		(float)  3.861259090e-03,	(float) -3.267838082e-03,
		(float)  2.148765381e-03,	(float) -3.516448818e-04,
		(float) -2.320063829e-03,	(float)  6.144553361e-03,
		(float) -1.156525329e-02,	(float)  1.939266390e-02,
		(float) -3.136423078e-02,	(float)  5.209076399e-02,
		(float) -9.917213369e-02,	(float)  3.545462365e-01,
		(float)  2.764073251e-01,	(float) -1.002344278e-01,
		(float)  5.902415965e-02,	(float) -3.949214579e-02,
		(float)  2.756874448e-02,	(float) -1.933102995e-02,
		(float)  1.326879104e-02,	(float) -8.678919996e-03,
		(float)  5.183711935e-03,	(float) -2.551911113e-03,
		(float)  6.227225451e-04,	(float)  7.290184210e-04,
		(float) -1.609177931e-03,	(float)  2.111647503e-03,
		(float) -2.321110246e-03,	(float)  2.313549506e-03,
		(float) -2.155782616e-03,	(float)  1.904765493e-03,
		(float) -1.607096308e-03,	(float)  1.298939136e-03,
		(float) -1.006444143e-03,	(float)  7.466394257e-04,
		(float) -5.287017109e-04,	(float)  3.554740902e-04,
		(float) -2.250847039e-04,	(float)  1.325266843e-04,
		(float) -7.108173053e-05,	(float)  3.350198062e-05,
		(float) -1.290182567e-05,	(float)  3.347851602e-06,
		(float) -1.669569129e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 74 */
		(float)  0.000000000e+00,	(float)  4.446043433e-06,
		(float) -7.158657180e-06,	(float)  6.732618765e-06,
		(float)  1.132081522e-06,	(float) -2.257537412e-05,
		(float)  6.558759607e-05,	(float) -1.397522341e-04,
		(float)  2.556626380e-04,	(float) -4.239792746e-04,
		(float)  6.541278828e-04,	(float) -9.526785038e-04,
		(float)  1.321486258e-03,	(float) -1.755711263e-03,
		(float)  2.241860866e-03,	(float) -2.756005780e-03,
		(float)  3.262306082e-03,	(float) -3.711936443e-03,
		(float)  4.042414082e-03,	(float) -4.177194661e-03,
		(float)  4.025185626e-03,	(float) -3.479478990e-03,
		(float)  2.414002661e-03,	(float) -6.756361289e-04,
		(float) -1.933112330e-03,	(float)  5.691550467e-03,
		(float) -1.104434989e-02,	(float)  1.880357688e-02,
		(float) -3.071006769e-02,	(float)  5.138978033e-02,
		(float) -9.856666920e-02,	(float)  3.585078330e-01,
		(float)  2.717724580e-01,	(float) -9.978281167e-02,
		(float)  5.909464227e-02,	(float) -3.973261058e-02,
		(float)  2.787643572e-02,	(float) -1.966049185e-02,
		(float)  1.359515841e-02,	(float) -8.987164858e-03,
		(float)  5.464595249e-03,	(float) -2.800130759e-03,
		(float)  8.358882680e-04,	(float)  5.510714571e-04,
		(float) -1.464926662e-03,	(float)  1.998343395e-03,
		(float) -2.235191487e-03,	(float)  2.251006696e-03,
		(float) -2.112473561e-03,	(float)  1.876673078e-03,
		(float) -1.590525243e-03,	(float)  1.290650684e-03,
		(float) -1.003731786e-03,	(float)  7.473519082e-04,
		(float) -5.312226545e-04,	(float)  3.586690337e-04,
		(float) -2.282269774e-04,	(float)  1.352130047e-04,
		(float) -7.314700979e-05,	(float)  3.494082788e-05,
		(float) -1.380189256e-05,	(float)  3.837811911e-06,
		(float) -3.797724868e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 75 */
		(float)  0.000000000e+00,	(float)  4.709793936e-06,
		(float) -7.755134414e-06,	(float)  7.864440487e-06,
		(float) -7.812707116e-07,	(float) -1.961377907e-05,
		(float)  6.133124992e-05,	(float) -1.340353803e-04,
		(float)  2.484809510e-04,	(float) -4.155886634e-04,
		(float)  6.451567752e-04,	(float) -9.442462848e-04,
		(float)  1.315318126e-03,	(float) -1.754237972e-03,
		(float)  2.248290989e-03,	(float) -2.774358475e-03,
		(float)  3.297394104e-03,	(float) -3.769292321e-03,
		(float)  4.128156882e-03,	(float) -4.297840389e-03,
		(float)  4.187410713e-03,	(float) -3.689853101e-03,
		(float)  2.678713830e-03,	(float) -1.000237439e-03,
		(float) -1.543900753e-03,	(float)  5.233952121e-03,
		(float) -1.051555224e-02,	(float)  1.820182131e-02,
		(float) -3.003589186e-02,	(float)  5.065603242e-02,
		(float) -9.790057798e-02,	(float)  3.624208148e-01,
		(float)  2.671159407e-01,	(float) -9.928183026e-02,
		(float)  5.913268823e-02,	(float) -3.995038861e-02,
		(float)  2.816778123e-02,	(float) -1.997812545e-02,
		(float)  1.391308786e-02,	(float) -9.289581158e-03,
		(float)  5.741671089e-03,	(float) -3.046096068e-03,
		(float)  1.047969115e-03,	(float)  3.733579605e-04,
		(float) -1.320320095e-03,	(float)  1.884308738e-03,
		(float) -2.148336017e-03,	(float)  2.187450006e-03,
		(float) -2.068166851e-03,	(float)  1.847661880e-03,
		(float) -1.573151287e-03,	(float)  1.281691843e-03,
		(float) -1.000482815e-03,	(float)  7.476521884e-04,
		(float) -5.334399297e-04,	(float)  3.616498649e-04,
		(float) -2.312252543e-04,	(float)  1.378074020e-04,
		(float) -7.515693907e-05,	(float)  3.634847002e-05,
		(float) -1.468559314e-05,	(float)  4.319772745e-06,
		(float) -5.888282991e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 76 */
		(float)  0.000000000e+00,	(float)  4.974609106e-06,
		(float) -8.353777994e-06,	(float)  9.002195797e-06,
		(float) -2.709335474e-06,	(float) -1.662047669e-05,
		(float)  5.701395647e-05,	(float) -1.282114082e-04,
		(float)  2.411240316e-04,	(float) -4.069279317e-04,
		(float)  6.357899170e-04,	(float) -9.352596715e-04,
		(float)  1.308404314e-03,	(float) -1.751799098e-03,
		(float)  2.253515667e-03,	(float) -2.791260115e-03,
		(float)  3.330800251e-03,	(float) -3.824777752e-03,
		(float)  4.211917745e-03,	(float) -4.416512366e-03,
		(float)  4.347840841e-03,	(float) -3.898842087e-03,
		(float)  2.942753275e-03,	(float) -1.325274172e-03,
		(float) -1.152633416e-03,	(float)  4.771991262e-03,
		(float) -9.979117905e-03,	(float)  1.758766916e-02,
		(float) -2.934196314e-02,	(float)  4.988968246e-02,
		(float) -9.717350048e-02,	(float)  3.662839442e-01,
		(float)  2.624391922e-01,	(float) -9.873222590e-02,
		(float)  5.913848436e-02,	(float) -4.014547327e-02,
		(float)  2.844269012e-02,	(float) -2.028380136e-02,
		(float)  1.422243501e-02,	(float) -9.586023143e-03,
		(float)  6.014800647e-03,	(float) -3.289680233e-03,
		(float)  1.258853119e-03,	(float)  1.959738149e-04,
		(float) -1.175437957e-03,	(float)  1.769607882e-03,
		(float) -2.060594175e-03,	(float)  2.122917489e-03,
		(float) -2.022890160e-03,	(float)  1.817751122e-03,
		(float) -1.554987044e-03,	(float)  1.272070254e-03,
		(float) -9.967013345e-04,	(float)  7.475420021e-04,
		(float) -5.353538142e-04,	(float)  3.644160749e-04,
		(float) -2.340787017e-04,	(float)  1.403090095e-04,
		(float) -7.711077581e-05,	(float)  3.772435228e-05,
		(float) -1.555256334e-05,	(float)  4.793530008e-06,
		(float) -7.940362356e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 77 */
		(float)  0.000000000e+00,	(float)  5.240324560e-06,
		(float) -8.954246045e-06,	(float)  1.014527220e-05,
		(float) -4.651122908e-06,	(float) -1.359694055e-05,
		(float)  5.263775617e-05,	(float) -1.222829527e-04,
		(float)  2.335950396e-04,	(float) -3.980005475e-04,
		(float)  6.260306637e-04,	(float) -9.257212256e-04,
		(float)  1.300745595e-03,	(float) -1.748392263e-03,
		(float)  2.257527622e-03,	(float) -2.806696375e-03,
		(float)  3.362500616e-03,	(float) -3.878356382e-03,
		(float)  4.293644746e-03,	(float) -4.533139846e-03,
		(float)  4.506383200e-03,	(float) -4.106328022e-03,
		(float)  3.205975317e-03,	(float) -1.650570925e-03,
		(float) -7.595163872e-04,	(float)  4.305903954e-03,
		(float) -9.435309453e-03,	(float)  1.696140010e-02,
		(float) -2.862855300e-02,	(float)  4.909091009e-02,
		(float) -9.638509853e-02,	(float)  3.700959974e-01,
		(float)  2.577436346e-01,	(float) -9.813475536e-02,
		(float)  5.911223263e-02,	(float) -4.031786987e-02,
		(float)  2.870108059e-02,	(float) -2.057739702e-02,
		(float)  1.452306056e-02,	(float) -9.876348737e-03,
		(float)  6.283847671e-03,	(float) -3.530758113e-03,
		(float)  1.468429293e-03,	(float)  1.901443819e-05,
		(float) -1.030359885e-03,	(float)  1.654305341e-03,
		(float) -1.972016620e-03,	(float)  2.057447605e-03,
		(float) -1.976671596e-03,	(float)  1.786960447e-03,
		(float) -1.536045502e-03,	(float)  1.261793893e-03,
		(float) -9.923917254e-04,	(float)  7.470233037e-04,
		(float) -5.369647523e-04,	(float)  3.669672771e-04,
		(float) -2.367865723e-04,	(float)  1.427170181e-04,
		(float) -7.900781448e-05,	(float)  3.906794259e-05,
		(float) -1.640245229e-05,	(float)  5.258886929e-06,
		(float) -9.953120805e-07,	(float)  0.000000000e+00
	},
	{ /* Polyphase 78 */
		(float)  0.000000000e+00,	(float)  5.506773153e-06,
		(float) -9.556191960e-06,	(float)  1.129304861e-05,
		(float) -6.605627573e-06,	(float) -1.054467157e-05,
		(float)  4.820473546e-05,	(float) -1.162527225e-04,
		(float)  2.258972478e-04,	(float) -3.888101438e-04,
		(float)  6.158826035e-04,	(float) -9.156338247e-04,
		(float)  1.292343153e-03,	(float) -1.744015613e-03,
		(float)  2.260320218e-03,	(float) -2.820653684e-03,
		(float)  3.392472148e-03,	(float) -3.929992780e-03,
		(float)  4.373286913e-03,	(float) -4.647652982e-03,
		(float)  4.662945732e-03,	(float) -4.312193453e-03,
		(float)  3.468234291e-03,	(float) -1.975951628e-03,
		(float) -3.647573768e-04,	(float)  3.835929268e-03,
		(float) -8.884394373e-03,	(float)  1.632330145e-02,
		(float) -2.789594452e-02,	(float)  4.825991244e-02,
		(float) -9.553505564e-02,	(float)  3.738557652e-01,
		(float)  2.530306922e-01,	(float) -9.749018956e-02,
		(float)  5.905414998e-02,	(float) -4.046759561e-02,
		(float)  2.894287998e-02,	(float) -2.085879683e-02,
		(float)  1.481483038e-02,	(float) -1.016041961e-02,
		(float)  6.548678523e-03,	(float) -3.769206299e-03,
		(float)  1.676587690e-03,	(float) -1.574252674e-04,
		(float) -8.851653765e-04,	(float)  1.538465755e-03,
		(float) -1.882654305e-03,	(float)  1.991079197e-03,
		(float) -1.929539683e-03,	(float)  1.755309910e-03,
		(float) -1.516340029e-03,	(float)  1.250871062e-03,
		(float) -9.875586400e-04,	(float)  7.460982640e-04,
		(float) -5.382733539e-04,	(float)  3.693032062e-04,
		(float) -2.393482046e-04,	(float)  1.450306767e-04,
		(float) -8.084738676e-05,	(float)  4.037873169e-05,
		(float) -1.723492243e-05,	(float)  5.715654117e-06,
		(float) -1.192575530e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 79 */
		(float)  0.000000000e+00,	(float)  5.773785067e-06,
		(float) -1.015926458e-05,	(float)  1.244489567e-05,
		(float) -8.571828924e-06,	(float) -7.465197400e-06,
		(float)  4.371702580e-05,	(float) -1.101234988e-04,
		(float)  2.180340402e-04,	(float) -3.793605176e-04,
		(float)  6.053495563e-04,	(float) -9.050006623e-04,
		(float)  1.283198588e-03,	(float) -1.738667822e-03,
		(float)  2.261887466e-03,	(float) -2.833119235e-03,
		(float)  3.420692663e-03,	(float) -3.979652466e-03,
		(float)  4.450794251e-03,	(float) -4.759982873e-03,
		(float)  4.817437181e-03,	(float) -4.516321461e-03,
		(float)  3.729384625e-03,	(float) -2.301239634e-03,
		(float)  3.143436718e-05,	(float)  3.362309164e-03,
		(float) -8.326644942e-03,	(float)  1.567366800e-02,
		(float) -2.714443222e-02,	(float)  4.739690413e-02,
		(float) -9.462307715e-02,	(float)  3.775620537e-01,
		(float)  2.483017911e-01,	(float) -9.679931309e-02,
		(float)  5.896446814e-02,	(float) -4.059467949e-02,
		(float)  2.916802474e-02,	(float) -2.112789208e-02,
		(float)  1.509761552e-02,	(float) -1.043810123e-02,
		(float)  6.809162253e-03,	(float) -4.004903168e-03,
		(float)  1.883219456e-03,	(float) -3.332509657e-04,
		(float) -7.399337537e-04,	(float)  1.422153851e-03,
		(float) -1.792558445e-03,	(float)  1.923851465e-03,
		(float) -1.881523344e-03,	(float)  1.722819959e-03,
		(float) -1.495884355e-03,	(float)  1.239310387e-03,
		(float) -9.822069986e-04,	(float)  7.447692679e-04,
		(float) -5.392803929e-04,	(float)  3.714237180e-04,
		(float) -2.417630226e-04,	(float)  1.472492915e-04,
		(float) -8.262886166e-05,	(float)  4.165623326e-05,
		(float) -1.804964960e-05,	(float)  6.163649605e-06,
		(float) -1.385750205e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 80 */
		(float)  0.000000000e+00,	(float)  6.041187891e-06,
		(float) -1.076310838e-05,	(float)  1.360017606e-05,
		(float) -1.054869179e-05,	(float) -4.360071645e-06,
		(float)  3.917680280e-05,	(float) -1.038981340e-04,
		(float)  2.100089107e-04,	(float) -3.696556283e-04,
		(float)  5.944355729e-04,	(float) -8.938252469e-04,
		(float)  1.273313916e-03,	(float) -1.732348089e-03,
		(float)  2.262224025e-03,	(float) -2.844080995e-03,
		(float)  3.447140866e-03,	(float) -4.027301931e-03,
		(float)  4.526117779e-03,	(float) -4.870061598e-03,
		(float)  4.969767153e-03,	(float) -4.718595726e-03,
		(float)  3.989280916e-03,	(float) -2.626257815e-03,
		(float)  4.288481687e-04,	(float)  2.885288371e-03,
		(float) -7.762338089e-03,	(float)  1.501280189e-02,
		(float) -2.637432205e-02,	(float)  4.650211728e-02,
		(float) -9.364889048e-02,	(float)  3.812136842e-01,
		(float)  2.435583589e-01,	(float) -9.606292390e-02,
		(float)  5.884343343e-02,	(float) -4.069916228e-02,
		(float)  2.937646043e-02,	(float) -2.138458111e-02,
		(float)  1.537129232e-02,	(float) -1.070926295e-02,
		(float)  7.065170652e-03,	(float) -4.237728952e-03,
		(float)  2.088216888e-03,	(float) -5.083689365e-04,
		(float) -5.947441153e-04,	(float)  1.305434416e-03,
		(float) -1.701780489e-03,	(float)  1.855803952e-03,
		(float) -1.832651883e-03,	(float)  1.689511432e-03,
		(float) -1.474692571e-03,	(float)  1.227120805e-03,
		(float) -9.763419855e-04,	(float)  7.430389125e-04,
		(float) -5.399868068e-04,	(float)  3.733287888e-04,
		(float) -2.440305354e-04,	(float)  1.493722271e-04,
		(float) -8.435164561e-05,	(float)  4.289998406e-05,
		(float) -1.884632310e-05,	(float)  6.602698888e-06,
		(float) -1.574763653e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 81 */
		(float)  0.000000000e+00,	(float)  6.308806722e-06,
		(float) -1.136736362e-05,	(float)  1.475824479e-05,
		(float) -1.253516687e-05,	(float) -1.230873204e-06,
		(float)  3.458628518e-05,	(float) -9.757955070e-05,
		(float)  2.018254621e-04,	(float) -3.596995967e-04,
		(float)  5.831449333e-04,	(float) -8.821114015e-04,
		(float)  1.262691568e-03,	(float) -1.725056150e-03,
		(float)  2.261325213e-03,	(float) -2.853527714e-03,
		(float)  3.471796359e-03,	(float) -4.072908655e-03,
		(float)  4.599209554e-03,	(float) -4.977822258e-03,
		(float)  5.119846158e-03,	(float) -4.918900596e-03,
		(float)  4.247778015e-03,	(float) -2.950828656e-03,
		(float)  8.272720334e-04,	(float)  2.405114260e-03,
		(float) -7.191755273e-03,	(float)  1.434101253e-02,
		(float) -2.558593122e-02,	(float)  4.557580150e-02,
		(float) -9.261224535e-02,	(float)  3.848094944e-01,
		(float)  2.388018238e-01,	(float) -9.528183288e-02,
		(float)  5.869130654e-02,	(float) -4.078109641e-02,
		(float)  2.956814174e-02,	(float) -2.162876922e-02,
		(float)  1.563574242e-02,	(float) -1.097377804e-02,
		(float)  7.316578321e-03,	(float) -4.467565791e-03,
		(float)  2.291473490e-03,	(float) -6.826861240e-04,
		(float) -4.496752965e-04,	(float)  1.188372251e-03,
		(float) -1.610372093e-03,	(float)  1.786976510e-03,
		(float) -1.782954973e-03,	(float)  1.655405534e-03,
		(float) -1.452779118e-03,	(float)  1.214311565e-03,
		(float) -9.699690455e-04,	(float)  7.409100041e-04,
		(float) -5.403936945e-04,	(float)  3.750185148e-04,
		(float) -2.461503376e-04,	(float)  1.513989055e-04,
		(float) -8.601518254e-05,	(float)  4.410954395e-05,
		(float) -1.962464579e-05,	(float)  7.032634963e-06,
		(float) -1.759547362e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 82 */
		(float)  0.000000000e+00,	(float)  6.576464248e-06,
		(float) -1.197166656e-05,	(float)  1.591844953e-05,
		(float) -1.453019125e-05,	(float)  1.920794499e-06,
		(float)  2.994773384e-05,	(float) -9.117074036e-05,
		(float)  1.934874044e-04,	(float) -3.494967031e-04,
		(float)  5.714821458e-04,	(float) -8.698632632e-04,
		(float)  1.251334391e-03,	(float) -1.716792271e-03,
		(float)  2.259187008e-03,	(float) -2.861448933e-03,
		(float)  3.494639659e-03,	(float) -4.116441133e-03,
		(float)  4.670022704e-03,	(float) -5.083199017e-03,
		(float)  5.267585669e-03,	(float) -5.117121148e-03,
		(float)  4.504731102e-03,	(float) -3.274774350e-03,
		(float)  1.226492759e-03,	(float)  1.922036727e-03,
		(float) -6.615182341e-03,	(float)  1.365861641e-02,
		(float) -2.477958812e-02,	(float)  4.461822386e-02,
		(float) -9.151291393e-02,	(float)  3.883483379e-01,
		(float)  2.340336143e-01,	(float) -9.445686345e-02,
		(float)  5.850836236e-02,	(float) -4.084054588e-02,
		(float)  2.974303248e-02,	(float) -2.186036878e-02,
		(float)  1.589085279e-02,	(float) -1.123152374e-02,
		(float)  7.563262726e-03,	(float) -4.694297798e-03,
		(float)  2.492884025e-03,	(float) -8.561101865e-04,
		(float) -3.048058264e-04,	(float)  1.071032144e-03,
		(float) -1.518385087e-03,	(float)  1.717409286e-03,
		(float) -1.732462628e-03,	(float)  1.620523832e-03,
		(float) -1.430158776e-03,	(float)  1.200892218e-03,
		(float) -9.630938791e-04,	(float)  7.383855562e-04,
		(float) -5.405023155e-04,	(float)  3.764931113e-04,
		(float) -2.481221083e-04,	(float)  1.533288069e-04,
		(float) -8.761895399e-05,	(float)  4.528449606e-05,
		(float) -2.038433411e-05,	(float)  7.453298356e-06,
		(float) -1.940036756e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 83 */
		(float)  0.000000000e+00,	(float)  6.843980848e-06,
		(float) -1.257564965e-05,	(float)  1.708013097e-05,
		(float) -1.653268891e-05,	(float)  5.093304261e-06,
		(float)  2.526345078e-05,	(float) -8.467476194e-05,
		(float)  1.849985530e-04,	(float) -3.390513858e-04,
		(float)  5.594519453e-04,	(float) -8.570852818e-04,
		(float)  1.239245651e-03,	(float) -1.707557256e-03,
		(float)  2.255806055e-03,	(float) -2.867834995e-03,
		(float)  3.515652209e-03,	(float) -4.157868894e-03,
		(float)  4.738511458e-03,	(float) -5.186127141e-03,
		(float)  5.412898171e-03,	(float) -5.313143255e-03,
		(float)  4.759995769e-03,	(float) -3.597916895e-03,
		(float)  1.626296045e-03,	(float)  1.436308058e-03,
		(float) -6.032909396e-03,	(float)  1.296593699e-02,
		(float) -2.395563219e-02,	(float)  4.362966889e-02,
		(float) -9.035069110e-02,	(float)  3.918290856e-01,
		(float)  2.292551585e-01,	(float) -9.358885115e-02,
		(float)  5.829488970e-02,	(float) -4.087758622e-02,
		(float)  2.990110550e-02,	(float) -2.207929922e-02,
		(float)  1.613651584e-02,	(float) -1.148238134e-02,
		(float)  7.805104257e-03,	(float) -4.917811109e-03,
		(float)  2.692344570e-03,	(float) -1.028549543e-03,
		(float) -1.602138860e-04,	(float)  9.534788307e-04,
		(float) -1.425871452e-03,	(float)  1.647142697e-03,
		(float) -1.681205198e-03,	(float)  1.584888235e-03,
		(float) -1.406846654e-03,	(float)  1.186872610e-03,
		(float) -9.557224387e-04,	(float)  7.354687867e-04,
		(float) -5.403140880e-04,	(float)  3.777529120e-04,
		(float) -2.499456115e-04,	(float)  1.551614689e-04,
		(float) -8.916247908e-05,	(float)  4.642444676e-05,
		(float) -2.112511816e-05,	(float)  7.864537144e-06,
		(float) -2.116171194e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 84 */
		(float)  0.000000000e+00,	(float)  7.111174691e-06,
		(float) -1.317894172e-05,	(float)  1.824262313e-05,
		(float) -1.854157128e-05,	(float)  8.285005886e-06,
		(float)  2.053577807e-05,	(float) -7.809474065e-05,
		(float)  1.763628278e-04,	(float) -3.283682395e-04,
		(float)  5.470592917e-04,	(float) -8.437822188e-04,
		(float)  1.226429028e-03,	(float) -1.697352446e-03,
		(float)  2.251179669e-03,	(float) -2.872677049e-03,
		(float)  3.534816396e-03,	(float) -4.197162519e-03,
		(float)  4.804631170e-03,	(float) -5.286543034e-03,
		(float)  5.555697210e-03,	(float) -5.506853651e-03,
		(float)  5.013428098e-03,	(float) -3.920078188e-03,
		(float)  2.026466610e-03,	(float)  9.481828085e-04,
		(float) -5.445230656e-03,	(float)  1.226330454e-02,
		(float) -2.311441382e-02,	(float)  4.261043853e-02,
		(float) -8.912539454e-02,	(float)  3.952506255e-01,
		(float)  2.244678838e-01,	(float) -9.267864328e-02,
		(float)  5.805119114e-02,	(float) -4.089230438e-02,
		(float)  3.004234276e-02,	(float) -2.228548703e-02,
		(float)  1.637262940e-02,	(float) -1.172623622e-02,
		(float)  8.041986287e-03,	(float) -5.137993942e-03,
		(float)  2.889752568e-03,	(float) -1.199913424e-03,
		(float) -1.597726687e-05,	(float)  8.357769599e-04,
		(float) -1.332883286e-03,	(float)  1.576217403e-03,
		(float) -1.629213340e-03,	(float)  1.548520987e-03,
		(float) -1.382858183e-03,	(float)  1.172262877e-03,
		(float) -9.478609241e-04,	(float)  7.321631151e-04,
		(float) -5.398305878e-04,	(float)  3.787983683e-04,
		(float) -2.516206950e-04,	(float)  1.568964869e-04,
		(float) -9.064531460e-05,	(float)  4.752902581e-05,
		(float) -2.184674175e-05,	(float)  8.266206981e-06,
		(float) -2.287893971e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 85 */
		(float)  0.000000000e+00,	(float)  7.377861835e-06,
		(float) -1.378116814e-05,	(float)  1.940525369e-05,
		(float) -2.055573774e-05,	(float)  1.149422697e-05,
		(float)  1.576709675e-05,	(float) -7.143386650e-05,
		(float)  1.675842507e-04,	(float) -3.174520131e-04,
		(float)  5.343093684e-04,	(float) -8.299591464e-04,
		(float)  1.212888620e-03,	(float) -1.686179718e-03,
		(float)  2.245305841e-03,	(float) -2.875967062e-03,
		(float)  3.552115559e-03,	(float) -4.234293664e-03,
		(float)  4.868338350e-03,	(float) -5.384384279e-03,
		(float)  5.695897443e-03,	(float) -5.698139992e-03,
		(float)  5.264884740e-03,	(float) -4.241080122e-03,
		(float)  2.426788299e-03,	(float)  4.579176697e-04,
		(float) -4.852444309e-03,	(float)  1.155105602e-02,
		(float) -2.225629421e-02,	(float)  4.156085211e-02,
		(float) -8.783686500e-02,	(float)  3.986118635e-01,
		(float)  2.196732162e-01,	(float) -9.172709841e-02,
		(float)  5.777758276e-02,	(float) -4.088479860e-02,
		(float)  3.016673524e-02,	(float) -2.247886582e-02,
		(float)  1.659909677e-02,	(float) -1.196297789e-02,
		(float)  8.273795221e-03,	(float) -5.354736655e-03,
		(float)  3.085006880e-03,	(float) -1.370111913e-03,
		(float)  1.278266704e-04,	(float)  7.179910586e-04,
		(float) -1.239472778e-03,	(float)  1.504674289e-03,
		(float) -1.576518007e-03,	(float)  1.511444650e-03,
		(float) -1.358209106e-03,	(float)  1.157073440e-03,
		(float) -9.395157780e-04,	(float)  7.284721596e-04,
		(float) -5.390535462e-04,	(float)  3.796300484e-04,
		(float) -2.531472907e-04,	(float)  1.585335139e-04,
		(float) -9.206705492e-05,	(float)  4.859788630e-05,
		(float) -2.254896240e-05,	(float)  8.658171107e-06,
		(float) -2.455152310e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 86 */
		(float)  0.000000000e+00,	(float)  7.643856331e-06,
		(float) -1.438195111e-05,	(float)  2.056734438e-05,
		(float) -2.257407624e-05,	(float)  1.471927373e-05,
		(float)  1.095982572e-05,	(float) -6.469539288e-05,
		(float)  1.586669447e-04,	(float) -3.063076086e-04,
		(float)  5.212075801e-04,	(float) -8.156214454e-04,
		(float)  1.198628939e-03,	(float) -1.674041493e-03,
		(float)  2.238183237e-03,	(float) -2.877697824e-03,
		(float)  3.567534001e-03,	(float) -4.269235075e-03,
		(float)  4.929590693e-03,	(float) -5.479589677e-03,
		(float)  5.833414694e-03,	(float) -5.886890923e-03,
		(float)  5.514222998e-03,	(float) -4.560744684e-03,
		(float)  2.827044202e-03,	(float) -3.422866145e-05,
		(float) -4.254852372e-03,	(float)  1.082953490e-02,
		(float) -2.138164522e-02,	(float)  4.048124629e-02,
		(float) -8.648496638e-02,	(float)  4.019117233e-01,
		(float)  2.148725799e-01,	(float) -9.073508605e-02,
		(float)  5.747439394e-02,	(float) -4.085517836e-02,
		(float)  3.027428293e-02,	(float) -2.265937630e-02,
		(float)  1.681582677e-02,	(float) -1.219250005e-02,
		(float)  8.500420550e-03,	(float) -5.567931792e-03,
		(float)  3.278007836e-03,	(float) -1.539055998e-03,
		(float)  2.711210365e-04,	(float)  6.001854973e-04,
		(float) -1.145692177e-03,	(float)  1.432554438e-03,
		(float) -1.523150427e-03,	(float)  1.473682090e-03,
		(float) -1.332915467e-03,	(float)  1.141314992e-03,
		(float) -9.306936815e-04,	(float)  7.243997346e-04,
		(float) -5.379848486e-04,	(float)  3.802486362e-04,
		(float) -2.545254139e-04,	(float)  1.600722601e-04,
		(float) -9.342733206e-05,	(float)  4.963070476e-05,
		(float) -2.323155141e-05,	(float)  9.040300361e-06,
		(float) -2.617897350e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 87 */
		(float)  0.000000000e+00,	(float)  7.908970330e-06,
		(float) -1.498090978e-05,	(float)  2.172821132e-05,
		(float) -2.459546379e-05,	(float)  1.795843180e-05,
		(float)  6.116420574e-06,	(float) -5.788263507e-05,
		(float)  1.496151315e-04,	(float) -2.949400782e-04,
		(float)  5.077595509e-04,	(float) -8.007748041e-04,
		(float)  1.183654912e-03,	(float) -1.660940730e-03,
		(float)  2.229811206e-03,	(float) -2.877862955e-03,
		(float)  3.581057007e-03,	(float) -4.301960609e-03,
		(float)  4.988347102e-03,	(float) -5.572099279e-03,
		(float)  5.968165995e-03,	(float) -6.072996140e-03,
		(float)  5.761300902e-03,	(float) -4.878894049e-03,
		(float)  3.227016767e-03,	(float) -5.279956147e-04,
		(float) -3.652760537e-03,	(float)  1.009909102e-02,
		(float) -2.049084928e-02,	(float)  3.937197501e-02,
		(float) -8.506958595e-02,	(float)  4.051491477e-01,
		(float)  2.100673964e-01,	(float) -8.970348619e-02,
		(float)  5.714196709e-02,	(float) -4.080356423e-02,
		(float)  3.036499480e-02,	(float) -2.282696629e-02,
		(float)  1.702273378e-02,	(float) -1.241470062e-02,
		(float)  8.721754907e-03,	(float) -5.777474141e-03,
		(float)  3.468657285e-03,	(float) -1.706657616e-03,
		(float)  4.138294545e-04,	(float)  4.824244555e-04,
		(float) -1.051593765e-03,	(float)  1.359899112e-03,
		(float) -1.469142087e-03,	(float)  1.435256466e-03,
		(float) -1.306993600e-03,	(float)  1.124998497e-03,
		(float) -9.214015490e-04,	(float)  7.199498473e-04,
		(float) -5.366265323e-04,	(float)  3.806549304e-04,
		(float) -2.557551627e-04,	(float)  1.615124931e-04,
		(float) -9.472581556e-05,	(float)  5.062718110e-05,
		(float) -2.389429382e-05,	(float)  9.412473183e-06,
		(float) -2.776084138e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 88 */
		(float)  0.000000000e+00,	(float)  8.173014188e-06,
		(float) -1.557766050e-05,	(float)  2.288716536e-05,
		(float) -2.661876709e-05,	(float)  2.120996715e-05,
		(float)  1.239372466e-06,	(float) -5.099896875e-05,
		(float)  1.404331299e-04,	(float) -2.833546226e-04,
		(float)  4.939711224e-04,	(float) -7.854252162e-04,
		(float)  1.167971881e-03,	(float) -1.646880929e-03,
		(float)  2.220189781e-03,	(float) -2.876456911e-03,
		(float)  3.592670848e-03,	(float) -4.332445252e-03,
		(float)  5.044567716e-03,	(float) -5.661854427e-03,
		(float)  6.100069639e-03,	(float) -6.256346456e-03,
		(float)  6.005977291e-03,	(float) -5.195350679e-03,
		(float)  3.626487916e-03,	(float) -1.023120881e-03,
		(float) -3.046478029e-03,	(float)  9.360080443e-03,
		(float) -1.958429918e-02,	(float)  3.823340941e-02,
		(float) -8.359063442e-02,	(float)  4.083230979e-01,
		(float)  2.052590846e-01,	(float) -8.863318886e-02,
		(float)  5.678065742e-02,	(float) -4.073008778e-02,
		(float)  3.043888875e-02,	(float) -2.298159073e-02,
		(float)  1.721973772e-02,	(float) -1.262948181e-02,
		(float)  8.937694107e-03,	(float) -5.983260781e-03,
		(float)  3.656858642e-03,	(float) -1.872829696e-03,
		(float)  5.558760994e-04,	(float)  3.647718868e-04,
		(float) -9.572298278e-04,	(float)  1.286749724e-03,
		(float) -1.414524713e-03,	(float)  1.396191214e-03,
		(float) -1.280460121e-03,	(float)  1.108135181e-03,
		(float) -9.116465240e-04,	(float)  7.151266946e-04,
		(float) -5.349807851e-04,	(float)  3.808498435e-04,
		(float) -2.568367176e-04,	(float)  1.628540371e-04,
		(float) -9.596221246e-05,	(float)  5.158703864e-05,
		(float) -2.453698848e-05,	(float)  9.774575616e-06,
		(float) -2.929671612e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 89 */
		(float)  0.000000000e+00,	(float)  8.435796579e-06,
		(float) -1.617181705e-05,	(float)  2.404351251e-05,
		(float) -2.864284310e-05,	(float)  2.447212686e-05,
		(float) -3.668793129e-06,	(float) -4.404782837e-05,
		(float)  1.311253537e-04,	(float) -2.715565890e-04,
		(float)  4.798483511e-04,	(float) -7.695789786e-04,
		(float)  1.151585597e-03,	(float) -1.631866132e-03,
		(float)  2.209319679e-03,	(float) -2.873474991e-03,
		(float)  3.602362796e-03,	(float) -4.360665134e-03,
		(float)  5.098213936e-03,	(float) -5.748797789e-03,
		(float)  6.229045231e-03,	(float) -6.436833859e-03,
		(float)  6.248111893e-03,	(float) -5.509937421e-03,
		(float)  4.025239161e-03,	(float) -1.519340548e-03,
		(float) -2.436317448e-03,	(float)  8.612865257e-03,
		(float) -1.866239796e-02,	(float)  3.706593780e-02,
		(float) -8.204804617e-02,	(float)  4.114325550e-01,
		(float)  2.004490598e-01,	(float) -8.752509376e-02,
		(float)  5.639083273e-02,	(float) -4.063489147e-02,
		(float)  3.049599159e-02,	(float) -2.312321167e-02,
		(float)  1.740676413e-02,	(float) -1.283675013e-02,
		(float)  9.148137200e-03,	(float) -6.185191133e-03,
		(float)  3.842516938e-03,	(float) -2.037486205e-03,
		(float)  6.971857380e-04,	(float)  2.472914853e-04,
		(float) -8.626526276e-04,	(float)  1.213147819e-03,
		(float) -1.359330252e-03,	(float)  1.356510034e-03,
		(float) -1.253331917e-03,	(float)  1.090736524e-03,
		(float) -9.014359735e-04,	(float)  7.099346601e-04,
		(float) -5.330499430e-04,	(float)  3.808344008e-04,
		(float) -2.577703407e-04,	(float)  1.640967733e-04,
		(float) -9.713626720e-05,	(float)  5.251002409e-05,
		(float) -2.515944801e-05,	(float)  1.012650130e-05,
		(float) -3.078622587e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 90 */
		(float)  0.000000000e+00,	(float)  8.697124611e-06,
		(float) -1.676299080e-05,	(float)  2.519655423e-05,
		(float) -3.066653964e-05,	(float)  2.774314008e-05,
		(float) -8.605517623e-06,	(float) -3.703270560e-05,
		(float)  1.216963102e-04,	(float) -2.595514685e-04,
		(float)  4.653975061e-04,	(float) -7.532426897e-04,
		(float)  1.134502225e-03,	(float) -1.615900920e-03,
		(float)  2.197202309e-03,	(float) -2.868913342e-03,
		(float)  3.610121134e-03,	(float) -4.386597550e-03,
		(float)  5.149248449e-03,	(float) -5.832873392e-03,
		(float)  6.355013730e-03,	(float) -6.614351578e-03,
		(float)  6.487565400e-03,	(float) -5.822477602e-03,
		(float)  4.423051721e-03,	(float) -2.016389236e-03,
		(float) -1.822594614e-03,	(float)  7.857813444e-03,
		(float) -1.772555875e-02,	(float)  3.586996551e-02,
		(float) -8.044177927e-02,	(float)  4.144765194e-01,
		(float)  1.956387334e-01,	(float) -8.638010980e-02,
		(float)  5.597287311e-02,	(float) -4.051812850e-02,
		(float)  3.053633895e-02,	(float) -2.325179828e-02,
		(float)  1.758374416e-02,	(float) -1.303641642e-02,
		(float)  9.352986516e-03,	(float) -6.383167006e-03,
		(float)  4.025538867e-03,	(float) -2.200542192e-03,
		(float)  8.376837684e-04,	(float)  1.300466511e-04,
		(float) -7.679143719e-04,	(float)  1.139135047e-03,
		(float) -1.303590854e-03,	(float)  1.316236876e-03,
		(float) -1.225626136e-03,	(float)  1.072814253e-03,
		(float) -8.907774834e-04,	(float)  7.043783109e-04,
		(float) -5.308364885e-04,	(float)  3.806097387e-04,
		(float) -2.585563756e-04,	(float)  1.652406391e-04,
		(float) -9.824776148e-05,	(float)  5.339590749e-05,
		(float) -2.576149880e-05,	(float)  1.046815145e-05,
		(float) -3.222903731e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 91 */
		(float)  0.000000000e+00,	(float)  8.956803933e-06,
		(float) -1.735079101e-05,	(float)  2.634558789e-05,
		(float) -3.268869599e-05,	(float)  3.102121888e-05,
		(float) -1.356821058e-05,	(float) -2.995714765e-05,
		(float)  1.121505975e-04,	(float) -2.473448940e-04,
		(float)  4.506250667e-04,	(float) -7.364232465e-04,
		(float)  1.116728339e-03,	(float) -1.598990415e-03,
		(float)  2.183839768e-03,	(float) -2.862768964e-03,
		(float)  3.615935164e-03,	(float) -4.410220972e-03,
		(float)  5.197635256e-03,	(float) -5.914026662e-03,
		(float)  6.477897499e-03,	(float) -6.788794142e-03,
		(float)  6.724199552e-03,	(float) -6.132795126e-03,
		(float)  4.819706641e-03,	(float) -2.514000237e-03,
		(float) -1.205628412e-03,	(float)  7.095298695e-03,
		(float) -1.677420460e-02,	(float)  3.464591489e-02,
		(float) -7.877181569e-02,	(float)  4.174540122e-01,
		(float)  1.908295122e-01,	(float) -8.519915469e-02,
		(float)  5.552717069e-02,	(float) -4.037996271e-02,
		(float)  3.055997526e-02,	(float) -2.336732683e-02,
		(float)  1.775061460e-02,	(float) -1.322839593e-02,
		(float)  9.552147705e-03,	(float) -6.577092644e-03,
		(float)  4.205832829e-03,	(float) -2.361913831e-03,
		(float)  9.772962579e-04,	(float)  1.310045695e-05,
		(float) -6.730671870e-04,	(float)  1.064753145e-03,
		(float) -1.247338855e-03,	(float)  1.275395925e-03,
		(float) -1.197360176e-03,	(float)  1.054380333e-03,
		(float) -8.796788534e-04,	(float)  6.984623936e-04,
		(float) -5.283430481e-04,	(float)  3.801771043e-04,
		(float) -2.591952462e-04,	(float)  1.662856281e-04,
		(float) -9.929651417e-05,	(float)  5.424448222e-05,
		(float) -2.634298099e-05,	(float)  1.079943488e-05,
		(float) -3.362485548e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 92 */
		(float)  0.000000000e+00,	(float)  9.214638862e-06,
		(float) -1.793482500e-05,	(float)  2.748990714e-05,
		(float) -3.470814349e-05,	(float)  3.430455921e-05,
		(float) -1.855425097e-05,	(float) -2.282475558e-05,
		(float)  1.024929028e-04,	(float) -2.349426373e-04,
		(float)  4.355377196e-04,	(float) -7.191278423e-04,
		(float)  1.098270917e-03,	(float) -1.581140281e-03,
		(float)  2.169234844e-03,	(float) -2.855039715e-03,
		(float)  3.619795217e-03,	(float) -4.431515065e-03,
		(float)  5.243339689e-03,	(float) -5.992204450e-03,
		(float)  6.597620353e-03,	(float) -6.960057447e-03,
		(float)  6.957877211e-03,	(float) -6.440714575e-03,
		(float)  5.214984906e-03,	(float) -3.011905653e-03,
		(float) -5.857406325e-04,	(float)  6.325700235e-03,
		(float) -1.580876831e-02,	(float)  3.339422514e-02,
		(float) -7.703816134e-02,	(float)  4.203640745e-01,
		(float)  1.860227980e-01,	(float) -8.398315448e-02,
		(float)  5.505412942e-02,	(float) -4.022056843e-02,
		(float)  3.056695369e-02,	(float) -2.346978069e-02,
		(float)  1.790731790e-02,	(float) -1.341260833e-02,
		(float)  9.745529780e-03,	(float) -6.766874773e-03,
		(float)  4.383308979e-03,	(float) -2.521518463e-03,
		(float)  1.115949982e-03,	(float) -1.034843852e-04,
		(float) -5.781630895e-04,	(float)  9.900439076e-04,
		(float) -1.190606756e-03,	(float)  1.234011588e-03,
		(float) -1.168551673e-03,	(float)  1.035446964e-03,
		(float) -8.681480914e-04,	(float)  6.921918318e-04,
		(float) -5.255723902e-04,	(float)  3.795378535e-04,
		(float) -2.596874562e-04,	(float)  1.672317895e-04,
		(float) -1.002823811e-04,	(float)  5.505556488e-05,
		(float) -2.690374848e-05,	(float)  1.112026792e-05,
		(float) -3.497342348e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 93 */
		(float)  0.000000000e+00,	(float)  9.470432495e-06,
		(float) -1.851469839e-05,	(float)  2.862880225e-05,
		(float) -3.672370620e-05,	(float)  3.759134177e-05,
		(float) -2.356098852e-05,	(float) -1.563918259e-05,
		(float)  9.272800015e-05,	(float) -2.223506073e-04,
		(float)  4.201423563e-04,	(float) -7.013639639e-04,
		(float)  1.079137345e-03,	(float) -1.562356716e-03,
		(float)  2.153391020e-03,	(float) -2.845724315e-03,
		(float)  3.621692665e-03,	(float) -4.450460705e-03,
		(float)  5.286328441e-03,	(float) -6.067355074e-03,
		(float)  6.714107603e-03,	(float) -7.128038808e-03,
		(float)  7.188462439e-03,	(float) -6.746061302e-03,
		(float)  5.608667564e-03,	(float) -3.509836536e-03,
		(float)  3.674419112e-05,	(float)  5.549402650e-03,
		(float) -1.482969225e-02,	(float)  3.211535222e-02,
		(float) -7.524084621e-02,	(float)  4.232057686e-01,
		(float)  1.812199872e-01,	(float) -8.273304318e-02,
		(float)  5.455416476e-02,	(float) -4.004013033e-02,
		(float)  3.055733608e-02,	(float) -2.355915030e-02,
		(float)  1.805380216e-02,	(float) -1.358897770e-02,
		(float)  9.933045155e-03,	(float) -6.952422641e-03,
		(float)  4.557879268e-03,	(float) -2.679274637e-03,
		(float)  1.253572462e-03,	(float) -2.196455575e-04,
		(float) -4.832539579e-04,	(float)  9.150491691e-04,
		(float) -1.133427208e-03,	(float)  1.192108481e-03,
		(float) -1.139218496e-03,	(float)  1.016026569e-03,
		(float) -8.561934084e-04,	(float)  6.855717216e-04,
		(float) -5.225274232e-04,	(float)  3.786934496e-04,
		(float) -2.600335885e-04,	(float)  1.680792279e-04,
		(float) -1.012052551e-04,	(float)  5.582899523e-05,
		(float) -2.744366882e-05,	(float)  1.143057446e-05,
		(float) -3.627452223e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 94 */
		(float)  0.000000000e+00,	(float)  9.723986835e-06,
		(float) -1.909001534e-05,	(float)  2.976156058e-05,
		(float) -3.873420151e-05,	(float)  4.087973300e-05,
		(float) -2.858574500e-05,	(float) -8.404132219e-06,
		(float)  8.286074826e-05,	(float) -2.095748464e-04,
		(float)  4.044460700e-04,	(float) -6.831393890e-04,
		(float)  1.059335410e-03,	(float) -1.542646460e-03,
		(float)  2.136312469e-03,	(float) -2.834822347e-03,
		(float)  3.621619922e-03,	(float) -4.467039991e-03,
		(float)  5.326569583e-03,	(float) -6.139428345e-03,
		(float)  6.827286100e-03,	(float) -7.292637026e-03,
		(float)  7.415820578e-03,	(float) -7.048661530e-03,
		(float)  6.000535839e-03,	(float) -4.007523032e-03,
		(float)  6.614989455e-04,	(float)  4.766795704e-03,
		(float) -1.383742819e-02,	(float)  3.080976879e-02,
		(float) -7.337992443e-02,	(float)  4.259781780e-01,
		(float)  1.764224702e-01,	(float) -8.144976228e-02,
		(float)  5.402770345e-02,	(float) -3.983884333e-02,
		(float)  3.053119287e-02,	(float) -2.363543316e-02,
		(float)  1.819002117e-02,	(float) -1.375743263e-02,
		(float)  1.011460968e-02,	(float) -7.133648060e-03,
		(float)  4.729457483e-03,	(float) -2.835102150e-03,
		(float)  1.390092003e-03,	(float) -3.353211685e-04,
		(float) -3.883915051e-04,	(float)  8.398107778e-04,
		(float) -1.075832990e-03,	(float)  1.149711411e-03,
		(float) -1.109378728e-03,	(float)  9.961317863e-04,
		(float) -8.438232131e-04,	(float)  6.786073287e-04,
		(float) -5.192111929e-04,	(float)  3.776454626e-04,
		(float) -2.602343042e-04,	(float)  1.688281030e-04,
		(float) -1.020650652e-04,	(float)  5.656463615e-05,
		(float) -2.796262325e-05,	(float)  1.173028586e-05,
		(float) -3.752797020e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 95 */
		(float)  0.000000000e+00,	(float)  9.975102916e-06,
		(float) -1.966037877e-05,	(float)  3.088746694e-05,
		(float) -4.073844079e-05,	(float)  4.416788604e-05,
		(float) -3.362581560e-05,	(float) -1.123356551e-06,
		(float)  7.289608809e-05,	(float) -1.966215287e-04,
		(float)  3.884561525e-04,	(float) -6.644621824e-04,
		(float)  1.038873298e-03,	(float) -1.522016785e-03,
		(float)  2.118004060e-03,	(float) -2.822334266e-03,
		(float)  3.619570460e-03,	(float) -4.481236258e-03,
		(float)  5.364032591e-03,	(float) -6.208375604e-03,
		(float)  6.937084285e-03,	(float) -7.453752445e-03,
		(float)  7.639818327e-03,	(float) -7.348342448e-03,
		(float)  6.390371256e-03,	(float) -4.504694519e-03,
		(float)  1.288194102e-03,	(float)  3.978274156e-03,
		(float) -1.283243713e-02,	(float)  2.947796401e-02,
		(float) -7.145547436e-02,	(float)  4.286804079e-01,
		(float)  1.716316305e-01,	(float) -8.013426033e-02,
		(float)  5.347518321e-02,	(float) -3.961691240e-02,
		(float)  3.048860305e-02,	(float) -2.369863381e-02,
		(float)  1.831593440e-02,	(float) -1.391790620e-02,
		(float)  1.029014270e-02,	(float) -7.310465448e-03,
		(float)  4.897959295e-03,	(float) -2.988922089e-03,
		(float)  1.525437728e-03,	(float) -4.504497863e-04,
		(float) -2.936272504e-04,	(float)  7.643705739e-04,
		(float) -1.017856992e-03,	(float)  1.106845366e-03,
		(float) -1.079050661e-03,	(float)  9.757754651e-04,
		(float) -8.310461064e-04,	(float)  6.713040843e-04,
		(float) -5.156268802e-04,	(float)  3.763955670e-04,
		(float) -2.602903419e-04,	(float)  1.694786287e-04,
		(float) -1.028617774e-04,	(float)  5.726237347e-05,
		(float) -2.846050661e-05,	(float)  1.201934096e-05,
		(float) -3.873362301e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 96 */
		(float)  0.000000000e+00,	(float)  1.022358092e-05,
		(float) -2.022539063e-05,	(float)  3.200580401e-05,
		(float) -4.273523004e-05,	(float)  4.745394167e-05,
		(float) -3.867847029e-05,	(float)  6.199345624e-06,
		(float)  6.283904057e-05,	(float) -1.834969566e-04,
		(float)  3.721800913e-04,	(float) -6.453406936e-04,
		(float)  1.017759593e-03,	(float) -1.500475497e-03,
		(float)  2.098471352e-03,	(float) -2.808261397e-03,
		(float)  3.615538809e-03,	(float) -4.493034093e-03,
		(float)  5.398688360e-03,	(float) -6.274149748e-03,
		(float)  7.043432223e-03,	(float) -7.611287012e-03,
		(float)  7.860323814e-03,	(float) -7.644932310e-03,
		(float)  6.777955756e-03,	(float) -5.001079752e-03,
		(float)  1.916497887e-03,	(float)  3.184237571e-03,
		(float) -1.181518908e-02,	(float)  2.812044346e-02,
		(float) -6.946759865e-02,	(float)  4.313115855e-01,
		(float)  1.668488451e-01,	(float) -7.878749252e-02,
		(float)  5.289705246e-02,	(float) -3.937455242e-02,
		(float)  3.042965404e-02,	(float) -2.374876378e-02,
		(float)  1.843150701e-02,	(float) -1.407033598e-02,
		(float)  1.045956704e-02,	(float) -7.482791868e-03,
		(float)  5.063302295e-03,	(float) -3.140656871e-03,
		(float)  1.659539617e-03,	(float) -5.649704698e-04,
		(float) -1.990124920e-04,	(float)  6.887703665e-04,
		(float) -9.595321971e-04,	(float)  1.063535495e-03,
		(float) -1.048252786e-03,	(float)  9.549706542e-04,
		(float) -8.178708757e-04,	(float)  6.636675816e-04,
		(float) -5.117777987e-04,	(float)  3.749455406e-04,
		(float) -2.602025167e-04,	(float)  1.700310733e-04,
		(float) -1.035953935e-04,	(float)  5.792211593e-05,
		(float) -2.893722727e-05,	(float)  1.229768601e-05,
		(float) -3.989137316e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 97 */
		(float)  0.000000000e+00,	(float)  1.046922032e-05,
		(float) -2.078465209e-05,	(float)  3.311585275e-05,
		(float) -4.472337053e-05,	(float)  5.073602934e-05,
		(float) -4.374095524e-05,	(float)  1.356013070e-05,
		(float)  5.269470424e-05,	(float) -1.702075579e-04,
		(float)  3.556255663e-04,	(float) -6.257835528e-04,
		(float)  9.960032728e-04,	(float) -1.478030934e-03,
		(float)  2.077720601e-03,	(float) -2.792605939e-03,
		(float)  3.609520567e-03,	(float) -4.502419345e-03,
		(float)  5.430509234e-03,	(float) -6.336705266e-03,
		(float)  7.146261658e-03,	(float) -7.765144333e-03,
		(float)  8.077206678e-03,	(float) -7.938260526e-03,
		(float)  7.163071814e-03,	(float) -5.496407008e-03,
		(float)  2.546076445e-03,	(float)  2.385090130e-03,
		(float) -1.078616285e-02,	(float)  2.673772901e-02,
		(float) -6.741642432e-02,	(float)  4.338708600e-01,
		(float)  1.620754832e-01,	(float) -7.741042024e-02,
		(float)  5.229377007e-02,	(float) -3.911198805e-02,
		(float)  3.035444168e-02,	(float) -2.378584160e-02,
		(float)  1.853670984e-02,	(float) -1.421466412e-02,
		(float)  1.062280907e-02,	(float) -7.650547064e-03,
		(float)  5.225406031e-03,	(float) -3.290230276e-03,
		(float)  1.792328540e-03,	(float) -6.788228013e-04,
		(float) -1.045982798e-04,	(float)  6.130519106e-04,
		(float) -9.008916641e-04,	(float)  1.019807100e-03,
		(float) -1.017003776e-03,	(float)  9.337305954e-04,
		(float) -8.043064895e-04,	(float)  6.557035715e-04,
		(float) -5.076673919e-04,	(float)  3.732972632e-04,
		(float) -2.599717196e-04,	(float)  1.704857584e-04,
		(float) -1.042659513e-04,	(float)  5.854379498e-05,
		(float) -2.939270710e-05,	(float)  1.256527468e-05,
		(float) -4.100114963e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 98 */
		(float)  0.000000000e+00,	(float)  1.071182000e-05,
		(float) -2.133776383e-05,	(float)  3.421689283e-05,
		(float) -4.670165951e-05,	(float)  5.401226812e-05,
		(float) -4.881049424e-05,	(float)  2.095511218e-05,
		(float)  4.246825274e-05,	(float) -1.567598832e-04,
		(float)  3.388004461e-04,	(float) -6.057996674e-04,
		(float)  9.736137035e-04,	(float) -1.454691964e-03,
		(float)  2.055758750e-03,	(float) -2.775370965e-03,
		(float)  3.601512407e-03,	(float) -4.509379137e-03,
		(float)  5.459469017e-03,	(float) -6.395998263e-03,
		(float)  7.245506043e-03,	(float) -7.915229731e-03,
		(float)  8.290338138e-03,	(float) -8.228157766e-03,
		(float)  7.545502562e-03,	(float) -5.990404228e-03,
		(float)  3.176594015e-03,	(float)  1.581240437e-03,
		(float) -9.745845917e-03,	(float)  2.533035863e-02,
		(float) -6.530210277e-02,	(float)  4.363574038e-01,
		(float)  1.573129059e-01,	(float) -7.600401061e-02,
		(float)  5.166580504e-02,	(float) -3.882945353e-02,
		(float)  3.026307010e-02,	(float) -2.380989274e-02,
		(float)  1.863151942e-02,	(float) -1.435083731e-02,
		(float)  1.077979875e-02,	(float) -7.813653496e-03,
		(float)  5.384192051e-03,	(float) -3.437567490e-03,
		(float)  1.923736296e-03,	(float) -7.919469169e-04,
		(float) -1.043538805e-05,	(float)  5.372568849e-04,
		(float) -8.419685063e-04,	(float)  9.756856187e-04,
		(float) -9.853224808e-04,	(float)  9.120687153e-04,
		(float) -7.903620911e-04,	(float)  6.474179593e-04,
		(float) -5.032992313e-04,	(float)  3.714527145e-04,
		(float) -2.595989162e-04,	(float)  1.708430586e-04,
		(float) -1.048735244e-04,	(float)  5.912736472e-05,
		(float) -2.982688138e-05,	(float)  1.282206792e-05,
		(float) -4.206291752e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 99 */
		(float)  0.000000000e+00,	(float)  1.095117837e-05,
		(float) -2.188432626e-05,	(float)  3.530820302e-05,
		(float) -4.866889083e-05,	(float)  5.728076777e-05,
		(float) -5.388429012e-05,	(float)  2.838036261e-05,
		(float)  3.216493229e-05,	(float) -1.431606026e-04,
		(float)  3.217127847e-04,	(float) -5.853982185e-04,
		(float)  9.506006392e-04,	(float) -1.430467977e-03,
		(float)  2.032593435e-03,	(float) -2.756560428e-03,
		(float)  3.591512081e-03,	(float) -4.513901878e-03,
		(float)  5.485542994e-03,	(float) -6.451986496e-03,
		(float)  7.341100593e-03,	(float) -8.061450305e-03,
		(float)  8.499591076e-03,	(float) -8.514456046e-03,
		(float)  7.925031907e-03,	(float) -6.482799166e-03,
		(float)  3.807713101e-03,	(float)  7.731013201e-04,
		(float) -8.694734143e-03,	(float)  2.389888628e-02,
		(float) -6.312480987e-02,	(float)  4.387704117e-01,
		(float)  1.525624659e-01,	(float) -7.456923608e-02,
		(float)  5.101363624e-02,	(float) -3.852719258e-02,
		(float)  3.015565163e-02,	(float) -2.382094957e-02,
		(float)  1.871591796e-02,	(float) -1.447880680e-02,
		(float)  1.093046961e-02,	(float) -7.972036377e-03,
		(float)  5.539583939e-03,	(float) -3.582595140e-03,
		(float)  2.053695642e-03,	(float) -9.042835385e-04,
		(float)  8.342571109e-05,	(float)  4.614268687e-04,
		(float) -7.827958754e-04,	(float)  9.311966083e-04,
		(float) -9.532279143e-04,	(float)  8.899986168e-04,
		(float) -7.760469936e-04,	(float)  6.388168002e-04,
		(float) -4.986770131e-04,	(float)  3.694139731e-04,
		(float) -2.590851460e-04,	(float)  1.711034013e-04,
		(float) -1.054182216e-04,	(float)  5.967280167e-05,
		(float) -3.023969871e-05,	(float)  1.306803402e-05,
		(float) -4.307667759e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 100 */
		(float)  0.000000000e+00,	(float)  1.118709354e-05,
		(float) -2.242393979e-05,	(float)  3.638906167e-05,
		(float) -5.062385566e-05,	(float)  6.053962970e-05,
		(float) -5.895952622e-05,	(float)  3.583191558e-05,
		(float)  2.179005916e-05,	(float) -1.294165026e-04,
		(float)  3.043708180e-04,	(float) -5.645886566e-04,
		(float)  9.269742165e-04,	(float) -1.405368889e-03,
		(float)  2.008232981e-03,	(float) -2.736179156e-03,
		(float)  3.579518421e-03,	(float) -4.515977272e-03,
		(float)  5.508707952e-03,	(float) -6.504629392e-03,
		(float)  7.432982316e-03,	(float) -8.203714983e-03,
		(float)  8.704840100e-03,	(float) -8.796988832e-03,
		(float)  8.301444649e-03,	(float) -6.973319531e-03,
		(float)  4.439094645e-03,	(float) -3.891036798e-05,
		(float) -7.633331606e-03,	(float)  2.244388173e-02,
		(float) -6.088474592e-02,	(float)  4.411091022e-01,
		(float)  1.478255069e-01,	(float) -7.310707397e-02,
		(float)  5.033775211e-02,	(float) -3.820545814e-02,
		(float)  3.003230673e-02,	(float) -2.381905132e-02,
		(float)  1.878989335e-02,	(float) -1.459852846e-02,
		(float)  1.107475882e-02,	(float) -8.125623702e-03,
		(float)  5.691507345e-03,	(float) -3.725241326e-03,
		(float)  2.182140331e-03,	(float) -1.015774003e-03,
		(float)  1.769348745e-04,	(float)  3.856033200e-04,
		(float) -7.234069419e-04,	(float)  8.863657335e-04,
		(float) -9.207392421e-04,	(float)  8.675340716e-04,
		(float) -7.613706731e-04,	(float)  6.299062956e-04,
		(float) -4.938045558e-04,	(float)  3.671832140e-04,
		(float) -2.584315212e-04,	(float)  1.712672655e-04,
		(float) -1.059001868e-04,	(float)  6.018010469e-05,
		(float) -3.063112094e-05,	(float)  1.330314845e-05,
		(float) -4.404246587e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 101 */
		(float)  0.000000000e+00,	(float)  1.141936341e-05,
		(float) -2.295620503e-05,	(float)  3.745874706e-05,
		(float) -5.256534315e-05,	(float)  6.378694808e-05,
		(float) -6.403336790e-05,	(float)  4.330576776e-05,
		(float)  1.134901704e-05,	(float) -1.155344825e-04,
		(float)  2.867829595e-04,	(float) -5.433806979e-04,
		(float)  9.027449505e-04,	(float) -1.379405133e-03,
		(float)  1.982686396e-03,	(float) -2.714232856e-03,
		(float)  3.565531352e-03,	(float) -4.515596332e-03,
		(float)  5.528942196e-03,	(float) -6.553888087e-03,
		(float)  7.521090059e-03,	(float) -8.341934578e-03,
		(float)  8.905961629e-03,	(float) -9.075591129e-03,
		(float)  8.674526600e-03,	(float) -7.461693134e-03,
		(float)  5.070398204e-03,	(float) -8.543739514e-04,
		(float) -6.562150366e-03,	(float)  2.096593038e-02,
		(float) -5.858213574e-02,	(float)  4.433727171e-01,
		(float)  1.431033632e-01,	(float) -7.161850606e-02,
		(float)  4.963865036e-02,	(float) -3.786451228e-02,
		(float)  2.989316390e-02,	(float) -2.380424407e-02,
		(float)  1.885343912e-02,	(float) -1.470996273e-02,
		(float)  1.121260718e-02,	(float) -8.274346282e-03,
		(float)  5.839890027e-03,	(float) -3.865435661e-03,
		(float)  2.309005142e-03,	(float) -1.126360294e-03,
		(float)  2.700423143e-04,	(float)  3.098275529e-04,
		(float) -6.638348780e-04,	(float)  8.412187510e-04,
		(float) -8.878757713e-04,	(float)  8.446890109e-04,
		(float) -7.463427637e-04,	(float)  6.206927886e-04,
		(float) -4.886857978e-04,	(float)  3.647627078e-04,
		(float) -2.576392258e-04,	(float)  1.713351817e-04,
		(float) -1.063195987e-04,	(float)  6.064929475e-05,
		(float) -3.100112306e-05,	(float)  1.352739389e-05,
		(float) -4.496035319e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 102 */
		(float)  0.000000000e+00,	(float)  1.164778585e-05,
		(float) -2.348072312e-05,	(float)  3.851653790e-05,
		(float) -5.449214113e-05,	(float)  6.702081081e-05,
		(float) -6.910296402e-05,	(float)  5.079788092e-05,
		(float)  8.472543516e-07,	(float) -1.015215519e-04,
		(float)  2.689577972e-04,	(float) -5.217843196e-04,
		(float)  8.779237306e-04,	(float) -1.352587658e-03,
		(float)  1.955963377e-03,	(float) -2.690728113e-03,
		(float)  3.549551886e-03,	(float) -4.512751382e-03,
		(float)  5.546225564e-03,	(float) -6.599725442e-03,
		(float)  7.605364542e-03,	(float) -8.476021842e-03,
		(float)  9.102833955e-03,	(float) -9.350099578e-03,
		(float)  9.044064706e-03,	(float) -7.947648039e-03,
		(float)  5.701282124e-03,	(float) -1.672865138e-03,
		(float) -5.481710252e-03,	(float)  1.946563311e-02,
		(float) -5.621722864e-02,	(float)  4.455605222e-01,
		(float)  1.383973589e-01,	(float) -7.010451808e-02,
		(float)  4.891683769e-02,	(float) -3.750462598e-02,
		(float)  2.973835955e-02,	(float) -2.377658063e-02,
		(float)  1.890655446e-02,	(float) -1.481307464e-02,
		(float)  1.134395918e-02,	(float) -8.418137770e-03,
		(float)  5.984661879e-03,	(float) -4.003109303e-03,
		(float)  2.434225915e-03,	(float) -1.235985070e-03,
		(float)  3.626986240e-04,	(float)  2.341407155e-04,
		(float) -6.041128383e-04,	(float)  7.957814955e-04,
		(float) -8.546569397e-04,	(float)  8.214775180e-04,
		(float) -7.309730508e-04,	(float)  6.111827604e-04,
		(float) -4.833247939e-04,	(float)  3.621548181e-04,
		(float) -2.567095144e-04,	(float)  1.713077308e-04,
		(float) -1.066766704e-04,	(float)  6.108041474e-05,
		(float) -3.134969309e-05,	(float)  1.374076010e-05,
		(float) -4.583044472e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 103 */
		(float)  0.000000000e+00,	(float)  1.187215878e-05,
		(float) -2.399709592e-05,	(float)  3.956171376e-05,
		(float) -5.640303684e-05,	(float)  7.023930065e-05,
		(float) -7.416544846e-05,	(float)  5.830418402e-05,
		(float) -9.709718474e-06,	(float) -8.738482659e-05,
		(float)  2.509040888e-04,	(float) -4.998097558e-04,
		(float)  8.525218162e-04,	(float) -1.324927925e-03,
		(float)  1.928074298e-03,	(float) -2.665672390e-03,
		(float)  3.531582132e-03,	(float) -4.507436072e-03,
		(float)  5.560539444e-03,	(float) -6.642106077e-03,
		(float)  7.685748402e-03,	(float) -8.605891521e-03,
		(float)  9.295337322e-03,	(float) -9.620352547e-03,
		(float)  9.409847161e-03,	(float) -8.430912702e-03,
		(float)  6.331403721e-03,	(float) -2.493956229e-03,
		(float) -4.392538627e-03,	(float)  1.794360607e-02,
		(float) -5.379029840e-02,	(float)  4.476718076e-01,
		(float)  1.337088079e-01,	(float) -6.856609937e-02,
		(float)  4.817282945e-02,	(float) -3.712607896e-02,
		(float)  2.956803793e-02,	(float) -2.373612057e-02,
		(float)  1.894924417e-02,	(float) -1.490783386e-02,
		(float)  1.146876296e-02,	(float) -8.556934692e-03,
		(float)  6.125754962e-03,	(float) -4.138194986e-03,
		(float)  2.557739582e-03,	(float) -1.344591695e-03,
		(float)  4.548548040e-04,	(float)  1.585837681e-04,
		(float) -5.442739427e-04,	(float)  7.500798645e-04,
		(float) -8.211023039e-04,	(float)  7.979138193e-04,
		(float) -7.152714651e-04,	(float)  6.013828253e-04,
		(float) -4.777257131e-04,	(float)  3.593620002e-04,
		(float) -2.556437112e-04,	(float)  1.711855442e-04,
		(float) -1.069716488e-04,	(float)  6.147352933e-05,
		(float) -3.167683202e-05,	(float)  1.394324388e-05,
		(float) -4.665287945e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 104 */
		(float)  0.000000000e+00,	(float)  1.209228038e-05,
		(float) -2.450492630e-05,	(float)  4.059355546e-05,
		(float) -5.829681757e-05,	(float)  7.344049622e-05,
		(float) -7.921794166e-05,	(float)  6.582057537e-05,
		(float) -2.031633174e-05,	(float) -7.313152530e-05,
		(float)  2.326307583e-04,	(float) -4.774674929e-04,
		(float)  8.265508316e-04,	(float) -1.296437900e-03,
		(float)  1.899030212e-03,	(float) -2.639074026e-03,
		(float)  3.511625297e-03,	(float) -4.499645382e-03,
		(float)  5.571866790e-03,	(float) -6.680996387e-03,
		(float)  7.762186222e-03,	(float) -8.731460404e-03,
		(float)  9.483353995e-03,	(float) -9.886190227e-03,
		(float)  9.771663529e-03,	(float) -8.911216126e-03,
		(float)  6.960419459e-03,	(float) -3.317216327e-03,
		(float) -3.295170161e-03,	(float)  1.640048052e-02,
		(float) -5.130164331e-02,	(float)  4.497058875e-01,
		(float)  1.290390133e-01,	(float) -6.700424236e-02,
		(float)  4.740714939e-02,	(float) -3.672915952e-02,
		(float)  2.938235101e-02,	(float) -2.368293012e-02,
		(float)  1.898151869e-02,	(float) -1.499421464e-02,
		(float)  1.158697039e-02,	(float) -8.690676470e-03,
		(float)  6.263103541e-03,	(float) -4.270627054e-03,
		(float)  2.679484196e-03,	(float) -1.452124264e-03,
		(float)  5.464622875e-04,	(float)  8.319746113e-05,
		(float) -4.843512574e-04,	(float)  7.041398047e-04,
		(float) -7.872315285e-04,	(float)  7.740122763e-04,
		(float) -6.992480768e-04,	(float)  5.912997273e-04,
		(float) -4.718928354e-04,	(float)  3.563867989e-04,
		(float) -2.544432087e-04,	(float)  1.709693023e-04,
		(float) -1.072048148e-04,	(float)  6.182872470e-05,
		(float) -3.198255361e-05,	(float)  1.413484901e-05,
		(float) -4.742782970e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 105 */
		(float)  0.000000000e+00,	(float)  1.230794916e-05,
		(float) -2.500381837e-05,	(float)  4.161134556e-05,
		(float) -6.017227143e-05,	(float)  7.662247312e-05,
		(float) -8.425755219e-05,	(float)  7.334292469e-05,
		(float) -3.096695933e-05,	(float) -5.876896634e-05,
		(float)  2.141468912e-04,	(float) -4.547682646e-04,
		(float)  8.000227613e-04,	(float) -1.267130052e-03,
		(float)  1.868842848e-03,	(float) -2.610942234e-03,
		(float)  3.489685685e-03,	(float) -4.489375631e-03,
		(float)  5.580192132e-03,	(float) -6.716364574e-03,
		(float)  7.834624576e-03,	(float) -8.852647375e-03,
		(float)  9.666768328e-03,	(float) -1.014745472e-02,
		(float)  1.012930486e-02,	(float) -9.388288006e-03,
		(float)  7.587985130e-03,	(float) -4.142211552e-03,
		(float) -2.190146592e-03,	(float)  1.483690257e-02,
		(float) -4.875158609e-02,	(float)  4.516621012e-01,
		(float)  1.243892664e-01,	(float) -6.541994215e-02,
		(float)  4.662032933e-02,	(float) -3.631416429e-02,
		(float)  2.918145838e-02,	(float) -2.361708210e-02,
		(float)  1.900339400e-02,	(float) -1.507219586e-02,
		(float)  1.169853705e-02,	(float) -8.819305448e-03,
		(float)  6.396644107e-03,	(float) -4.400341490e-03,
		(float)  2.799398964e-03,	(float) -1.558527636e-03,
		(float)  6.374729653e-04,	(float)  8.022313949e-06,
		(float) -4.243777779e-04,	(float)  6.579872967e-04,
		(float) -7.530643747e-04,	(float)  7.497873767e-04,
		(float) -6.829130894e-04,	(float)  5.809403351e-04,
		(float) -4.658305488e-04,	(float)  3.532318469e-04,
		(float) -2.531094669e-04,	(float)  1.706597343e-04,
		(float) -1.073764822e-04,	(float)  6.214610835e-05,
		(float) -3.226688436e-05,	(float)  1.431558613e-05,
		(float) -4.815550060e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 106 */
		(float)  0.000000000e+00,	(float)  1.251896416e-05,
		(float) -2.549337779e-05,	(float)  4.261436878e-05,
		(float) -6.202818802e-05,	(float)  7.978330502e-05,
		(float) -8.928137830e-05,	(float)  8.086707535e-05,
		(float) -4.165592154e-05,	(float) -4.430456379e-05,
		(float)  1.954617306e-04,	(float) -4.317230473e-04,
		(float)  7.729499445e-04,	(float) -1.237017348e-03,
		(float)  1.837524604e-03,	(float) -2.581287101e-03,
		(float)  3.465768700e-03,	(float) -4.476624481e-03,
		(float)  5.585501595e-03,	(float) -6.748180664e-03,
		(float)  7.903012056e-03,	(float) -8.969373467e-03,
		(float)  9.845466834e-03,	(float) -1.040399014e-02,
		(float)  1.048256381e-02,	(float) -9.861858875e-03,
		(float)  8.213756033e-03,	(float) -4.968505255e-03,
		(float) -1.078016486e-03,	(float)  1.325353305e-02,
		(float) -4.614047393e-02,	(float)  4.535398126e-01,
		(float)  1.197608472e-01,	(float) -6.381419611e-02,
		(float)  4.581290883e-02,	(float) -3.588139812e-02,
		(float)  2.896552710e-02,	(float) -2.353865590e-02,
		(float)  1.901489169e-02,	(float) -1.514176099e-02,
		(float)  1.180342224e-02,	(float) -8.942766917e-03,
		(float)  6.526315408e-03,	(float) -4.527275949e-03,
		(float)  2.917424276e-03,	(float) -1.663747459e-03,
		(float)  7.278392104e-04,	(float) -6.690140689e-05,
		(float) -3.643864104e-04,	(float)  6.116483414e-04,
		(float) -7.186206894e-04,	(float)  7.252537263e-04,
		(float) -6.662768331e-04,	(float)  5.703116377e-04,
		(float) -4.595433467e-04,	(float)  3.498998627e-04,
		(float) -2.516440113e-04,	(float)  1.702576172e-04,
		(float) -1.074869979e-04,	(float)  6.242580887e-05,
		(float) -3.252986329e-05,	(float)  1.448547272e-05,
		(float) -4.883612948e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 107 */
		(float)  0.000000000e+00,	(float)  1.272512506e-05,
		(float) -2.597321196e-05,	(float)  4.360191246e-05,
		(float) -6.386335919e-05,	(float)  8.292106473e-05,
		(float) -9.428650951e-05,	(float)  8.838884653e-05,
		(float) -5.237748803e-05,	(float) -2.974582393e-05,
		(float)  1.765846726e-04,	(float) -4.083430549e-04,
		(float)  7.453450703e-04,	(float) -1.206113245e-03,
		(float)  1.805088542e-03,	(float) -2.550119583e-03,
		(float)  3.439880848e-03,	(float) -4.461390945e-03,
		(float)  5.587782909e-03,	(float) -6.776416533e-03,
		(float)  7.967299311e-03,	(float) -9.081561908e-03,
		(float)  1.001933825e-02,	(float) -1.065564268e-02,
		(float)  1.083123475e-02,	(float) -1.033166025e-02,
		(float)  8.837387162e-03,	(float) -5.795658240e-03,
		(float)  4.066500956e-05,	(float)  1.165104721e-02,
		(float) -4.346867837e-02,	(float)  4.553384111e-01,
		(float)  1.151550232e-01,	(float) -6.218800340e-02,
		(float)  4.498543492e-02,	(float) -3.543117381e-02,
		(float)  2.873473166e-02,	(float) -2.344773739e-02,
		(float)  1.901603882e-02,	(float) -1.520289813e-02,
		(float)  1.190158903e-02,	(float) -9.061009131e-03,
		(float)  6.652058477e-03,	(float) -4.651369785e-03,
		(float)  3.033501733e-03,	(float) -1.767730196e-03,
		(float)  8.175139032e-04,	(float) -1.415337087e-04,
		(float) -3.044099545e-04,	(float)  5.651489452e-04,
		(float) -6.839203932e-04,	(float)  7.004260401e-04,
		(float) -6.493497588e-04,	(float)  5.594207405e-04,
		(float) -4.530358246e-04,	(float)  3.463936487e-04,
		(float) -2.500484326e-04,	(float)  1.697637755e-04,
		(float) -1.075367410e-04,	(float)  6.266797568e-05,
		(float) -3.277154187e-05,	(float)  1.464453298e-05,
		(float) -4.946998540e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 108 */
		(float)  0.000000000e+00,	(float)  1.292623231e-05,
		(float) -2.644293035e-05,	(float)  4.457326700e-05,
		(float) -6.567657970e-05,	(float)  8.603382529e-05,
		(float) -9.927002825e-05,	(float)  9.590403549e-05,
		(float) -6.312588074e-05,	(float) -1.510034144e-05,
		(float)  1.575252617e-04,	(float) -3.846397334e-04,
		(float)  7.172211712e-04,	(float) -1.174431689e-03,
		(float)  1.771548388e-03,	(float) -2.517451504e-03,
		(float)  3.412029736e-03,	(float) -4.443675391e-03,
		(float)  5.587025420e-03,	(float) -6.801045925e-03,
		(float)  8.027439078e-03,	(float) -9.189138169e-03,
		(float)  1.018827362e-02,	(float) -1.090226073e-02,
		(float)  1.117511390e-02,	(float) -1.079742479e-02,
		(float)  9.458533382e-03,	(float) -6.623228980e-03,
		(float)  1.165336417e-03,	(float)  1.003013457e-02,
		(float) -4.073659528e-02,	(float)  4.570573114e-01,
		(float)  1.105730491e-01,	(float) -6.054236455e-02,
		(float)  4.413846176e-02,	(float) -3.496381198e-02,
		(float)  2.848925375e-02,	(float) -2.334441883e-02,
		(float)  1.900686799e-02,	(float) -1.525559993e-02,
		(float)  1.199300419e-02,	(float) -9.173983328e-03,
		(float)  6.773816655e-03,	(float) -4.772564076e-03,
		(float)  3.147574175e-03,	(float) -1.870423154e-03,
		(float)  9.064504548e-04,	(float) -2.158348935e-04,
		(float) -2.444810855e-04,	(float)  5.185151058e-04,
		(float) -6.489834699e-04,	(float)  6.753191342e-04,
		(float) -6.321424319e-04,	(float)  5.482748605e-04,
		(float) -4.463126769e-04,	(float)  3.427160889e-04,
		(float) -2.483243848e-04,	(float)  1.691790798e-04,
		(float) -1.075261227e-04,	(float)  6.287277880e-05,
		(float) -3.299198384e-05,	(float)  1.479279773e-05,
		(float) -5.005736846e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 109 */
		(float)  0.000000000e+00,	(float)  1.312208733e-05,
		(float) -2.690214472e-05,	(float)  4.552772630e-05,
		(float) -6.746664801e-05,	(float)  8.911966113e-05,
		(float) -1.042290114e-04,	(float)  1.034084197e-04,
		(float) -7.389527689e-05,	(float) -3.757955928e-07,
		(float)  1.382931864e-04,	(float) -3.606247559e-04,
		(float)  6.885916182e-04,	(float) -1.141987104e-03,
		(float)  1.736918522e-03,	(float) -2.483295551e-03,
		(float)  3.382224071e-03,	(float) -4.423479544e-03,
		(float)  5.583220100e-03,	(float) -6.822044472e-03,
		(float)  8.083386215e-03,	(float) -9.292030011e-03,
		(float)  1.035216634e-02,	(float) -1.114369496e-02,
		(float)  1.151399943e-02,	(float) -1.125888643e-02,
		(float)  1.007684962e-02,	(float) -7.450773844e-03,
		(float)  2.295430180e-03,	(float)  8.391498651e-03,
		(float) -3.794464483e-02,	(float)  4.586959538e-01,
		(float)  1.060161668e-01,	(float) -5.887828101e-02,
		(float)  4.327255035e-02,	(float) -3.447964082e-02,
		(float)  2.822928226e-02,	(float) -2.322879886e-02,
		(float)  1.898741724e-02,	(float) -1.529986367e-02,
		(float)  1.207763831e-02,	(float) -9.281643752e-03,
		(float)  6.891535616e-03,	(float) -4.890801659e-03,
		(float)  3.259585710e-03,	(float) -1.971774510e-03,
		(float)  9.946028313e-04,	(float) -2.897655790e-04,
		(float) -1.846323369e-04,	(float)  4.717727979e-04,
		(float) -6.138299549e-04,	(float)  6.499479167e-04,
		(float) -6.146655258e-04,	(float)  5.368813215e-04,
		(float) -4.393786941e-04,	(float)  3.388701474e-04,
		(float) -2.464735841e-04,	(float)  1.685044465e-04,
		(float) -1.074555856e-04,	(float)  6.304040857e-05,
		(float) -3.319126509e-05,	(float)  1.493030436e-05,
		(float) -5.059860928e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 110 */
		(float)  0.000000000e+00,	(float)  1.331249260e-05,
		(float) -2.735046942e-05,	(float)  4.646458823e-05,
		(float) -6.923236699e-05,	(float)  9.217664913e-05,
		(float) -1.091605320e-04,	(float)  1.108977594e-04,
		(float) -8.467981203e-05,	(float)  1.442005360e-05,
		(float)  1.188982739e-04,	(float) -3.363100169e-04,
		(float)  6.594701140e-04,	(float) -1.108794388e-03,
		(float)  1.701213975e-03,	(float) -2.447665272e-03,
		(float)  3.350473659e-03,	(float) -4.400806494e-03,
		(float)  5.576359561e-03,	(float) -6.839389715e-03,
		(float)  8.135097730e-03,	(float) -9.390167536e-03,
		(float)  1.051091222e-02,	(float) -1.137979839e-02,
		(float)  1.184769157e-02,	(float) -1.171578054e-02,
		(float)  1.069199104e-02,	(float) -8.277847316e-03,
		(float)  3.430372926e-03,	(float)  6.735856748e-03,
		(float) -3.509327137e-02,	(float)  4.602538048e-01,
		(float)  1.014856042e-01,	(float) -5.719675475e-02,
		(float)  4.238826818e-02,	(float) -3.397899590e-02,
		(float)  2.795501305e-02,	(float) -2.310098237e-02,
		(float)  1.895773005e-02,	(float) -1.533569117e-02,
		(float)  1.215546568e-02,	(float) -9.383947662e-03,
		(float)  7.005163389e-03,	(float) -5.006027145e-03,
		(float)  3.369481739e-03,	(float) -2.071733335e-03,
		(float)  1.081925577e-03,	(float) -3.632867188e-04,
		(float) -1.248960830e-04,	(float)  4.249479593e-04,
		(float) -5.784799241e-04,	(float)  6.243273794e-04,
		(float) -5.969298155e-04,	(float)  5.252475502e-04,
		(float) -4.322387595e-04,	(float)  3.348588657e-04,
		(float) -2.444978077e-04,	(float)  1.677408369e-04,
		(float) -1.073256034e-04,	(float)  6.317107540e-05,
		(float) -3.336947346e-05,	(float)  1.505709672e-05,
		(float) -5.109406834e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 111 */
		(float)  0.000000000e+00,	(float)  1.349725181e-05,
		(float) -2.778752161e-05,	(float)  4.738315509e-05,
		(float) -7.097254460e-05,	(float)  9.520286977e-05,
		(float) -1.140616608e-04,	(float)  1.183677993e-04,
		(float) -9.547358309e-05,	(float)  2.927936934e-05,
		(float)  9.935048614e-05,	(float) -3.117076266e-04,
		(float)  6.298706871e-04,	(float) -1.074868910e-03,
		(float)  1.664450422e-03,	(float) -2.410575068e-03,
		(float)  3.316789404e-03,	(float) -4.375660693e-03,
		(float)  5.566438059e-03,	(float) -6.853061122e-03,
		(float)  8.182532814e-03,	(float) -9.483483226e-03,
		(float)  1.066440958e-02,	(float) -1.161042648e-02,
		(float)  1.217599274e-02,	(float) -1.216784405e-02,
		(float)  1.130361323e-02,	(float) -9.104002226e-03,
		(float)  4.569585726e-03,	(float)  5.063939675e-03,
		(float) -3.218294336e-02,	(float)  4.617303567e-01,
		(float)  9.698257561e-02,	(float) -5.549878780e-02,
		(float)  4.148618895e-02,	(float) -3.346221998e-02,
		(float)  2.766664887e-02,	(float) -2.296108045e-02,
		(float)  1.891785526e-02,	(float) -1.536308882e-02,
		(float)  1.222646441e-02,	(float) -9.480855353e-03,
		(float)  7.114650381e-03,	(float) -5.118186956e-03,
		(float)  3.477208982e-03,	(float) -2.170249619e-03,
		(float)  1.168373837e-03,	(float) -4.363596231e-04,
		(float) -6.530452199e-05,	(float)  3.780664764e-04,
		(float) -5.429534826e-04,	(float)  5.984725891e-04,
		(float) -5.789461713e-04,	(float)  5.133810709e-04,
		(float) -4.248978461e-04,	(float)  3.306853610e-04,
		(float) -2.423988920e-04,	(float)  1.668892561e-04,
		(float) -1.071366802e-04,	(float)  6.326500945e-05,
		(float) -3.352670861e-05,	(float)  1.517322499e-05,
		(float) -5.154413538e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 112 */
		(float)  0.000000000e+00,	(float)  1.367617007e-05,
		(float) -2.821292158e-05,	(float)  4.828273403e-05,
		(float) -7.268599469e-05,	(float)  9.819640826e-05,
		(float) -1.189294680e-04,	(float)  1.258142717e-04,
		(float) -1.062706515e-04,	(float)  4.419424208e-05,
		(float)  7.965991402e-05,	(float) -2.868299053e-04,
		(float)  5.998076855e-04,	(float) -1.040226497e-03,
		(float)  1.626644177e-03,	(float) -2.372040192e-03,
		(float)  3.281183305e-03,	(float) -4.348047963e-03,
		(float)  5.553451506e-03,	(float) -6.863040102e-03,
		(float)  8.225652867e-03,	(float) -9.571911987e-03,
		(float)  1.081255928e-02,	(float) -1.183543726e-02,
		(float)  1.249870766e-02,	(float) -1.261481563e-02,
		(float)  1.191137241e-02,	(float) -9.928789977e-03,
		(float)  5.712484365e-03,	(float)  3.376491522e-03,
		(float) -2.921415329e-02,	(float)  4.631251282e-01,
		(float)  9.250828064e-02,	(float) -5.378538181e-02,
		(float)  4.056689222e-02,	(float) -3.292966277e-02,
		(float)  2.736439922e-02,	(float) -2.280921029e-02,
		(float)  1.886784706e-02,	(float) -1.538206755e-02,
		(float)  1.229061634e-02,	(float) -9.572330163e-03,
		(float)  7.219949394e-03,	(float) -5.227229336e-03,
		(float)  3.582715506e-03,	(float) -2.267274297e-03,
		(float)  1.253903380e-03,	(float) -5.089459779e-04,
		(float) -5.889658537e-06,	(float)  3.311541704e-04,
		(float) -5.072707535e-04,	(float)  5.723986791e-04,
		(float) -5.607255523e-04,	(float)  5.012895014e-04,
		(float) -4.173610132e-04,	(float)  3.263528240e-04,
		(float) -2.401787319e-04,	(float)  1.659507525e-04,
		(float) -1.068893503e-04,	(float)  6.332246038e-05,
		(float) -3.366308188e-05,	(float)  1.527874565e-05,
		(float) -5.194922871e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 113 */
		(float)  0.000000000e+00,	(float)  1.384905397e-05,
		(float) -2.862629295e-05,	(float)  4.916263752e-05,
		(float) -7.437153772e-05,	(float)  1.011553556e-04,
		(float) -1.237610249e-04,	(float)  1.332328982e-04,
		(float) -1.170650464e-04,	(float)  5.915669355e-05,
		(float)  5.983677288e-05,	(float) -2.616893770e-04,
		(float)  5.692957696e-04,	(float) -1.004883431e-03,
		(float)  1.587812183e-03,	(float) -2.332076741e-03,
		(float)  3.243668453e-03,	(float) -4.317975491e-03,
		(float)  5.537397476e-03,	(float) -6.869310024e-03,
		(float)  8.264421527e-03,	(float) -9.655391197e-03,
		(float)  1.095526479e-02,	(float) -1.205469133e-02,
		(float)  1.281564345e-02,	(float) -1.305643583e-02,
		(float)  1.251492558e-02,	(float) -1.075176077e-02,
		(float)  6.858479610e-03,	(float)  1.674269392e-03,
		(float) -2.618741758e-02,	(float)  4.644376645e-01,
		(float)  8.806390420e-02,	(float) -5.205753766e-02,
		(float)  3.963096311e-02,	(float) -3.238168074e-02,
		(float)  2.704848022e-02,	(float) -2.264549512e-02,
		(float)  1.880776494e-02,	(float) -1.539264281e-02,
		(float)  1.234790708e-02,	(float) -9.658338488e-03,
		(float)  7.321015647e-03,	(float) -5.333104386e-03,
		(float)  3.685950742e-03,	(float) -2.362759271e-03,
		(float)  1.338470621e-03,	(float) -5.810078655e-04,
		(float)  5.331671277e-05,	(float)  2.842367833e-04,
		(float) -4.714518670e-04,	(float)  5.461208404e-04,
		(float) -5.422790002e-04,	(float)  4.889805482e-04,
		(float) -4.096334033e-04,	(float)  3.218645163e-04,
		(float) -2.378392787e-04,	(float)  1.649264166e-04,
		(float) -1.065841774e-04,	(float)  6.334369702e-05,
		(float) -3.377871602e-05,	(float)  1.537372130e-05,
		(float) -5.230979458e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 114 */
		(float)  0.000000000e+00,	(float)  1.401571178e-05,
		(float) -2.902726301e-05,	(float)  5.002218384e-05,
		(float) -7.602800145e-05,	(float)  1.040778099e-04,
		(float) -1.285534055e-04,	(float)  1.406193923e-04,
		(float) -1.278507676e-04,	(float)  7.415868088e-05,
		(float)  3.989139718e-05,	(float) -2.362987639e-04,
		(float)  5.383499057e-04,	(float) -9.688564424e-04,
		(float)  1.547972009e-03,	(float) -2.290701651e-03,
		(float)  3.204259029e-03,	(float) -4.285451834e-03,
		(float)  5.518275212e-03,	(float) -6.871856231e-03,
		(float)  8.298804695e-03,	(float) -9.733860743e-03,
		(float)  1.109243227e-02,	(float) -1.226805204e-02,
		(float)  1.312660976e-02,	(float) -1.349244718e-02,
		(float)  1.311393071e-02,	(float) -1.157246385e-02,
		(float)  8.006977483e-03,	(float) -4.195686492e-05,
		(float) -2.310327643e-02,	(float)  4.656675375e-01,
		(float)  8.365061596e-02,	(float) -5.031625499e-02,
		(float)  3.867899197e-02,	(float) -3.181863692e-02,
		(float)  2.671911444e-02,	(float) -2.247006412e-02,
		(float)  1.873767363e-02,	(float) -1.539483453e-02,
		(float)  1.239832600e-02,	(float) -9.738849790e-03,
		(float)  7.417806790e-03,	(float) -5.435764075e-03,
		(float)  3.786865518e-03,	(float) -2.456657437e-03,
		(float)  1.422032642e-03,	(float) -6.525077833e-04,
		(float)  1.122830242e-04,	(float)  2.373399642e-04,
		(float) -4.355169490e-04,	(float)  5.196543133e-04,
		(float) -5.236176323e-04,	(float)  4.764620015e-04,
		(float) -4.017202389e-04,	(float)  3.172237691e-04,
		(float) -2.353825393e-04,	(float)  1.638173806e-04,
		(float) -1.062217542e-04,	(float)  6.332900707e-05,
		(float) -3.387374514e-05,	(float)  1.545822061e-05,
		(float) -5.262630651e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 115 */
		(float)  0.000000000e+00,	(float)  1.417595359e-05,
		(float) -2.941546294e-05,	(float)  5.086069746e-05,
		(float) -7.765422175e-05,	(float)  1.069618773e-04,
		(float) -1.333036881e-04,	(float)  1.479694617e-04,
		(float) -1.386217892e-04,	(float)  8.919210081e-05,
		(float)  1.983423532e-05,	(float) -2.106709798e-04,
		(float)  5.069853587e-04,	(float) -9.321626994e-04,
		(float)  1.507141842e-03,	(float) -2.247932690e-03,
		(float)  3.162970296e-03,	(float) -4.250486918e-03,
		(float)  5.496085629e-03,	(float) -6.870666055e-03,
		(float)  8.328770562e-03,	(float) -9.807263060e-03,
		(float)  1.122397060e-02,	(float) -1.247538548e-02,
		(float)  1.343141887e-02,	(float) -1.392259439e-02,
		(float)  1.370804698e-02,	(float) -1.239044772e-02,
		(float)  9.157379545e-03,	(float) -1.771404928e-03,
		(float) -1.996229374e-02,	(float)  4.668143458e-01,
		(float)  7.926956996e-02,	(float) -4.856253183e-02,
		(float)  3.771157404e-02,	(float) -3.124090064e-02,
		(float)  2.637653081e-02,	(float) -2.228305229e-02,
		(float)  1.865764304e-02,	(float) -1.538866715e-02,
		(float)  1.244186625e-02,	(float) -9.813836603e-03,
		(float)  7.510282923e-03,	(float) -5.535162268e-03,
		(float)  3.885412072e-03,	(float) -2.548922702e-03,
		(float)  1.504547215e-03,	(float) -7.234086635e-04,
		(float)  1.709779516e-04,	(float)  1.904892554e-04,
		(float) -3.994861102e-04,	(float)  4.930143786e-04,
		(float) -5.047526357e-04,	(float)  4.637417310e-04,
		(float) -3.936268191e-04,	(float)  3.124339799e-04,
		(float) -2.328105741e-04,	(float)  1.626248168e-04,
		(float) -1.058027017e-04,	(float)  6.327869680e-05,
		(float) -3.394831441e-05,	(float)  1.553231818e-05,
		(float) -5.289926460e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 116 */
		(float)  0.000000000e+00,	(float)  1.432959147e-05,
		(float) -2.979052808e-05,	(float)  5.167750958e-05,
		(float) -7.924904326e-05,	(float)  1.098056732e-04,
		(float) -1.380089574e-04,	(float)  1.552788108e-04,
		(float) -1.493720623e-04,	(float)  1.042487939e-04,
		(float) -3.241556077e-07,	(float) -1.848191239e-04,
		(float)  4.752176851e-04,	(float) -8.948198022e-04,
		(float)  1.465340476e-03,	(float) -2.203788452e-03,
		(float)  3.119818598e-03,	(float) -4.213092034e-03,
		(float)  5.470831322e-03,	(float) -6.865728827e-03,
		(float)  8.354289634e-03,	(float) -9.875543174e-03,
		(float)  1.134979143e-02,	(float) -1.267656064e-02,
		(float)  1.372988580e-02,	(float) -1.434662449e-02,
		(float)  1.429693490e-02,	(float) -1.320526039e-02,
		(float)  1.030908317e-02,	(float) -3.513280284e-03,
		(float) -1.676505698e-02,	(float)  4.678777153e-01,
		(float)  7.492190418e-02,	(float) -4.679736410e-02,
		(float)  3.672930919e-02,	(float) -3.064884733e-02,
		(float)  2.602096442e-02,	(float) -2.208460042e-02,
		(float)  1.856774825e-02,	(float) -1.537416953e-02,
		(float)  1.247852470e-02,	(float) -9.883274541e-03,
		(float)  7.598406609e-03,	(float) -5.631254742e-03,
		(float)  3.981544081e-03,	(float) -2.639510008e-03,
		(float)  1.585972820e-03,	(float) -7.936738912e-04,
		(float)  2.293704301e-04,	(float)  1.437100787e-04,
		(float) -3.633794352e-04,	(float)  4.662163490e-04,
		(float) -4.856952601e-04,	(float)  4.508276807e-04,
		(float) -3.853585161e-04,	(float)  3.074986109e-04,
		(float) -2.301254961e-04,	(float)  1.613499374e-04,
		(float) -1.053276690e-04,	(float)  6.319309066e-05,
		(float) -3.400257993e-05,	(float)  1.559609444e-05,
		(float) -5.312919479e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 117 */
		(float)  0.000000000e+00,	(float)  1.447643957e-05,
		(float) -3.015209821e-05,	(float)  5.247195853e-05,
		(float) -8.081132020e-05,	(float)  1.126073234e-04,
		(float) -1.426663055e-04,	(float)  1.625431428e-04,
		(float) -1.600955188e-04,	(float)  1.193205488e-04,
		(float) -2.057311528e-05,	(float) -1.587564744e-04,
		(float)  4.430627253e-04,	(float) -8.568457747e-04,
		(float)  1.422587306e-03,	(float) -2.158288349e-03,
		(float)  3.074821354e-03,	(float) -4.173279839e-03,
		(float)  5.442516571e-03,	(float) -6.857035892e-03,
		(float)  8.375334751e-03,	(float) -9.938648738e-03,
		(float)  1.146980931e-02,	(float) -1.287144943e-02,
		(float)  1.402182841e-02,	(float) -1.476428692e-02,
		(float)  1.488025651e-02,	(float) -1.401644959e-02,
		(float)  1.146148184e-02,	(float) -5.266776515e-03,
		(float) -1.351217698e-02,	(float)  4.688572987e-01,
		(float)  7.060874026e-02,	(float) -4.502174526e-02,
		(float)  3.573280151e-02,	(float) -3.004285832e-02,
		(float)  2.565265641e-02,	(float) -2.187485497e-02,
		(float)  1.846806939e-02,	(float) -1.535137494e-02,
		(float)  1.250830196e-02,	(float) -9.947142302e-03,
		(float)  7.682142885e-03,	(float) -5.723999206e-03,
		(float)  4.075216679e-03,	(float) -2.728375357e-03,
		(float)  1.666268668e-03,	(float) -8.632673236e-04,
		(float)  2.874296711e-04,	(float)  9.702772217e-05,
		(float) -3.272169712e-04,	(float)  4.392755609e-04,
		(float) -4.664568121e-04,	(float)  4.377278647e-04,
		(float) -3.769207722e-04,	(float)  3.024211866e-04,
		(float) -2.273294691e-04,	(float)  1.599939929e-04,
		(float) -1.047973322e-04,	(float)  6.307253103e-05,
		(float) -3.403670855e-05,	(float)  1.564963554e-05,
		(float) -5.331664821e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 118 */
		(float)  0.000000000e+00,	(float)  1.461631432e-05,
		(float) -3.049981783e-05,	(float)  5.324339021e-05,
		(float) -8.233991706e-05,	(float)  1.153649653e-04,
		(float) -1.472728345e-04,	(float)  1.697581627e-04,
		(float) -1.707860742e-04,	(float)  1.343991066e-04,
		(float) -4.090188555e-05,	(float) -1.324964815e-04,
		(float)  4.105365964e-04,	(float) -8.182590556e-04,
		(float)  1.378902320e-03,	(float) -2.111452604e-03,
		(float)  3.027997051e-03,	(float) -4.131064353e-03,
		(float)  5.411147337e-03,	(float) -6.844580619e-03,
		(float)  8.391881112e-03,	(float) -9.996530065e-03,
		(float)  1.158394163e-02,	(float) -1.305992681e-02,
		(float)  1.430706755e-02,	(float) -1.517533375e-02,
		(float)  1.545767559e-02,	(float) -1.482356304e-02,
		(float)  1.261396543e-02,	(float) -7.031075590e-03,
		(float) -1.020428787e-02,	(float)  4.697527760e-01,
		(float)  6.633118301e-02,	(float) -4.323666589e-02,
		(float)  3.472265904e-02,	(float) -2.942332059e-02,
		(float)  2.527185379e-02,	(float) -2.165396794e-02,
		(float)  1.835869164e-02,	(float) -1.532032107e-02,
		(float)  1.253120238e-02,	(float) -1.000542167e-02,
		(float)  7.761459277e-03,	(float) -5.813355316e-03,
		(float)  4.166386477e-03,	(float) -2.815475828e-03,
		(float)  1.745394720e-03,	(float) -9.321533077e-04,
		(float)  3.451251773e-04,	(float)  5.046732651e-05,
		(float) -2.910187176e-04,	(float)  4.122073653e-04,
		(float) -4.470486478e-04,	(float)  4.244503618e-04,
		(float) -3.683190961e-04,	(float)  2.972052915e-04,
		(float) -2.244247063e-04,	(float)  1.585582717e-04,
		(float) -1.042123944e-04,	(float)  6.291737782e-05,
		(float) -3.405087760e-05,	(float)  1.569303322e-05,
		(float) -5.346220043e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 119 */
		(float)  0.000000000e+00,	(float)  1.474903459e-05,
		(float) -3.083333637e-05,	(float)  5.399115861e-05,
		(float) -8.383370933e-05,	(float)  1.180767490e-04,
		(float) -1.518256571e-04,	(float)  1.769195790e-04,
		(float) -1.814376316e-04,	(float)  1.494761652e-04,
		(float) -6.129961601e-05,	(float) -1.060527611e-04,
		(float)  3.776556836e-04,	(float) -7.790784905e-04,
		(float)  1.334306091e-03,	(float) -2.063302239e-03,
		(float)  2.979365235e-03,	(float) -4.086460955e-03,
		(float)  5.376731270e-03,	(float) -6.828358409e-03,
		(float)  8.403906296e-03,	(float) -1.004914017e-02,
		(float)  1.169210878e-02,	(float) -1.324187081e-02,
		(float)  1.458542710e-02,	(float) -1.557951976e-02,
		(float)  1.602885786e-02,	(float) -1.562614867e-02,
		(float)  1.376592048e-02,	(float) -8.805348172e-03,
		(float) -6.842046842e-03,	(float)  4.705638549e-01,
		(float)  6.209032012e-02,	(float) -4.144311322e-02,
		(float)  3.369949344e-02,	(float) -2.879062654e-02,
		(float)  2.487880933e-02,	(float) -2.142209684e-02,
		(float)  1.823970511e-02,	(float) -1.528104994e-02,
		(float)  1.254723402e-02,	(float) -1.005809751e-02,
		(float)  7.836325809e-03,	(float) -5.899284692e-03,
		(float)  4.255011580e-03,	(float) -2.900769595e-03,
		(float)  1.823311706e-03,	(float) -1.000296699e-03,
		(float)  4.024267590e-04,	(float)  4.053871899e-06,
		(float) -2.548046147e-04,	(float)  3.850271195e-04,
		(float) -4.274821672e-04,	(float)  4.110033110e-04,
		(float) -3.595590597e-04,	(float)  2.918545676e-04,
		(float) -2.214134687e-04,	(float)  1.570440987e-04,
		(float) -1.035735847e-04,	(float)  6.272800811e-05,
		(float) -3.404527478e-05,	(float)  1.572638470e-05,
		(float) -5.356645072e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 120 */
		(float)  0.000000000e+00,	(float)  1.487442176e-05,
		(float) -3.115230852e-05,	(float)  5.471462620e-05,
		(float) -8.529158430e-05,	(float)  1.207408383e-04,
		(float) -1.563218994e-04,	(float)  1.840231067e-04,
		(float) -1.920440841e-04,	(float)  1.645433837e-04,
		(float) -8.175536958e-05,	(float) -7.943908782e-05,
		(float)  3.444366332e-04,	(float) -7.393233225e-04,
		(float)  1.288819764e-03,	(float) -2.013859072e-03,
		(float)  2.928946510e-03,	(float) -4.039486379e-03,
		(float)  5.339277711e-03,	(float) -6.808366706e-03,
		(float)  8.411390278e-03,	(float) -1.009643479e-02,
		(float)  1.179423413e-02,	(float) -1.341716266e-02,
		(float)  1.485673411e-02,	(float) -1.597660262e-02,
		(float)  1.659347109e-02,	(float) -1.642375484e-02,
		(float)  1.491673052e-02,	(float) -1.058875392e-02,
		(float) -3.426134025e-03,	(float)  4.712902703e-01,
		(float)  5.788722176e-02,	(float) -3.964207078e-02,
		(float)  3.266391964e-02,	(float) -2.814517379e-02,
		(float)  2.447378135e-02,	(float) -2.117940449e-02,
		(float)  1.811120484e-02,	(float) -1.523360788e-02,
		(float)  1.255640863e-02,	(float) -1.010515779e-02,
		(float)  7.906715011e-03,	(float) -5.981750936e-03,
		(float)  4.341051610e-03,	(float) -2.984215953e-03,
		(float)  1.899981143e-03,	(float) -1.067662876e-03,
		(float)  4.593045492e-04,	(float) -4.218783514e-05,
		(float) -2.185945334e-04,	(float)  3.577501788e-04,
		(float) -4.077688070e-04,	(float)  3.973949069e-04,
		(float) -3.506462945e-04,	(float)  2.863727121e-04,
		(float) -2.182980634e-04,	(float)  1.554528347e-04,
		(float) -1.028816577e-04,	(float)  6.250481584e-05,
		(float) -3.402009786e-05,	(float)  1.574979254e-05,
		(float) -5.363002132e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 121 */
		(float)  0.000000000e+00,	(float)  1.499229996e-05,
		(float) -3.145639446e-05,	(float)  5.541316440e-05,
		(float) -8.671244170e-05,	(float)  1.233554121e-04,
		(float) -1.607587019e-04,	(float)  1.910644695e-04,
		(float) -2.025993191e-04,	(float)  1.795923872e-04,
		(float) -1.022581283e-04,	(float) -5.266938806e-05,
		(float)  3.108963437e-04,	(float) -6.990131833e-04,
		(float)  1.242465049e-03,	(float) -1.963145705e-03,
		(float)  2.876762524e-03,	(float) -3.990158709e-03,
		(float)  5.298797685e-03,	(float) -6.784605003e-03,
		(float)  8.414315450e-03,	(float) -1.013837244e-02,
		(float)  1.189024412e-02,	(float) -1.358568682e-02,
		(float)  1.512081893e-02,	(float) -1.636634298e-02,
		(float)  1.715118536e-02,	(float) -1.721593061e-02,
		(float)  1.606577636e-02,	(float) -1.238044179e-02,
		(float)  4.274772325e-05,	(float)  4.719317848e-01,
		(float)  5.372294023e-02,	(float) -3.783451796e-02,
		(float)  3.161655555e-02,	(float) -2.748736492e-02,
		(float)  2.405703361e-02,	(float) -2.092605903e-02,
		(float)  1.797329068e-02,	(float) -1.517804551e-02,
		(float)  1.255874166e-02,	(float) -1.014659353e-02,
		(float)  7.972601929e-03,	(float) -6.060719641e-03,
		(float)  4.424467720e-03,	(float) -3.065775330e-03,
		(float)  1.975365358e-03,	(float) -1.134217764e-03,
		(float)  5.157290192e-04,	(float) -8.823317474e-05,
		(float) -1.824082640e-04,	(float)  3.303918879e-04,
		(float) -3.879200346e-04,	(float)  3.836333946e-04,
		(float) -3.415864885e-04,	(float)  2.807634754e-04,
		(float) -2.150808425e-04,	(float)  1.537858748e-04,
		(float) -1.021373928e-04,	(float)  6.224821141e-05,
		(float) -3.397555452e-05,	(float)  1.576336455e-05,
		(float) -5.365355669e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 122 */
		(float)  0.000000000e+00,	(float)  1.510249615e-05,
		(float) -3.174526014e-05,	(float)  5.608615405e-05,
		(float) -8.809519453e-05,	(float)  1.259186655e-04,
		(float) -1.651332213e-04,	(float)  1.980394024e-04,
		(float) -2.130972211e-04,	(float)  1.946147705e-04,
		(float) -1.227967988e-04,	(float) -2.575773276e-05,
		(float)  2.770519576e-04,	(float) -6.581680837e-04,
		(float)  1.195264211e-03,	(float) -1.911185512e-03,
		(float)  2.822835964e-03,	(float) -3.938497375e-03,
		(float)  5.255303907e-03,	(float) -6.757074848e-03,
		(float)  8.412666636e-03,	(float) -1.017491441e-02,
		(float)  1.198006830e-02,	(float) -1.374733110e-02,
		(float)  1.537751525e-02,	(float) -1.674850468e-02,
		(float)  1.770167322e-02,	(float) -1.800222598e-02,
		(float)  1.721243638e-02,	(float) -1.417955040e-02,
		(float)  3.563873000e-03,	(float)  4.724881889e-01,
		(float)  4.959850965e-02,	(float) -3.602142962e-02,
		(float)  3.055802171e-02,	(float) -2.681760727e-02,
		(float)  2.362883513e-02,	(float) -2.066223372e-02,
		(float)  1.782606725e-02,	(float) -1.511441770e-02,
		(float)  1.255425220e-02,	(float) -1.018239887e-02,
		(float)  8.033964128e-03,	(float) -6.136158407e-03,
		(float)  4.505222612e-03,	(float) -3.145409310e-03,
		(float)  2.049427501e-03,	(float) -1.199927843e-03,
		(float)  5.716709932e-04,	(float) -1.340577265e-04,
		(float) -1.462655064e-04,	(float)  3.029675724e-04,
		(float) -3.679473412e-04,	(float)  3.697270649e-04,
		(float) -3.323853822e-04,	(float)  2.750306580e-04,
		(float) -2.117642009e-04,	(float)  1.520446483e-04,
		(float) -1.013415938e-04,	(float)  6.195862129e-05,
		(float) -3.391186212e-05,	(float)  1.576721363e-05,
		(float) -5.363772275e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 123 */
		(float)  0.000000000e+00,	(float)  1.520484033e-05,
		(float) -3.201857752e-05,	(float)  5.673298582e-05,
		(float) -8.943876969e-05,	(float)  1.284288106e-04,
		(float) -1.694426327e-04,	(float)  2.049436540e-04,
		(float) -2.235316755e-04,	(float)  2.096021036e-04,
		(float) -1.433602187e-04,	(float)  1.281669604e-06,
		(float)  2.429208532e-04,	(float) -6.168084043e-04,
		(float)  1.147240062e-03,	(float) -1.858002632e-03,
		(float)  2.767190548e-03,	(float) -3.884523143e-03,
		(float)  5.208810779e-03,	(float) -6.725779853e-03,
		(float)  8.406431111e-03,	(float) -1.020602483e-02,
		(float)  1.206363935e-02,	(float) -1.390198666e-02,
		(float)  1.562666025e-02,	(float) -1.712285483e-02,
		(float)  1.824460985e-02,	(float) -1.878219208e-02,
		(float)  1.835608683e-02,	(float) -1.598520827e-02,
		(float)  7.136494059e-03,	(float)  4.729593005e-01,
		(float)  4.551494557e-02,	(float) -3.420377570e-02,
		(float)  2.948894096e-02,	(float) -2.613631266e-02,
		(float)  2.318946002e-02,	(float) -2.038810685e-02,
		(float)  1.766964386e-02,	(float) -1.504278350e-02,
		(float)  1.254296300e-02,	(float) -1.021257098e-02,
		(float)  8.090781700e-03,	(float) -6.208036852e-03,
		(float)  4.583280551e-03,	(float) -3.223080647e-03,
		(float)  2.122131564e-03,	(float) -1.264760172e-03,
		(float)  6.271016632e-04,	(float) -1.796372821e-04,
		(float) -1.101858587e-04,	(float)  2.754925303e-04,
		(float) -3.478622358e-04,	(float)  3.556842499e-04,
		(float) -3.230487658e-04,	(float)  2.691781090e-04,
		(float) -2.083505752e-04,	(float)  1.502306166e-04,
		(float) -1.004950881e-04,	(float)  6.163648768e-05,
		(float) -3.382924749e-05,	(float)  1.576145765e-05,
		(float) -5.358320610e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 124 */
		(float)  0.000000000e+00,	(float)  1.529916560e-05,
		(float) -3.227602483e-05,	(float)  5.735306066e-05,
		(float) -9.074210878e-05,	(float)  1.308840782e-04,
		(float) -1.736841304e-04,	(float)  2.117729888e-04,
		(float) -2.338965716e-04,	(float)  2.245459356e-04,
		(float) -1.639371619e-04,	(float)  2.843448040e-05,
		(float)  2.085206357e-04,	(float) -5.749548853e-04,
		(float)  1.098415943e-03,	(float) -1.803621957e-03,
		(float)  2.709851010e-03,	(float) -3.828258112e-03,
		(float)  5.159334383e-03,	(float) -6.690725693e-03,
		(float)  8.395598608e-03,	(float) -1.023167068e-02,
		(float)  1.214089317e-02,	(float) -1.404954817e-02,
		(float)  1.586809469e-02,	(float) -1.748916398e-02,
		(float)  1.877967330e-02,	(float) -1.955538148e-02,
		(float)  1.949610214e-02,	(float) -1.779653426e-02,
		(float)  1.075984102e-02,	(float)  4.733449657e-01,
		(float)  4.147324467e-02,	(float) -3.238252079e-02,
		(float)  2.840993816e-02,	(float) -2.544389723e-02,
		(float)  2.273918733e-02,	(float) -2.010386168e-02,
		(float)  1.750413444e-02,	(float) -1.496320611e-02,
		(float)  1.252490040e-02,	(float) -1.023711014e-02,
		(float)  8.143037263e-03,	(float) -6.276326622e-03,
		(float)  4.658607381e-03,	(float) -3.298753282e-03,
		(float)  2.193442398e-03,	(float) -1.328682400e-03,
		(float)  6.819926034e-04,	(float) -2.249478578e-04,
		(float) -7.418880769e-05,	(float)  2.479820242e-04,
		(float) -3.276762384e-04,	(float)  3.415133175e-04,
		(float) -3.135824751e-04,	(float)  2.632097227e-04,
		(float) -2.048424419e-04,	(float)  1.483452732e-04,
		(float) -9.959872616e-05,	(float)  6.128226812e-05,
		(float) -3.372794667e-05,	(float)  1.574621933e-05,
		(float) -5.349071327e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 125 */
		(float)  0.000000000e+00,	(float)  1.538530842e-05,
		(float) -3.251728687e-05,	(float)  5.794579028e-05,
		(float) -9.200416882e-05,	(float)  1.332827184e-04,
		(float) -1.778549307e-04,	(float)  2.185231904e-04,
		(float) -2.441858065e-04,	(float)  2.394377997e-04,
		(float) -1.845163447e-04,	(float)  5.568623822e-05,
		(float)  1.738691283e-04,	(float) -5.326286165e-04,
		(float)  1.048815723e-03,	(float) -1.748069122e-03,
		(float)  2.650843094e-03,	(float) -3.769725704e-03,
		(float)  5.106892483e-03,	(float) -6.651920112e-03,
		(float)  8.380161339e-03,	(float) -1.025182181e-02,
		(float)  1.221176891e-02,	(float) -1.418991379e-02,
		(float)  1.610166299e-02,	(float) -1.784720622e-02,
		(float)  1.930654459e-02,	(float) -2.032134838e-02,
		(float)  2.063185525e-02,	(float) -1.961263782e-02,
		(float)  1.443312211e-02,	(float)  4.736450583e-01,
		(float)  3.747438446e-02,	(float) -3.055862378e-02,
		(float)  2.732163979e-02,	(float) -2.474078112e-02,
		(float)  2.227830087e-02,	(float) -1.980968624e-02,
		(float)  1.732965746e-02,	(float) -1.487575285e-02,
		(float)  1.250009438e-02,	(float) -1.025601965e-02,
		(float)  8.190715969e-03,	(float) -6.341001401e-03,
		(float)  4.731170538e-03,	(float) -3.372392362e-03,
		(float)  2.263325729e-03,	(float) -1.391662786e-03,
		(float)  7.363157848e-04,	(float) -2.699657072e-04,
		(float) -3.829371793e-05,	(float)  2.204512724e-04,
		(float) -3.074008736e-04,	(float)  3.272226672e-04,
		(float) -3.039923885e-04,	(float)  2.571294371e-04,
		(float) -2.012423155e-04,	(float)  1.463901418e-04,
		(float) -9.865338060e-05,	(float)  6.089643504e-05,
		(float) -3.360820471e-05,	(float)  1.572162609e-05,
		(float) -5.336096992e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 126 */
		(float)  0.000000000e+00,	(float)  1.546310865e-05,
		(float) -3.274205521e-05,	(float)  5.851059754e-05,
		(float) -9.322392289e-05,	(float)  1.356230022e-04,
		(float) -1.819522726e-04,	(float)  2.251900631e-04,
		(float) -2.543932881e-04,	(float)  2.542692175e-04,
		(float) -2.050864321e-04,	(float)  8.302236637e-05,
		(float)  1.389843633e-04,	(float) -4.898510274e-04,
		(float)  9.984637789e-04,	(float) -1.691370491e-03,
		(float)  2.590193546e-03,	(float) -3.708950655e-03,
		(float)  5.051504518e-03,	(float) -6.609372926e-03,
		(float)  8.360114001e-03,	(float) -1.026645097e-02,
		(float)  1.227620898e-02,	(float) -1.432298530e-02,
		(float)  1.632721333e-02,	(float) -1.819675935e-02,
		(float)  1.982490796e-02,	(float) -2.107964888e-02,
		(float)  2.176271788e-02,	(float) -2.143261938e-02,
		(float)  1.815552385e-02,	(float)  4.738594804e-01,
		(float)  3.351932291e-02,	(float) -2.873303744e-02,
		(float)  2.622467370e-02,	(float) -2.402738829e-02,
		(float)  2.180708905e-02,	(float) -1.950577331e-02,
		(float)  1.714633584e-02,	(float) -1.478049507e-02,
		(float)  1.246857844e-02,	(float) -1.026930587e-02,
		(float)  8.233805498e-03,	(float) -6.402036918e-03,
		(float)  4.800939064e-03,	(float) -3.443964251e-03,
		(float)  2.331748178e-03,	(float) -1.453670208e-03,
		(float)  7.900435885e-04,	(float) -3.146673325e-04,
		(float) -2.519821855e-06,	(float)  1.929154413e-04,
		(float) -2.870476646e-04,	(float)  3.128207250e-04,
		(float) -2.942844233e-04,	(float)  2.509412307e-04,
		(float) -1.975527474e-04,	(float)  1.443667758e-04,
		(float) -9.765994584e-05,	(float)  6.047947544e-05,
		(float) -3.347027544e-05,	(float)  1.568780995e-05,
		(float) -5.319472005e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 127 */
		(float)  0.000000000e+00,	(float)  1.553240977e-05,
		(float) -3.295002849e-05,	(float)  5.904691691e-05,
		(float) -9.440036096e-05,	(float)  1.379032221e-04,
		(float) -1.859734204e-04,	(float)  2.317694350e-04,
		(float) -2.645129390e-04,	(float)  2.690317042e-04,
		(float) -2.256360436e-04,	(float)  1.104281805e-04,
		(float)  1.038845730e-04,	(float) -4.466438759e-04,
		(float)  9.473849899e-04,	(float) -1.633553150e-03,
		(float)  2.527930095e-03,	(float) -3.645959007e-03,
		(float)  4.993191596e-03,	(float) -6.563096021e-03,
		(float)  8.335453790e-03,	(float) -1.027553384e-02,
		(float)  1.233415915e-02,	(float) -1.444866814e-02,
		(float)  1.654459775e-02,	(float) -1.853760500e-02,
		(float)  2.033445104e-02,	(float) -2.182984120e-02,
		(float)  2.288806087e-02,	(float) -2.325557066e-02,
		(float)  2.192621133e-02,	(float)  4.739881616e-01,
		(float)  2.960899822e-02,	(float) -2.690670807e-02,
		(float)  2.511966874e-02,	(float) -2.330414627e-02,
		(float)  2.132584473e-02,	(float) -1.919232021e-02,
		(float)  1.695429691e-02,	(float) -1.467750817e-02,
		(float)  1.243038963e-02,	(float) -1.027697820e-02,
		(float)  8.272296064e-03,	(float) -6.459410955e-03,
		(float)  4.867883618e-03,	(float) -3.513436548e-03,
		(float)  2.398677268e-03,	(float) -1.514674184e-03,
		(float)  8.431488202e-04,	(float) -3.590294973e-04,
		(float)  3.311379034e-05,	(float)  1.653896368e-04,
		(float) -2.666281263e-04,	(float)  2.983159385e-04,
		(float) -2.844645322e-04,	(float)  2.446491207e-04,
		(float) -1.937763239e-04,	(float)  1.422767567e-04,
		(float) -9.661933723e-05,	(float)  6.003189045e-05,
		(float) -3.331442121e-05,	(float)  1.564490732e-05,
		(float) -5.299272524e-06,	(float)  0.000000000e+00
	},
	{ /* Polyphase 128 */
		(float) -5.275576381e-06,	(float)  1.559305896e-05,
		(float) -3.314091266e-05,	(float)  5.955419489e-05,
		(float) -9.553249050e-05,	(float)  1.401216937e-04,
		(float) -1.899156645e-04,	(float)  2.382571600e-04,
		(float) -2.745386997e-04,	(float)  2.837167727e-04,
		(float) -2.461537593e-04,	(float)  1.378888961e-04,
		(float)  6.858818064e-05,	(float) -4.030292381e-04,
		(float)  8.956047228e-04,	(float) -1.574644886e-03,
		(float)  2.464081446e-03,	(float) -3.580778098e-03,
		(float)  4.931976487e-03,	(float) -6.513103355e-03,
		(float)  8.306180406e-03,	(float) -1.027904905e-02,
		(float)  1.238556852e-02,	(float) -1.456687145e-02,
		(float)  1.675367227e-02,	(float) -1.886952873e-02,
		(float)  2.083486500e-02,	(float) -2.257148593e-02,
		(float)  2.400725449e-02,	(float) -2.508057509e-02,
		(float)  2.574432846e-02,	(float)  4.740310601e-01,
		(float)  2.574432846e-02,	(float) -2.508057509e-02,
		(float)  2.400725449e-02,	(float) -2.257148593e-02,
		(float)  2.083486500e-02,	(float) -1.886952873e-02,
		(float)  1.675367227e-02,	(float) -1.456687145e-02,
		(float)  1.238556852e-02,	(float) -1.027904905e-02,
		(float)  8.306180406e-03,	(float) -6.513103355e-03,
		(float)  4.931976487e-03,	(float) -3.580778098e-03,
		(float)  2.464081446e-03,	(float) -1.574644886e-03,
		(float)  8.956047228e-04,	(float) -4.030292381e-04,
		(float)  6.858818064e-05,	(float)  1.378888961e-04,
		(float) -2.461537593e-04,	(float)  2.837167727e-04,
		(float) -2.745386997e-04,	(float)  2.382571600e-04,
		(float) -1.899156645e-04,	(float)  1.401216937e-04,
		(float) -9.553249050e-05,	(float)  5.955419489e-05,
		(float) -3.314091266e-05,	(float)  1.559305896e-05,
		(float)  0.000000000e+00,	(float)  0.000000000e+00
	}
};

#endif /*__RN_SRC_COEFFS_H__*/
